/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.wizard;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.LanguageInfo;
import com.sap.ide.metamodel.general.i18n.ResourceTypeEnum;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.tools.merge.dialog.AddNewLanguageDialog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EditTranslatableTextsWizardPage
extends WizardPage
implements SelectionListener {
    public static final String RAW_LANGUAGE_DESCRIPTION = "RAW Language (raw)";
    private MainDevelopmentObject mMDO;
    private static final String[] TABLECOLUMNS = new String[]{"", "object", "attribute", "text", "donottranslate", "maxlength", "resourcetype"};
    private TableViewer mTableViewer;
    private int mSelectedColumnIndex;
    private String mSelectedLanguage;
    private ArrayList mResourceTypeStrings;
    private Combo mAvailableLanguagesCombo;
    private Button mDeleteLanguageButton;

    public EditTranslatableTextsWizardPage(MainDevelopmentObject lMDO) {
        super("edit_translatable_texts_wizard_page");
        this.mMDO = lMDO;
        this.mSelectedLanguage = "";
        this.mResourceTypeStrings = new ArrayList();
        this.setTitle("Edit translatable text");
        this.setDescription("This MDO contains the following translatable texts:");
    }

    public void createControl(Composite parent) {
        Composite lComposite = new Composite(parent, 0);
        lComposite.setLayout((Layout)new GridLayout(1, false));
        Composite lComboComposite = new Composite(lComposite, 0);
        lComboComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        lComboComposite.setLayoutData((Object)gridData);
        Label lLabel = new Label(lComboComposite, 0);
        lLabel.setText("Select Language: ");
        this.mAvailableLanguagesCombo = new Combo(lComboComposite, 8);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.mAvailableLanguagesCombo.setLayoutData((Object)gridData);
        this.mAvailableLanguagesCombo.addSelectionListener((SelectionListener)this);
        Label lMasterLanguageLabel = new Label(lComboComposite, 0);
        lMasterLanguageLabel.setText("Master Language: " + this.mMDO.getMasterLanguage());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 3;
        lMasterLanguageLabel.setLayoutData((Object)gridData);
        int style = 101124;
        Table table = new Table(lComposite, style);
        this.mTableViewer = new TableViewer(table);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setWidth(20);
        column = new TableColumn(table, 16384, 1);
        column.setText("Object");
        column.setWidth(130);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTranslatableTextsWizardPage.this.mTableViewer.setSorter((ViewerSorter)new TranslatableTextTableSorter(4));
            }
        });
        column = new TableColumn(table, 16384, 2);
        column.setText("Attribute");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTranslatableTextsWizardPage.this.mTableViewer.setSorter((ViewerSorter)new TranslatableTextTableSorter(2));
            }
        });
        column = new TableColumn(table, 16384, 3);
        column.setText("Text");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTranslatableTextsWizardPage.this.mTableViewer.setSorter((ViewerSorter)new TranslatableTextTableSorter(1));
            }
        });
        column = new TableColumn(table, 0x1000000, 4);
        column.setText("Do not Translate");
        column.setWidth(90);
        column = new TableColumn(table, 16384, 5);
        column.setText("Max Length");
        column.setWidth(70);
        column = new TableColumn(table, 16384, 6);
        column.setText("Resource Type");
        column.setWidth(120);
        CellEditor[] editors = new CellEditor[TABLECOLUMNS.length];
        TextCellEditor attributeCellEditor = new TextCellEditor((Composite)table);
        TextCellEditor objectCellEditor = new TextCellEditor((Composite)table);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)table);
        TextCellEditor flagCellEditor = new TextCellEditor((Composite)table);
        CheckboxCellEditor doNotTranslateCellEditor = new CheckboxCellEditor((Composite)table);
        TextCellEditor maxLengthCellEditor = new TextCellEditor((Composite)table);
        ArrayList resourceTypes = ResourceTypeEnum.getValues();
        Iterator iter = ((AbstractList)resourceTypes).iterator();
        while (iter.hasNext()) {
            ResourceTypeEnum element = (ResourceTypeEnum)iter.next();
            this.mResourceTypeStrings.add(element.toString());
        }
        ComboBoxCellEditor resourceTypeCellEditor = new ComboBoxCellEditor((Composite)table, this.mResourceTypeStrings.toArray(new String[0]));
        editors[0] = flagCellEditor;
        editors[1] = objectCellEditor;
        editors[2] = attributeCellEditor;
        editors[3] = textCellEditor;
        editors[4] = doNotTranslateCellEditor;
        editors[5] = maxLengthCellEditor;
        editors[6] = resourceTypeCellEditor;
        this.mTableViewer.setUseHashlookup(true);
        this.mTableViewer.setColumnProperties(TABLECOLUMNS);
        this.mTableViewer.setCellEditors(editors);
        this.mTableViewer.setCellModifier((ICellModifier)new TranslatableTextCellModifier());
        this.mTableViewer.setContentProvider((IContentProvider)new TranslatableTextTableContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new TranslatableTextTableLabelProvider());
        this.mTableViewer.setInput((Object)this.mMDO);
        Composite lAddDeleteComposite = new Composite(lComposite, 0);
        lAddDeleteComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        lAddDeleteComposite.setLayoutData((Object)gridData);
        Button lAddLanguageButton = new Button(lAddDeleteComposite, 8);
        lAddLanguageButton.setText("Add new language...");
        lAddLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddNewLanguageDialog lDialog = new AddNewLanguageDialog(EditTranslatableTextsWizardPage.this.getShell(), EditTranslatableTextsWizardPage.this.mMDO);
                String lResult = lDialog.open();
                if (lResult != null) {
                    TranslatableText[] lTexts = EditTranslatableTextsWizardPage.this.mMDO.getTextPool().getTexts();
                    int i = 0;
                    while (i < lTexts.length) {
                        lTexts[i].setText(lResult, "enter translation");
                        ++i;
                    }
                    EditTranslatableTextsWizardPage.this.mSelectedLanguage = lResult;
                    EditTranslatableTextsWizardPage.this.updateControls();
                }
            }
        });
        this.mDeleteLanguageButton = new Button(lAddDeleteComposite, 8);
        this.mDeleteLanguageButton.setText("Delete selected language...");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 3;
        this.mDeleteLanguageButton.setLayoutData((Object)gridData);
        this.mDeleteLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox lConfirmation = new MessageBox(EditTranslatableTextsWizardPage.this.getShell(), 192);
                lConfirmation.setText("Confirm deletion of language");
                lConfirmation.setMessage("Do you really want to delete the language \"" + EditTranslatableTextsWizardPage.getLanguageDescriptionByName(EditTranslatableTextsWizardPage.this.mSelectedLanguage) + "\" ?");
                int lResult = lConfirmation.open();
                if (lResult == 64) {
                    try {
                        EditTranslatableTextsWizardPage.this.mMDO.getTextPool().deleteLanguage(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                    }
                    catch (DeleteException e1) {
                        e1.printStackTrace();
                    }
                    EditTranslatableTextsWizardPage.this.mSelectedLanguage = "";
                    EditTranslatableTextsWizardPage.this.updateControls();
                }
            }
        });
        this.updateControls();
        this.setControl((Control)lComposite);
    }

    public static String getLanguageDescriptionByName(String name) {
        LanguageInfo[] lAllLanguageInfos = null;
        try {
            lAllLanguageInfos = I18NService.getInstance().getValidLanguages();
        }
        catch (I18NException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < lAllLanguageInfos.length) {
            if (lAllLanguageInfos[i].getName().equals(name)) {
                return lAllLanguageInfos[i].getDescription() + " (" + lAllLanguageInfos[i].getName() + ")";
            }
            ++i;
        }
        return RAW_LANGUAGE_DESCRIPTION;
    }

    public void fillAvailableLanguagesCombo() {
        String[] lAvailableLanguages = this.mMDO.getMDO().getTextPool().getAvailableLanguages();
        ArrayList<String> lComboText = new ArrayList<String>();
        int i = 0;
        while (i < lAvailableLanguages.length) {
            if (lAvailableLanguages[i].equals("")) {
                lComboText.add(RAW_LANGUAGE_DESCRIPTION);
            } else {
                lComboText.add(EditTranslatableTextsWizardPage.getLanguageDescriptionByName(lAvailableLanguages[i]));
            }
            ++i;
        }
        this.mAvailableLanguagesCombo.setItems(lComboText.toArray(new String[0]));
    }

    private List getTableColumns() {
        return Arrays.asList(TABLECOLUMNS);
    }

    public void widgetSelected(SelectionEvent e) {
        int index = ((Combo)e.widget).getSelectionIndex();
        this.mSelectedLanguage = this.mMDO.getMDO().getTextPool().getAvailableLanguages()[index];
        this.updateControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void updateControls() {
        this.mTableViewer.refresh(true);
        this.mDeleteLanguageButton.setEnabled(!this.mMDO.getTextPool().isReadOnly(this.mSelectedLanguage) && !this.mSelectedLanguage.equals(""));
        this.fillAvailableLanguagesCombo();
        this.mAvailableLanguagesCombo.update();
        this.mAvailableLanguagesCombo.select(this.mAvailableLanguagesCombo.indexOf(EditTranslatableTextsWizardPage.getLanguageDescriptionByName(this.mSelectedLanguage)));
    }

    class TranslatableTextTableSorter
    extends ViewerSorter {
        public static final int TEXT = 1;
        public static final int ATTRIBUTE = 2;
        public static final int LANGUAGE = 3;
        public static final int OBJECT = 4;
        private int criteria;

        public TranslatableTextTableSorter(int criteria) {
            this.criteria = criteria;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            TranslatableText lText1 = (TranslatableText)o1;
            TranslatableText lText2 = (TranslatableText)o2;
            switch (this.criteria) {
                case 1: {
                    return this.collator.compare(lText1.getText(), lText2.getText());
                }
                case 2: {
                    String lAttr1 = lText1.getAttributeName();
                    String lAttr2 = lText2.getAttributeName();
                    return this.collator.compare(lAttr1, lAttr2);
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    String lObject1 = lText1.getKey();
                    String lObject2 = lText2.getKey();
                    return this.collator.compare(lObject1, lObject2);
                }
            }
            return 0;
        }
    }

    class TranslatableTextCellModifier
    implements ICellModifier {
        TranslatableTextCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            TranslatableText lText = (TranslatableText)element;
            int index = EditTranslatableTextsWizardPage.this.getTableColumns().indexOf(property);
            boolean result = true;
            switch (index) {
                case 0: {
                    result = false;
                    break;
                }
                case 1: {
                    result = false;
                    break;
                }
                case 2: {
                    result = false;
                    break;
                }
                case 3: {
                    if (!EditTranslatableTextsWizardPage.this.mSelectedLanguage.equals("")) {
                        result = !lText.isReadOnly(EditTranslatableTextsWizardPage.this.mSelectedLanguage) && !lText.getDoNotTranslate();
                        break;
                    }
                    result = !lText.isReadOnly(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                    break;
                }
                case 4: {
                    result = !lText.isReadOnly(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                    break;
                }
                case 5: {
                    result = !lText.isReadOnly(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                    break;
                }
                case 6: {
                    result = !lText.isReadOnly(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                }
            }
            return result;
        }

        public Object getValue(Object element, String property) {
            EditTranslatableTextsWizardPage.this.setPageComplete(false);
            TranslatableText lText = (TranslatableText)element;
            EditTranslatableTextsWizardPage.this.mSelectedColumnIndex = EditTranslatableTextsWizardPage.this.getTableColumns().indexOf(property);
            switch (EditTranslatableTextsWizardPage.this.mSelectedColumnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return lText.getKey();
                }
                case 2: {
                    return lText.getAttributeName();
                }
                case 3: {
                    return lText.getText(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                }
                case 4: {
                    return new Boolean(lText.getDoNotTranslate());
                }
                case 5: {
                    return new Integer(lText.getMaxLength()).toString();
                }
                case 6: {
                    String lResourceType = lText.getResourceType().toString();
                    int lResourceTypeIndex = EditTranslatableTextsWizardPage.this.mResourceTypeStrings.indexOf(lResourceType);
                    return new Integer(lResourceTypeIndex);
                }
            }
            return new Object();
        }

        public void modify(Object element, String property, Object value) {
            TranslatableText lText = (TranslatableText)((Item)element).getData();
            switch (EditTranslatableTextsWizardPage.this.mSelectedColumnIndex) {
                case 3: {
                    lText.setText(EditTranslatableTextsWizardPage.this.mSelectedLanguage, value.toString());
                    break;
                }
                case 4: {
                    lText.setDoNotTranslate(((Boolean)value).booleanValue());
                    break;
                }
                case 5: {
                    lText.setMaxLength(new Integer((String)value).intValue());
                    break;
                }
                case 6: {
                    String lResourceTypeIndex = EditTranslatableTextsWizardPage.this.mResourceTypeStrings.get((Integer)value).toString();
                    ResourceTypeEnum lResourceType = ResourceTypeEnum.valueOf((String)lResourceTypeIndex);
                    lText.setResourceType(lResourceType);
                }
            }
            EditTranslatableTextsWizardPage.this.mTableViewer.refresh(true);
            EditTranslatableTextsWizardPage.this.setPageComplete(true);
            EditTranslatableTextsWizardPage.this.getWizard().getContainer().updateButtons();
        }
    }

    class TranslatableTextTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TranslatableTextTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            TranslatableText lText = (TranslatableText)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    DevelopmentObject lObject = lText.getDevelopmentObject();
                    String lObjectName = "null";
                    if (lObject != null) {
                        lObjectName = lObject instanceof MainDevelopmentObject ? lObject.getName() : lText.getKey().substring(0, lText.getKey().indexOf("@"));
                    }
                    return lObjectName;
                }
                case 2: {
                    return lText.getAttributeName();
                }
                case 3: {
                    return lText.getText(EditTranslatableTextsWizardPage.this.mSelectedLanguage);
                }
                case 4: {
                    return "";
                }
                case 5: {
                    return new Integer(lText.getMaxLength()).toString();
                }
                case 6: {
                    return lText.getResourceType().toString();
                }
            }
            return "";
        }
    }

    class TranslatableTextTableContentProvider
    implements IStructuredContentProvider {
        TranslatableTextTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return EditTranslatableTextsWizardPage.this.mMDO.getTextPool().getTexts();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

