/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.tree;

import com.sap.ide.metamodel.tools.merge.editor.ConflictingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.editor.compare.LinkContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.SelectionContribution;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeDeltaMDO;
import com.sap.ide.metamodel.tools.merge.tree.MMTreeLabelProvider;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.decorator.ExtendedLinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TreeConflictComposite {
    private Label ancestorLabel;
    private TreeViewer ancestorTreeViewer;
    private TreeViewerView[] treeViewers;
    private SashForm wholeSplitter;
    private boolean dialogClosed = false;
    private DifferenceStorage[] dsToAncestor = new DifferenceStorage[2];
    private LinkContribution contribution;
    private TreeMappingComposite treeMappingComposite;
    private ConflictingNodesManager manager;

    public TreeConflictComposite(Composite parent, ConflictingNodesManager manager) {
        this(parent, 0, manager);
    }

    public TreeConflictComposite(Composite parent, int style, ConflictingNodesManager manager) {
        this.treeViewers = new TreeViewerView[3];
        Composite wholeComposite = new Composite(parent, style);
        this.manager = manager;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        wholeComposite.setLayout((Layout)gl);
        wholeComposite.setLayoutData((Object)new GridData(1808));
        this.wholeSplitter = new SashForm(wholeComposite, 512);
        this.wholeSplitter.setLayoutData((Object)new GridData(1808));
        Composite ancestorComposite = new Composite((Composite)this.wholeSplitter, style);
        ancestorComposite.setLayout((Layout)new GridLayout(1, false));
        ancestorComposite.setLayoutData((Object)new GridData(1808));
        this.ancestorLabel = new Label(ancestorComposite, 0);
        SashForm treeSplitter = new SashForm(ancestorComposite, 512);
        treeSplitter.setLayout((Layout)gl);
        treeSplitter.setLayoutData((Object)new GridData(1808));
        this.ancestorTreeViewer = new TreeViewer((Composite)treeSplitter);
        Composite inter = new Composite((Composite)this.wholeSplitter, 0);
        inter.setLayout((Layout)gl);
        inter.setLayoutData((Object)new GridData(1808));
        this.treeMappingComposite = new TreeMappingComposite(inter, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.treeMappingComposite.setLayout((Layout)gl);
        this.treeMappingComposite.setLayoutData((Object)new GridData(1808));
        this.treeMappingComposite.setExpandLevel(0, 0);
        this.treeMappingComposite.setVisibleExtensionLine(true);
        this.treeMappingComposite.setDrawShapesOfHiddenNodes(true);
        this.treeMappingComposite.setHeaderVisible(true);
        this.treeMappingComposite.setEnableMappingContextMenu(false);
        this.wholeSplitter.setWeights(new int[]{1, 2});
        this.wholeSplitter.SASH_WIDTH = 1;
        this.treeMappingComposite.setLinkDecorator((LinkDecorator)new ExtendedLinkDecorator(){

            private MergeDeltaMDO getDeltaFromNode(Object o) {
                DeltaAnalyser da = TreeConflictComposite.this.contribution.findCorrectDeltaVector((IMergeTreeNode)o);
                if (!da.isEmpty()) {
                    return (MergeDeltaMDO)da.getDeltas()[0];
                }
                return null;
            }

            public int getLinkType(Object source, Object target, boolean isSelected) {
                return 3;
            }

            public Color getLinkColor(Object source, Object target) {
                MergeDeltaMDO delta = this.getDeltaFromNode(source);
                return Display.getDefault().getSystemColor(5);
            }

            public Color getSelectedLinkColor(Object source, Object target) {
                MergeDeltaMDO delta = this.getDeltaFromNode(source);
                return Display.getDefault().getSystemColor(3);
            }

            public Color getExtendedLinkColor(Object source, Object target, boolean isSelected, int tree) {
                if (isSelected) {
                    return Display.getDefault().getSystemColor(3);
                }
                return Display.getDefault().getSystemColor(5);
            }

            public int getExtendedLinkType(Object source, Object target, boolean isSelected, int tree) {
                return 1;
            }
        });
    }

    public TreeViewerView getTreeViewer(int usage) {
        return this.treeViewers[usage];
    }

    public void refresh() {
        int i = 0;
        while (i <= 1) {
            this.treeViewers[i].refresh();
            ++i;
        }
        this.drawAllLinks();
    }

    private void drawAllLinks() {
        MappingObject[] mos = this.treeMappingComposite.getMappings();
        int i = 0;
        while (i < mos.length) {
            this.treeMappingComposite.deleteLink(mos[i]);
            ++i;
        }
        Object[] all = null;
        all = this.treeMappingComposite.getAllIndependentFrames(16384);
        int i2 = 0;
        while (i2 < all.length) {
            this.treeMappingComposite.deleteShape(all[i2], 16384);
            ++i2;
        }
        all = this.treeMappingComposite.getAllIndependentFrames(131072);
        int i3 = 0;
        while (i3 < all.length) {
            this.treeMappingComposite.deleteShape(all[i3], 131072);
            ++i3;
        }
        this.contribution.drawAllLinks();
    }

    public void setDifferenceStorage(IGlobalTreeMergeManager manager) {
        this.dsToAncestor = manager.getStoragesToAncestor();
        this.treeMappingComposite.setLabelProvider((ILabelProvider)new MMTreeLabelProvider(new AbstractContribution(this.dsToAncestor[0]){}), (ILabelProvider)new MMTreeLabelProvider(new AbstractContribution(this.dsToAncestor[1]){}));
        this.treeMappingComposite.setContentProvider((ITreeContentProvider)manager.getTcpForUsage(0), (ITreeContentProvider)manager.getTcpForUsage(1));
        this.treeMappingComposite.setInput((Object)"", (Object)"");
        this.treeViewers[0] = new TreeViewerViewByTreeMappingComposite(this.treeMappingComposite, manager.getTcpForUsage(0), 0);
        this.treeViewers[1] = new TreeViewerViewByTreeMappingComposite(this.treeMappingComposite, manager.getTcpForUsage(1), 1);
        this.ancestorTreeViewer.setLabelProvider((IBaseLabelProvider)new MMTreeLabelProvider(null));
        if (manager.getTcpForUsage(2) != null) {
            this.ancestorTreeViewer.setContentProvider((IContentProvider)manager.getTcpForUsage(2));
            this.ancestorTreeViewer.setInput((Object)"");
        }
        this.treeViewers[2] = new TreeViewerViewByTreeViewer(this.ancestorTreeViewer, this.ancestorLabel, this.wholeSplitter);
        this.treeViewers[2].setVisible(false);
        this.addListeners(0, 1, manager.getLocalStorage());
        this.addListeners(1, 2, this.dsToAncestor[1]);
        this.addListeners(0, 2, this.dsToAncestor[0]);
        this.contribution = new LinkContribution(manager.getLocalStorage(), this.treeMappingComposite, this.treeViewers);
        this.drawAllLinks();
        this.ancestorLabel.setText(manager.getTreeHeaderText(2));
        this.treeMappingComposite.setLeftTreeHeader(manager.getTreeHeaderText(0), 16384);
        this.treeMappingComposite.setRightTreeHeader(manager.getTreeHeaderText(1), 16384);
    }

    private void addListeners(int tree1, int tree2, DifferenceStorage ds) {
        if (ds != null) {
            SelectionContribution sc2 = new SelectionContribution(ds, this.treeViewers[tree1], this.treeViewers[tree2]);
            SelectionContribution sc1 = new SelectionContribution(ds, this.treeViewers[tree2], this.treeViewers[tree1]);
            this.treeViewers[tree1].addSelectionChangedListener(sc2);
            this.treeViewers[tree2].addSelectionChangedListener(sc1);
            this.treeViewers[tree1].addTreeListener(sc2);
            this.treeViewers[tree2].addTreeListener(sc1);
        }
    }

    public void recompare() {
        if (this.dsToAncestor[0] != null) {
            this.dsToAncestor[0].recompare();
        }
        this.refresh();
    }

    public void setDialogClosed() {
        this.dialogClosed = true;
    }

    private boolean isDialogClosed() {
        return this.dialogClosed;
    }

    private class TreeViewerViewByTreeViewer
    extends TreeViewerViewImpl {
        private TreeViewer treeViewer;
        private Label label;
        private SashForm splitter;

        public TreeViewerViewByTreeViewer(TreeViewer treeViewer, Label label, SashForm splitter) {
            this.label = label;
            this.treeViewer = treeViewer;
            this.splitter = splitter;
        }

        public void addMenuListener(IMenuListener listener) {
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu(this.treeViewer.getControl());
            menuManager.setRemoveAllWhenShown(true);
            this.treeViewer.getControl().setMenu(menu);
            menuManager.addMenuListener(listener);
        }

        public void addSelectionChangedListener(NodeSelectedListener listener) {
            this.treeViewer.addSelectionChangedListener(this.getISelectionChangedListenerByNodeSelectedListener(listener));
        }

        public void addTreeListener(ITreeViewerListener listener) {
            this.treeViewer.addTreeListener(listener);
        }

        public Object[] getExpandedElements() {
            return this.treeViewer.getExpandedElements();
        }

        public ISelection getSelection() {
            return this.treeViewer.getSelection();
        }

        public void setExpandedElements(Object[] elements) {
            this.treeViewer.setExpandedElements(elements);
        }

        public void setExpandedState(Object element, boolean expanded) {
            this.treeViewer.setExpandedState(element, expanded);
        }

        public void setSelection(ISelection selection) {
            this.treeViewer.setSelection(selection, true);
        }

        public void clearAllSelection() {
            this.treeViewer.setSelection(new ISelection(this){
                private final /* synthetic */ TreeViewerViewByTreeViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isEmpty() {
                    return true;
                }
            });
        }

        public void refresh() {
            this.treeViewer.refresh();
        }

        public void refreshWithoutRestoring() {
            this.refresh();
        }

        public IMergeTreeContentProvider getContentProvider() {
            return (IMergeTreeContentProvider)this.treeViewer.getContentProvider();
        }

        public void setHeaderText(String text) {
            this.label.setText(text);
        }

        public void setHeaderVisible(boolean visible) {
            this.label.setVisible(visible);
        }

        public void setVisible(boolean visible) {
            if (!visible) {
                Control[] controls = this.splitter.getChildren();
                this.splitter.setMaximizedControl(controls[1]);
            } else {
                this.splitter.setMaximizedControl(null);
            }
        }

        public ILabelProvider getLabelProvider() {
            return (ILabelProvider)this.treeViewer.getLabelProvider();
        }

        public void setConflictInfo(IMergeTreeNode node) {
        }
    }

    private class TreeViewerViewByTreeMappingComposite
    extends TreeViewerViewImpl {
        private int treeNumber;
        private TreeMappingComposite tmc;
        private IMergeTreeContentProvider tcp;

        public TreeViewerViewByTreeMappingComposite(TreeMappingComposite tmc, IMergeTreeContentProvider tcp, int usage) {
            this.tmc = tmc;
            this.tcp = tcp;
            if (usage == 0) {
                this.treeNumber = 16384;
            } else if (usage == 1) {
                this.treeNumber = 131072;
            }
        }

        public void addMenuListener(IMenuListener listener) {
            this.tmc.addMenuListener(listener, this.treeNumber);
        }

        public void addSelectionChangedListener(NodeSelectedListener listener) {
            this.tmc.addSelectionChangedListener(this.getISelectionChangedListenerByNodeSelectedListener(listener), this.treeNumber);
        }

        public void addTreeListener(ITreeViewerListener listener) {
            this.tmc.addTreeListener(listener, this.treeNumber);
        }

        public IMergeTreeContentProvider getContentProvider() {
            return this.tcp;
        }

        public Object[] getExpandedElements() {
            return this.tmc.getExpandedElements(this.treeNumber);
        }

        public ISelection getSelection() {
            Object[] foundObjects = this.tmc.getSelectedItems(this.treeNumber);
            return new StructuredSelection(foundObjects);
        }

        public void refresh() {
            this.tmc.reloadTree(this.treeNumber, true);
            TreeConflictComposite.this.drawAllLinks();
        }

        public void refreshWithoutRestoring() {
            this.tmc.reloadTree(this.treeNumber);
            TreeConflictComposite.this.drawAllLinks();
        }

        public void setExpandedElements(Object[] elements) {
            this.tmc.setExpandedElements(elements, this.treeNumber);
        }

        public void setExpandedState(Object element, boolean expanded) {
            this.tmc.setExpandedState(element, expanded, this.treeNumber);
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                Object[] selectedItems = this.tmc.getSelectedItems(this.treeNumber);
                IStructuredSelection sst = (IStructuredSelection)selection;
                Object o = sst.getFirstElement();
                if (o instanceof IMergeTreeNode) {
                    IMergeTreeNode node = (IMergeTreeNode)o;
                    int i = 0;
                    while (i < selectedItems.length) {
                        IMergeTreeNode selNode = (IMergeTreeNode)selectedItems[i];
                        if (node.equals(selNode)) {
                            return;
                        }
                        ++i;
                    }
                    this.tmc.setSelection((Object)node, this.treeNumber, true);
                }
            }
        }

        public void clearAllSelection() {
            this.tmc.clearAllSelection(this.treeNumber);
        }

        public void setHeaderText(String text) {
            if (this.treeNumber == 16384) {
                this.tmc.setLeftTreeHeader(text, 16384);
            } else if (this.treeNumber == 131072) {
                this.tmc.setRightTreeHeader(text, 16384);
            }
        }

        public void setHeaderVisible(boolean visible) {
            this.tmc.setHeaderVisible(visible);
        }

        public void setVisible(boolean visible) {
        }

        public ILabelProvider getLabelProvider() {
            return this.tmc.getLabelProvider(this.treeNumber);
        }

        public void setConflictInfo(IMergeTreeNode node) {
            this.tmc.setDrawingAreaHeader(TreeConflictComposite.this.manager.getConflictInfo(this.treeNumber, node), 0x1000000);
        }
    }

    protected abstract class TreeViewerViewImpl
    implements TreeViewerView {
        protected TreeViewerViewImpl() {
        }

        protected ISelectionChangedListener getISelectionChangedListenerByNodeSelectedListener(NodeSelectedListener listener) {
            NodeSelectedListener l = listener;
            return new ISelectionChangedListener(this, l){
                private final /* synthetic */ NodeSelectedListener val$l;
                private final /* synthetic */ TreeViewerViewImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$l = val$l;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    IMergeTreeNode node = null;
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (selection.getFirstElement() instanceof TreeNode) {
                        TreeNode tnode = (TreeNode)selection.getFirstElement();
                        if (tnode == null) {
                            return;
                        }
                        node = (IMergeTreeNode)tnode.getData();
                    } else if (selection.getFirstElement() instanceof IMergeTreeNode) {
                        node = (IMergeTreeNode)selection.getFirstElement();
                    }
                    this.val$l.nodeSelected(node);
                }
            };
        }

        public abstract void setConflictInfo(IMergeTreeNode var1);

        public abstract ILabelProvider getLabelProvider();

        public abstract IMergeTreeContentProvider getContentProvider();

        public abstract void setVisible(boolean var1);

        public abstract void setHeaderVisible(boolean var1);

        public abstract void setHeaderText(String var1);

        public abstract void refreshWithoutRestoring();

        public abstract void refresh();

        public abstract void addMenuListener(IMenuListener var1);

        public abstract void addTreeListener(ITreeViewerListener var1);

        public abstract void addSelectionChangedListener(NodeSelectedListener var1);

        public abstract void clearAllSelection();

        public abstract ISelection getSelection();

        public abstract void setSelection(ISelection var1);

        public abstract void setExpandedState(Object var1, boolean var2);

        public abstract void setExpandedElements(Object[] var1);

        public abstract Object[] getExpandedElements();
    }
}

