/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.tree;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.metainfo.Relation;
import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.images.MMDecoratedImage;
import com.sap.ide.metamodel.tools.merge.images.MMImageManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeNodeMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeSubObjectMDO;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class MMTreeLabelProvider
extends SapTreeLabelProvider {
    private static Image metamodelImage = MMImageManager.createImage("metamodel.gif");
    private static Image mdoImage = MMImageManager.createImage("green_ball.gif");
    private static Image mdoPaleImage = MMImageManager.createImage("green_ball_pale.gif");
    private static Image danglingReference = MMImageManager.createImage("green_ball_broken.gif");
    private static Image paleDanglingReference = MMImageManager.createImage("green_ball_pale_broken.gif");
    private static Image aggEdge = MMImageManager.createImage("edge_blue.gif");
    private static Image aggPaleEdge = MMImageManager.createImage("edge_blue_pale.gif");
    private static Image assEdge = MMImageManager.createImage("edge_red.gif");
    private static Image assPaleEdge = MMImageManager.createImage("edge_red_pale.gif");
    private static ImageDescriptor smallAggEdgeDesc = MMImageManager.createImageDescriptor("agg.gif");
    private static ImageDescriptor smallAssEdgeDesc = MMImageManager.createImageDescriptor("ass.gif");
    private static ImageDescriptor smallPaleAggEdgeDesc = MMImageManager.createImageDescriptor("agg_pale.gif");
    private static ImageDescriptor smallPaleAssEdgeDesc = MMImageManager.createImageDescriptor("ass_pale.gif");
    private AbstractContribution contribution;
    private boolean withDecoration = true;

    private static Image getDecoImage(Image base, ImageDescriptor overlayDesc, int position) {
        if (overlayDesc == null) {
            return base;
        }
        return new MMDecoratedImage(base, overlayDesc, 16, position).createImage();
    }

    public MMTreeLabelProvider(AbstractContribution crh) {
        this.contribution = crh;
        if (this.contribution == null) {
            this.withDecoration = false;
        }
    }

    public void setWithDecoration(boolean wd) {
        this.withDecoration = wd;
    }

    public String getText(Object arg0) {
        if (!(arg0 instanceof IMergeTreeNode)) {
            return "";
        }
        MergeSubObjectMDO userObject = (MergeSubObjectMDO)((IMergeTreeNode)arg0).getUserObject();
        if (userObject == null) {
            return "metamodel roots not yet loaded";
        }
        if (userObject.getContent() instanceof Metamodel) {
            return ((Metamodel)userObject.getContent()).getName();
        }
        if (userObject.getContent() instanceof DevelopmentObject) {
            return ((DevelopmentObject)userObject.getContent()).getName();
        }
        if (userObject.getContent() instanceof Relation) {
            return ((Relation)userObject.getContent()).getName();
        }
        return "";
    }

    public Image getImage(Object currentNode) {
        if (!(currentNode instanceof IMergeTreeNode)) {
            return null;
        }
        MergeSubObjectMDO userObject = (MergeSubObjectMDO)((IMergeTreeNode)currentNode).getUserObject();
        if (userObject == null) {
            return super.getImage(currentNode);
        }
        if (userObject.carriesMetamodel()) {
            return metamodelImage;
        }
        if (userObject.carriesDevelopmentObject()) {
            Image doImage;
            boolean external = this.isDOExternal((MergeNodeMDO)currentNode);
            Image baseImage = userObject.isDangling() ? (external ? paleDanglingReference : danglingReference) : (external ? mdoPaleImage : mdoImage);
            if (userObject.carriesMainjDevelopmentObject() || userObject.isDangling()) {
                doImage = baseImage;
            } else {
                ImageDescriptor did = null;
                did = ((MergeNodeMDO)currentNode).isAggregated() ? (external ? smallPaleAggEdgeDesc : smallAggEdgeDesc) : (external ? smallPaleAssEdgeDesc : smallAssEdgeDesc);
                doImage = MMTreeLabelProvider.getDecoImage(baseImage, did, 0);
            }
            if (this.contribution != null && this.withDecoration) {
                return MMTreeLabelProvider.getDecoImage(doImage, this.contribution.findCorrectDeltaVector((IMergeTreeNode)currentNode).getImageDescriptor(), 3);
            }
            return doImage;
        }
        if (userObject.carriesRelation()) {
            boolean external = this.isRelationExternal((MergeNodeMDO)currentNode);
            if (userObject.carriesAggregation()) {
                if (external) {
                    return aggPaleEdge;
                }
                return aggEdge;
            }
            if (external) {
                return assPaleEdge;
            }
            return assEdge;
        }
        return super.getImage(currentNode);
    }

    private boolean isRelationExternal(IMergeTreeNode currentNode) {
        return this.isDOExternal(currentNode.getDirectParent());
    }

    private boolean isDOExternal(IMergeTreeNode node) {
        if (this.contribution != null) {
            return this.contribution.isDOExternal(node);
        }
        return ((MergeNodeMDO)node).isAssociated();
    }
}

