/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.tree;

import com.sap.ide.metamodel.tools.merge.editor.compare.SortingContribution;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeRootNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.RootMergeNodeMDO;
import com.sap.ide.metamodel.tools.merge.semantic.metamodel.RootMergeNodeMetaModel;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ChildForwardGetter;
import com.sap.ide.metamodel.tools.merge.tree.iterator.MMMAbstractIterator;
import com.sap.ide.metamodel.tools.merge.tree.iterator.MMMIterator;
import com.sap.ide.metamodel.tools.merge.tree.node.hider.NodeHider;
import org.eclipse.jface.viewers.Viewer;

public class MMMTreeContentProvider
implements IMergeTreeContentProvider {
    private IMergeTreeNode currentRoot = null;
    private IMergeRootNode originalRoot = null;

    public MMMTreeContentProvider(IMergeInputObject inputObject) {
        this.originalRoot = inputObject.getRootNode();
        this.currentRoot = this.originalRoot;
    }

    public void setSortingContribution(SortingContribution sc) {
        if (this.originalRoot instanceof RootMergeNodeMDO) {
            ((RootMergeNodeMDO)this.originalRoot).setSortingContribution(sc);
        } else if (this.originalRoot instanceof RootMergeNodeMetaModel) {
            ((RootMergeNodeMetaModel)this.originalRoot).setSortingContribution(sc);
        }
    }

    public MMMAbstractIterator getIterator() {
        return new MMMIterator(this.originalRoot, new ChildForwardGetter());
    }

    public void setNewRoot(IMergeTreeNode node) {
        this.currentRoot = node == null ? this.originalRoot : node;
    }

    public boolean isRootChanged() {
        return this.currentRoot != this.originalRoot;
    }

    public NodeHider getNodeHider() {
        if (this.originalRoot instanceof RootMergeNodeMDO) {
            return ((RootMergeNodeMDO)this.originalRoot).getNodeHider();
        }
        if (this.originalRoot instanceof RootMergeNodeMetaModel) {
            return ((RootMergeNodeMetaModel)this.originalRoot).getNodeHider();
        }
        return null;
    }

    public void setNodeHider(NodeHider nodeHider) {
        if (this.originalRoot instanceof RootMergeNodeMDO) {
            ((RootMergeNodeMDO)this.originalRoot).setNodeHider(nodeHider);
        } else if (this.originalRoot instanceof RootMergeNodeMetaModel) {
            ((RootMergeNodeMetaModel)this.originalRoot).setNodeHider(nodeHider);
        }
    }

    public IMergeTreeNode getRootNode() {
        return this.currentRoot;
    }

    public IMergeTreeNode getOriginalRootNode() {
        return this.originalRoot;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IMergeTreeNode) {
            return ((IMergeTreeNode)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IMergeTreeNode) {
            return ((IMergeTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IMergeTreeNode) {
            return ((IMergeTreeNode)element).getChildCount() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement.equals("")) {
            return new Object[]{this.currentRoot};
        }
        return new Object[]{inputElement};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

