/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.tree;

import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import java.util.Vector;

public class ConflictingNode {
    private int treeNumber;
    private IMergeTreeNode[] nodes = new IMergeTreeNode[2];
    private Vector deltaVector;

    public ConflictingNode(IMergeTreeNode leftNode, IMergeTreeNode rightNode, IMergeDelta delta) {
        this.nodes[0] = leftNode;
        this.nodes[1] = rightNode;
        this.deltaVector = new Vector();
        this.addDelta(delta);
    }

    public void addDelta(IMergeDelta delta) {
        this.deltaVector.add(delta);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConflictingNode)) {
            return false;
        }
        ConflictingNode foreignNode = (ConflictingNode)o;
        return foreignNode.containsNode(0, this.nodes[0]) && foreignNode.containsNode(1, this.nodes[1]);
    }

    public boolean containsNode(int usage, IMergeTreeNode node) {
        if (this.nodes[usage] == null) {
            return node == null;
        }
        return this.nodes[usage].equals(node);
    }

    public int getTreeNumber() {
        if (this.nodes[1] != null) {
            return 1;
        }
        return 0;
    }

    public IMergeTreeNode getNode() {
        if (this.nodes[1] != null) {
            return this.nodes[1];
        }
        return this.nodes[0];
    }

    private String getDeltaTexts() {
        String result = "";
        int i = 0;
        while (i < this.deltaVector.size()) {
            result = result + ((IMergeDelta)this.deltaVector.elementAt(i)).getDescribingText();
            ++i;
        }
        return result;
    }

    public String getText() {
        return "<Hierarchy>" + this.getNode().getDescribingText() + "</Hierarchy>" + this.getDeltaTexts();
    }
}

