/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.table;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.interfaces.IPropertyRow;
import com.sap.ide.metamodel.tools.merge.table.DiffingPropertyLabelProvider;
import com.sap.ide.metamodel.tools.merge.table.PropertyContentProvider;
import com.sap.ide.metamodel.tools.merge.table.PropertyLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class PropertyArea
extends Viewer {
    private IPropertyRow[] input;
    private TableViewer tableViewer;
    private CellEditor cellEditor;
    private ICellEditorListener editorListener;
    private AbstractContribution[] contributions;
    private String[] headerTexts;
    private boolean diffingForNW04;

    public PropertyArea(AbstractContribution[] contributions, String[] headerTexts, boolean diffingForNW04) {
        this.contributions = contributions;
        this.headerTexts = headerTexts;
        this.diffingForNW04 = diffingForNW04;
    }

    public Control getControl() {
        return this.tableViewer.getTable();
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void refresh() {
        this.tableViewer.setInput((Object)this.input);
    }

    public void setTwoWayMerge(boolean twoWayMerge) {
        TableLayout layout = new TableLayout();
        this.tableViewer.getTable().setLayout((Layout)layout);
        if (!twoWayMerge) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        } else {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            this.tableViewer.getTable().getColumn(3).setWidth(0);
        }
        this.tableViewer.getTable().layout();
        ((PropertyLabelProvider)this.tableViewer.getLabelProvider()).setWithDecoration(!twoWayMerge);
        this.refresh();
    }

    public void setInput(Object input) {
        if (input instanceof IPropertyRow[]) {
            this.input = (IPropertyRow[])input;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private void addColumn(String name, int weight, TableLayout layout, Table table) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(name);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight, true));
        if (weight > 0) {
            column.setResizable(true);
        } else {
            column.setResizable(false);
        }
    }

    private int getColumnIndexByPoint(Table t, int x) {
        int width = 0;
        TableColumn[] tableColumns = t.getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            if (width <= x && width + tableColumns[i].getWidth() >= x) {
                return i;
            }
            width += tableColumns[i].getWidth();
            ++i;
        }
        return -1;
    }

    private void hookControl(Table table) {
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyArea.this.handleSelect((TableItem)e.item, 1);
            }
        });
        final Table t = table;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = t.getItem(pt);
                if (item != null) {
                    PropertyArea.this.handleSelect(item, PropertyArea.this.getColumnIndexByPoint(t, pt.x));
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    PropertyArea.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    PropertyArea.this.setInput(PropertyArea.this.getInput());
                }
            }
        });
    }

    private void handleSelect(TableItem selection, int columnIndex) {
        Object object;
        TableItem[] sel;
        if (this.cellEditor != null) {
            this.deactivateCellEditor();
        }
        if ((sel = new TableItem[]{selection}).length != 0 && (object = sel[0].getData()) instanceof IPropertySheetEntry) {
            this.activateCellEditor(sel[0], columnIndex);
        }
        this.entrySelectionChanged();
    }

    private void activateCellEditor(TableItem item, int columnIndex) {
        this.tableViewer.getTable().showSelection();
        IPropertyRow activeEntry = (IPropertyRow)item.getData();
        this.cellEditor = activeEntry.getEditor((Composite)this.tableViewer.getTable(), columnIndex - 1);
        if (this.cellEditor != null) {
            this.createEditorListener(activeEntry);
            this.cellEditor.addListener(this.editorListener);
        }
        CellEditor[] cellEditors = new CellEditor[4];
        int i = 0;
        while (i < cellEditors.length) {
            cellEditors[i] = i == columnIndex ? this.cellEditor : null;
            ++i;
        }
        this.tableViewer.setCellEditors(cellEditors);
        final int ci = columnIndex - 1;
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("1") || property.equals("2") || property.equals("3");
            }

            public Object getValue(Object element, String property) {
                Object result = ((IPropertyRow)element).getValue(ci);
                return result == null ? "" : result;
            }

            public void modify(Object element, String property, Object value) {
                IPropertyRow row = null;
                if (element instanceof TableItem) {
                    row = (IPropertyRow)((TableItem)element).getData();
                } else if (element instanceof IPropertyRow) {
                    row = (IPropertyRow)element;
                }
            }
        });
        this.tableViewer.setColumnProperties(new String[]{"0", "1", "2", "3"});
        this.tableViewer.editElement((Object)activeEntry, columnIndex);
    }

    private void createEditorListener(final IPropertySheetEntry activeEntry) {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                PropertyArea.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                activeEntry.applyEditorValue();
                PropertyArea.this.refresh();
            }
        };
    }

    void deactivateCellEditor() {
        this.tableViewer.cancelEditing();
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
    }

    private void applyEditorValue(TableItem tableItem) {
        if (tableItem == null || tableItem.isDisposed()) {
            return;
        }
        IPropertyRow entry = (IPropertyRow)tableItem.getData();
        entry.applyEditorValue();
    }

    private void entrySelectionChanged() {
        SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(changeEvent);
    }

    public void createControl(Composite parent) {
        Table table = new Table(parent, 68098);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.addColumn("Attribute name", 25, layout, table);
        this.addColumn(this.headerTexts[0], 30, layout, table);
        this.addColumn(this.headerTexts[1], 30, layout, table);
        this.addColumn(this.headerTexts[2], 0, layout, table);
        table.setLayoutData((Object)new GridData(1808));
        this.hookControl(table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        if (this.diffingForNW04) {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new DiffingPropertyLabelProvider());
        } else {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider(this.contributions));
        }
        this.tableViewer.setInput((Object)this.input);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu((Control)table);
        table.setMenu(menu);
    }
}

