/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.services;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocation;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TemporaryMDOLocator
implements MDOLocator {
    private String sourcePath;
    private String projectName;
    private String temporaryProjectName;

    public TemporaryMDOLocator(String newSourcePath, String projectName, String temporaryProjectName) {
        this.sourcePath = newSourcePath;
        this.projectName = projectName;
        this.temporaryProjectName = temporaryProjectName;
    }

    private MetamodelManager getMetamodelManager() {
        return (MetamodelManager)MetamodelManager.getMetamodel((String)this.projectName).getMDOLocator();
    }

    public String getMDOPath(String mdoPackage, String mdoName, MDOEnum mdoType) {
        String temp = this.getMDOPath(mdoPackage, mdoName, mdoType.getFileExtension());
        if (temp != null) {
            return temp;
        }
        return this.getMetamodelManager().getMDOPath(mdoPackage, mdoName, mdoType);
    }

    private static String getRelativePath(String packageName, String fileName, String fileExtension) {
        String lPath = new String();
        if (packageName != null && packageName.length() > 0) {
            lPath = File.separator + packageName;
        }
        lPath = lPath + File.separator + fileName + "." + fileExtension;
        return lPath;
    }

    public String getMDOPath(String mdoPackage, String mdoName, String fileExtension) {
        String relativeMDOPath = TemporaryMDOLocator.getRelativePath(mdoPackage, mdoName, fileExtension);
        ArrayList packageRootPaths = new ArrayList();
        ArrayList sourcePaths = this.getProjectSourcePaths();
        packageRootPaths.addAll(sourcePaths);
        int i = 0;
        while (i < packageRootPaths.size()) {
            String path = packageRootPaths.get(i) + relativeMDOPath;
            if (this.fileExists(path)) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public MDOLocation[] getRootMDOLocations(RootMDOEnum rootMDOType) {
        Object[] tempResults = this.getFileLocations(rootMDOType.getFileExtension());
        Object[] otherResults = this.getMetamodelManager().getRootMDOLocations(rootMDOType);
        return (MDOLocation[])this.combineTwoArrays(tempResults, otherResults);
    }

    public MDOLocation[] getFileLocations(String fileExtension) {
        ArrayList result = new ArrayList();
        ArrayList packageRootPaths = new ArrayList();
        packageRootPaths.addAll(this.getProjectSourcePaths());
        int i = 0;
        while (i < packageRootPaths.size()) {
            String fileName = (String)packageRootPaths.get(i);
            File folder = new File(fileName);
            if (folder.exists() && folder.isDirectory()) {
                this.getFileLocations(folder, "", "." + fileExtension, result);
            }
            ++i;
        }
        MDOLocation[] helperArray = new MDOLocation[]{};
        MDOLocation[] results = result.toArray(helperArray);
        return results;
    }

    void getFileLocations(File folder, String currentPackage, String fileExtension, ArrayList result) {
        File[] children = folder.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isFile() && children[i].getName().endsWith(fileExtension)) {
                    String absolutePath = children[i].getAbsolutePath();
                    MDOLocation location = new MDOLocation(absolutePath, currentPackage);
                    result.add(location);
                } else if (children[i].isDirectory()) {
                    String nextPackage = currentPackage == null || currentPackage.length() <= 0 ? children[i].getName() : currentPackage + '.' + children[i].getName();
                    this.getFileLocations(children[i], nextPackage, fileExtension, result);
                }
                ++i;
            }
        }
    }

    private Object[] combineTwoArrays(Object[] array1, Object[] array2) {
        Object[] results = new MDOLocation[array1.length + array2.length];
        System.arraycopy(array1, 0, results, 0, array1.length);
        System.arraycopy(array2, 0, results, array1.length, array2.length);
        return results;
    }

    private static String getRelativePath(String packageName) {
        String lPath = new String();
        if (packageName != null && packageName.length() > 0) {
            lPath = File.separator + packageName.replace('.', File.separatorChar);
        }
        return lPath;
    }

    boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public String[] getPathsOfFilesInPackage(ArrayList sourcePaths, String packageName, String fileExtension) {
        ArrayList<String> paths = new ArrayList<String>();
        String relativePackagePath = TemporaryMDOLocator.getRelativePath(packageName);
        int i = 0;
        while (i < sourcePaths.size()) {
            String folderPath = sourcePaths.get(i) + relativePackagePath;
            if (this.fileExists(folderPath)) {
                final String lExtension = "." + fileExtension;
                File[] lFiles = new File(folderPath).listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(lExtension);
                    }
                });
                int j = 0;
                while (j < lFiles.length) {
                    paths.add(lFiles[j].getAbsolutePath());
                    ++j;
                }
            }
            ++i;
        }
        String[] helperArray = new String[]{};
        String[] results = paths.toArray(helperArray);
        return results;
    }

    public String[] getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
        Object[] tempResults = this.getPathsOfFilesInPackage(this.getProjectSourcePaths(), mdoPackage, rootMDOType.getFileExtension());
        Object[] otherResults = this.getMetamodelManager().getRootMDOPaths(mdoPackage, rootMDOType);
        return (String[])this.combineTwoArrays(tempResults, otherResults);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSourcePath(SourcePathIdentifier identifier) {
        return this.getSourcePath();
    }

    public ArrayList getProjectSourcePaths() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getSourcePath());
        return list;
    }

    public IFile getFile(String absolutePath) {
        Path path = new Path(absolutePath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.temporaryProjectName);
        IPath location = project.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        Object lPath = nrOfMatchingSegments > 0 ? path.removeFirstSegments(nrOfMatchingSegments) : path;
        IFile file = project.getFile((IPath)lPath);
        return file;
    }
}

