/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.services;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class EclipseProjectService {
    private static final int SOURCE_PATH = 0;
    private static final int FILE_PATH = 1;

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                EclipseProjectService.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static boolean checkFileExistsInProject(String projectName, String filePath) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(filePath);
        return file.exists();
    }

    public static ICompilationUnit getCompilationUnit(String projectName, String relativeLocation, String fileName) {
        IClasspathEntry[] classpaths = MetamodelManager.getJavaProjectClassPaths((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        int i = 0;
        while (i < classpaths.length) {
            String completePath = classpaths[i].getPath().toOSString() + File.separator + relativeLocation + File.separator + fileName;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(completePath));
            if (file.exists()) {
                return JavaCore.createCompilationUnitFrom((IFile)file);
            }
            ++i;
        }
        return null;
    }

    public static String makeAbsolutePathProjectRelativ(String absolutePath, IProject project) {
        Path lAbsolutePath = new Path(absolutePath);
        IPath lRelativePath = lAbsolutePath.removeFirstSegments(lAbsolutePath.matchingFirstSegments((IPath)new Path(project.getLocation().toOSString())));
        return lRelativePath.setDevice(null).toString();
    }

    public static String getAbsolutePathForFileAcrossAllSourcePaths(String projectName, String relativeLocation, String fileName) {
        return EclipseProjectService.getPathForFile(projectName, relativeLocation, fileName, 1);
    }

    public static String getSourcePathForFile(String projectName, String relativeLocation, String fileName) {
        return EclipseProjectService.getPathForFile(projectName, relativeLocation, fileName, 0);
    }

    private static String getPathForFile(String projectName, String relativeLocation, String fileName, int fileOrSourcePath) {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)projectName);
        ArrayList sourcePaths = manager.getProjectSourcePaths();
        String absolutePath = null;
        int i = 0;
        while (i < sourcePaths.size()) {
            Object sourcePath = sourcePaths.get(i);
            absolutePath = sourcePath + "\\" + relativeLocation + "\\" + fileName;
            File f = new File(absolutePath);
            if (f.exists()) {
                if (fileOrSourcePath == 0) {
                    return (String)sourcePath;
                }
                if (fileOrSourcePath == 1) {
                    return absolutePath;
                }
            }
            ++i;
        }
        return null;
    }

    public static void setNewClpEntry(Path libPath, IJavaProject javaProject, int type) {
        IClasspathEntry[] classPath = null;
        try {
            classPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        IClasspathEntry varEntry = null;
        switch (type) {
            case 4: {
                varEntry = JavaCore.newVariableEntry((IPath)libPath, null, null, (boolean)true);
                break;
            }
            case 1: {
                varEntry = JavaCore.newLibraryEntry((IPath)libPath, null, null, (boolean)true);
                break;
            }
            case 2: {
                varEntry = JavaCore.newProjectEntry((IPath)libPath);
                break;
            }
            case 3: {
                varEntry = JavaCore.newSourceEntry((IPath)libPath);
            }
        }
        if (EclipseProjectService.isInClasspath(classPath, varEntry)) {
            return;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
        System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
        newClassPath[classPath.length] = varEntry;
        try {
            javaProject.setRawClasspath(newClassPath, null);
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
    }

    private static boolean isInClasspath(IClasspathEntry[] prevCp, IClasspathEntry newCpe) {
        int i = 0;
        while (i < prevCp.length) {
            if (prevCp[i].equals(newCpe)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

