/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.services;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;

public class EclipseFilePathService {
    public static String removeFileNameFromPath(String filePath) {
        filePath = File.separatorChar == '/' ? filePath.replace('\\', File.separatorChar) : filePath.replace('/', File.separatorChar);
        String pack = "";
        if (filePath.indexOf(File.separatorChar) > -1) {
            pack = filePath.substring(0, filePath.lastIndexOf(File.separatorChar));
        }
        return pack;
    }

    public static String convertSlashesToDots(String inStr) {
        inStr = inStr.replace('\\', '.');
        inStr = inStr.replace('/', '.');
        return inStr;
    }

    public static String convertDotsToFileSeperators(String strToConvert) {
        return strToConvert.replace('.', File.separatorChar);
    }

    public static String removeSrcFolderPartFromPath(String pathString, String projectName) {
        if (pathString.length() < 1) {
            return pathString;
        }
        IJavaProject elem = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        try {
            IPackageFragmentRoot[] roots = elem.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!(roots[i] instanceof JarPackageFragmentRoot)) {
                    String sourceFolderName = roots[i].getElementName();
                    IContainer parentResource = roots[i].getCorrespondingResource().getParent();
                    while (!(parentResource instanceof IProject)) {
                        sourceFolderName = parentResource.getName() + File.separator + sourceFolderName;
                        parentResource = parentResource.getParent();
                    }
                    if (pathString.startsWith(sourceFolderName)) {
                        if (pathString.equals(sourceFolderName)) {
                            return "";
                        }
                        return pathString.substring(sourceFolderName.length() + 1);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return pathString;
    }
}

