/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.semantic.metamodel;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.general.metainfo.Relation;
import com.sap.ide.metamodel.tools.merge.editor.compare.SortingContribution;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeRootNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeSubObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeNodeMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeSubObjectMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.UniqueTreeIdentificationMDO;
import com.sap.ide.metamodel.tools.merge.semantic.metamodel.MergeSubObjectMetaModel;
import com.sap.ide.metamodel.tools.merge.semantic.metamodel.RootMergeNodeMetaModel;
import java.util.Vector;

public class MergeNodeMetaModel
extends MergeNodeMDO {
    public MergeNodeMetaModel(Object obj, Root root, IMergeTreeNode parentNode, IMergeRootNode rootNode) {
        super(obj, parentNode, rootNode);
        this.setUserObject(obj, root);
    }

    public MergeNodeMetaModel(Object obj, IMergeTreeNode parentNode, IMergeRootNode rootNode) {
        this(obj, null, parentNode, rootNode);
    }

    public void setUserObject(Object object, Root root) {
        this.userObject = new MergeSubObjectMetaModel(object, root);
    }

    protected SortingContribution getSortingContribution() {
        if (this.rootNode instanceof RootMergeNodeMetaModel) {
            return ((RootMergeNodeMetaModel)this.rootNode).getSortingContribution();
        }
        return null;
    }

    protected void loadChildren() {
        Root[] roots = null;
        if (this.children == null || this.children.size() == 0) {
            this.children = new Vector();
            Object[] obs = null;
            if (this.userObject.getContent() instanceof Metamodel) {
                Metamodel metamodel = (Metamodel)this.userObject.getContent();
                obs = this.loadRelationsFromMetamodel(metamodel);
                roots = new Root[obs.length];
                int i = 0;
                while (i < obs.length) {
                    roots[i] = this.getRootForAggregation(metamodel, (Aggregation)obs[i]);
                    ++i;
                }
            } else if (this.userObject.carriesDevelopmentObject() && this.isAggregated()) {
                DevelopmentObject devObj = (DevelopmentObject)this.userObject.getContent();
                obs = this.loadRelationsFromDO(devObj);
            } else if (this.userObject.carriesRelation()) {
                Relation rel = (Relation)this.userObject.getContent();
                IMergeSubObject subObject = this.parent.getUserObject();
                obs = subObject.getContent() instanceof Metamodel ? this.loadChildrenFromRelation((Metamodel)subObject.getContent(), (Aggregation)rel) : this.loadChildrenFromRelation((DevelopmentObject)subObject.getContent(), rel);
            } else {
                return;
            }
            int i = 0;
            while (i < obs.length) {
                if (roots != null) {
                    this.append(new MergeNodeMetaModel(obs[i], roots[i], this, this.rootNode));
                } else {
                    this.append(new MergeNodeMetaModel(obs[i], this, this.rootNode));
                }
                ++i;
            }
        }
    }

    public IUniqueTreeIdentification getUniqueTreeIdentification() {
        if (((MergeSubObjectMDO)this.getUserObject()).carriesMetamodel()) {
            return new UniqueTreeIdentificationMDO(this.getUserObject().getContent(), null, null);
        }
        return super.getUniqueTreeIdentification();
    }

    private Relation[] loadRelationsFromMetamodel(Metamodel metamodel) {
        Vector relationVector = new Vector();
        Root[] roots = metamodel.getRoots();
        int i = 0;
        while (i < roots.length) {
            MetaClass mc = roots[i].getMetaClass();
            Aggregation[] aggregations = mc.getAllAggregations();
            int j = 0;
            while (j < aggregations.length) {
                try {
                    if (roots[i].getAggregatedObjects(aggregations[j]).length > 0) {
                        relationVector.add(aggregations[j]);
                    }
                }
                catch (ReflectionException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        SortingContribution sc = this.getSortingContribution();
        if (sc != null) {
            relationVector = sc.augmentSetOfRelations(metamodel, relationVector);
        }
        if (relationVector == null) {
            return new Relation[0];
        }
        return relationVector.toArray(new Relation[relationVector.size()]);
    }

    private Root getRootForAggregation(Metamodel metamodel, Aggregation aggregation) {
        Root[] roots = metamodel.getRoots();
        int i = 0;
        while (i < roots.length) {
            MetaClass mc = roots[i].getMetaClass();
            Aggregation[] aggs = mc.getAllAggregations();
            int j = 0;
            while (j < aggs.length) {
                if (aggs[j] == aggregation) {
                    return roots[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Object[] loadChildrenFromRelation(Metamodel metamodel, Aggregation aggregation) {
        Object[] returnObjects = null;
        Root root = this.getRootForAggregation(metamodel, aggregation);
        try {
            returnObjects = root.getAggregatedObjects(aggregation);
        }
        catch (ReflectionException e) {
            return null;
        }
        SortingContribution sc = this.getSortingContribution();
        if (sc != null) {
            returnObjects = sc.augmentSetOfDOs(metamodel, (Relation)aggregation, returnObjects);
        }
        return returnObjects;
    }
}

