/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.semantic.mdo;

import com.sap.ide.metamodel.tools.merge.editor.property.ComboboxCellEditor;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeProperty;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeSubObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IPropertyRow;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import com.sap.ide.metamodel.tools.merge.property.LongTextPropertyCellEditor;
import com.sap.ide.metamodel.tools.merge.property.TranslatableTextPropertyCellEditor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;

public class PropertyRowMDO
implements IPropertyRow {
    private CellEditor editor;
    private String errorText;
    private ListenerList listeners = new ListenerList();
    private IMergeTreeNode[] treeNodes;
    private IMergeProperty property;
    private IUniqueTreeIdentification treeIdent;

    public PropertyRowMDO(IMergeProperty property, IMergeTreeNode[] treeNodes) {
        this.property = property;
        this.treeNodes = treeNodes;
        int i = 0;
        while (i < treeNodes.length && this.treeIdent == null) {
            if (treeNodes[i] != null) {
                this.treeIdent = treeNodes[i].getUniqueTreeIdentification();
            }
            ++i;
        }
    }

    public IUniqueTreeIdentification getUniqueTreeIdentification() {
        return this.treeIdent;
    }

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
    }

    public void applyEditorValue() {
    }

    private void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
        this.fireErrorMessageChanged();
    }

    private void setValue(Object newValue) {
        this.setNewValue(newValue);
    }

    private void fireErrorMessageChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.errorMessageChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
    }

    public String getCategory() {
        return null;
    }

    public IPropertySheetEntry[] getChildEntries() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    private Object getEditValue(int columnIndex) {
        if (columnIndex > -1) {
            return this.getValue(columnIndex);
        }
        return null;
    }

    public CellEditor getEditor(Composite parent) {
        return null;
    }

    public CellEditor getEditor(Composite parent, int columnIndex) {
        if (columnIndex == -1) {
            return null;
        }
        IMergeTreeNode node = this.treeNodes[columnIndex];
        if (node != null) {
            Object editValue;
            if (this.editor == null) {
                this.editor = this.getCellEditor(parent);
            }
            if (this.editor != null && (editValue = this.getEditValue(columnIndex)) != null) {
                this.editor.setValue(editValue);
                this.setErrorText(this.editor.getErrorMessage());
            }
            return this.editor;
        }
        return null;
    }

    public String getErrorText() {
        return null;
    }

    public String[] getFilters() {
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getValueAsString() {
        return null;
    }

    public boolean hasChildEntries() {
        return false;
    }

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
    }

    public void resetPropertyValue() {
    }

    public void setValues(Object[] values) {
    }

    public String getName() {
        return this.property.getName();
    }

    public Object getValue(int column) {
        if (this.treeNodes[column] == null) {
            return null;
        }
        IMergeSubObject dObject = this.getMergeObject(column);
        return dObject.getPropertyValue(this.property);
    }

    public void setNewValue(Object newValue) {
    }

    public CellEditor getCellEditor(Composite parent) {
        String type = this.property.getType();
        DialogCellEditor editor = null;
        if (this.property.isEnumType()) {
            return null;
        }
        if (type.equalsIgnoreCase("integer")) {
            return null;
        }
        if (type.equalsIgnoreCase("boolean")) {
            return null;
        }
        if (type.equalsIgnoreCase("long")) {
            return null;
        }
        if (type.equalsIgnoreCase("byte")) {
            return null;
        }
        if (type.equalsIgnoreCase("double")) {
            return null;
        }
        if (type.equalsIgnoreCase("string")) {
            return null;
        }
        editor = type.equalsIgnoreCase("Text") ? new LongTextPropertyCellEditor("", this, true) : (type.equalsIgnoreCase("TranslatableText") ? new TranslatableTextPropertyCellEditor(this.property, this.getMergeObject(0), this.property.getName(), true) : new TextCellEditor());
        editor.create(parent);
        if (editor instanceof ComboboxCellEditor) {
            ((ComboboxCellEditor)editor).setItems();
        }
        return editor;
    }

    public IMergeSubObject getMergeObject(int column) {
        if (this.treeNodes[column] == null) {
            return null;
        }
        return this.treeNodes[column].getUserObject();
    }

    public IMergeProperty getProperty() {
        return this.property;
    }
}

