/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.semantic.mdo;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeRootNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeSubObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.DifferenceStorageMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeDeltaMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeSubObjectMDO;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.RootMergeNodeMDO;
import com.sap.ide.metamodel.tools.merge.tree.MMMTreeContentProvider;

public class MergeInputObjectMDO
implements IMergeInputObject {
    private MainDevelopmentObject mdo;

    public MergeInputObjectMDO(MainDevelopmentObject mdo) {
        this.mdo = mdo;
    }

    public Object getContent() {
        return this.mdo;
    }

    public boolean exists() {
        return this.mdo.isValid();
    }

    public String isValid() {
        if (this.mdo.isModified()) {
            return "Main development object " + this.mdo.getName() + " has been modified. Please save it!";
        }
        return null;
    }

    public String getName() {
        return this.mdo.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MergeInputObjectMDO) {
            MainDevelopmentObject foreignMDO = (MainDevelopmentObject)((MergeInputObjectMDO)obj).getContent();
            return this.mdo.isEqualTo((DevelopmentObject)foreignMDO);
        }
        return false;
    }

    public void save() {
        MetamodelManager.saveAllMetaData((Metamodel)this.mdo.getMetamodel());
    }

    public void rollback() {
        MetamodelManager.rollbackMetaData((Metamodel)this.mdo.getMetamodel());
    }

    public IMergeDelta[] compareTo(IMergeInputObject object) {
        MainDevelopmentObject foreignMdo = (MainDevelopmentObject)object.getContent();
        CompareResult result = this.mdo.compareTo((DevelopmentObject)foreignMdo);
        if (result != null) {
            MetamodelDelta[] del = result.getDeltas();
            IMergeDelta[] results = new MergeDeltaMDO[del.length];
            int i = 0;
            while (i < del.length) {
                results[i] = new MergeDeltaMDO(del[i]);
                ++i;
            }
            return results;
        }
        return null;
    }

    public IMergeRootNode getRootNode() {
        return new RootMergeNodeMDO(this.getContent());
    }

    public IMergeTreeContentProvider getContentProvider() {
        return new MMMTreeContentProvider(this);
    }

    public boolean isSubObjectIncluded(IMergeSubObject subObject) {
        if (((MergeSubObjectMDO)subObject).carriesDevelopmentObject()) {
            if (((MergeSubObjectMDO)subObject).isDangling()) {
                return false;
            }
            DevelopmentObject developmentObject = (DevelopmentObject)subObject.getContent();
            return developmentObject.getMDO().getKey().equals(this.mdo.getKey());
        }
        return false;
    }

    public DifferenceStorage buildDifferenceStorage(IMergeInputObject otherObject, boolean withSort) {
        if (withSort) {
            return new DifferenceStorageMDO(this, otherObject);
        }
        return new DifferenceStorage(this, otherObject);
    }
}

