/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.semantic.mdo;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.compare.AggregationDelta;
import com.sap.ide.metamodel.general.compare.AggregationNegativeDelta;
import com.sap.ide.metamodel.general.compare.AggregationPositiveDelta;
import com.sap.ide.metamodel.general.compare.AssociationDelta;
import com.sap.ide.metamodel.general.compare.AssociationNegativeDelta;
import com.sap.ide.metamodel.general.compare.AssociationPositiveDelta;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.compare.PropertyDelta;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.metainfo.DeclarationTypeEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.general.metainfo.Property;
import com.sap.ide.metamodel.general.metainfo.Relation;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IPropertyRow;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.UniqueTreeIdentificationMDO;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Vector;

public class MergeDeltaMDO
implements IMergeDelta {
    protected MetamodelDelta delta;
    private static final String APPLY_DELTA = "apply: ";
    private static final String UNAPPLY_DELTA = "revert: ";
    private IUniqueTreeIdentification[] treeIdents;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$metamodel$tools$merge$semantic$mdo$MergeDeltaMDO == null ? (class$com$sap$ide$metamodel$tools$merge$semantic$mdo$MergeDeltaMDO = MergeDeltaMDO.class$("com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeDeltaMDO")) : class$com$sap$ide$metamodel$tools$merge$semantic$mdo$MergeDeltaMDO));
    static /* synthetic */ Class class$com$sap$ide$metamodel$tools$merge$semantic$mdo$MergeDeltaMDO;

    public MergeDeltaMDO(MetamodelDelta delta) {
        this.delta = delta;
        this.setUniqueTreeIdentifications();
    }

    public Object getContent() {
        return this.delta;
    }

    public Object clone() {
        return new MergeDeltaMDO(this.delta);
    }

    public boolean isApplied() {
        return this.delta.isApplied();
    }

    public void apply() {
        try {
            this.delta.apply();
        }
        catch (MetamodelException e) {
            tracer.log(2, "Metamodel access error: No application of delta possible", (Throwable)e);
        }
    }

    public void revert() {
        try {
            this.delta.revert();
        }
        catch (MetamodelException e) {
            tracer.log(2, "Metamodel access error: No reverting of delta possible", (Throwable)e);
        }
    }

    public IUniqueTreeIdentification[] getUniqueTreeIdentifications() {
        return this.treeIdents;
    }

    private void setUniqueTreeIdentifications() {
        Relation relation = this.getRelationOfDelta();
        if (this.isExchangeDelta()) {
            this.treeIdents = new IUniqueTreeIdentification[]{new UniqueTreeIdentificationMDO(this.getObjectToDelete(), relation, this.getSourceObject()), new UniqueTreeIdentificationMDO(this.getObjectToInsert(), relation, this.getSourceObject())};
        } else {
            Object deOb = this.getObjectToChangeItsAttributes();
            if (deOb == null) {
                deOb = this.getObjectToDelete();
            }
            if (deOb == null) {
                deOb = this.getObjectToInsert();
            }
            this.treeIdents = deOb != null ? new IUniqueTreeIdentification[]{new UniqueTreeIdentificationMDO(deOb, relation, this.getSourceObject())} : new IUniqueTreeIdentification[0];
        }
    }

    public IUniqueTreeIdentification getUniqueTreeIdentification(int usage) {
        Object deOb = null;
        Relation relation = this.getRelationOfDelta();
        if (this.isAttributeDelta()) {
            deOb = this.getObjectToChangeItsAttributes();
        } else if (usage == 0) {
            if (this.isNegativeDelta() && !this.isApplied()) {
                deOb = this.getObjectToDelete();
            } else if (this.isPositiveDelta() && this.isApplied()) {
                deOb = this.getObjectToInsert();
            } else if (this.isExchangeDelta()) {
                deOb = this.isApplied() ? this.getObjectToInsert() : this.getObjectToDelete();
            }
        } else {
            deOb = this.getObjectToInsert();
        }
        if (deOb == null) {
            return null;
        }
        return new UniqueTreeIdentificationMDO(deOb, relation, this.getSourceObject());
    }

    public boolean doesAttributeDeltaConcernPropertyRow(IPropertyRow row) {
        if (this.isAttributeDelta()) {
            PropertyDelta pDelta = (PropertyDelta)this.delta;
            Property deltaProperty = pDelta.getProperty();
            return deltaProperty.equals(row.getProperty().getContent());
        }
        return false;
    }

    public Object getSourceObject() {
        DevelopmentObject sourceObject = this.delta.getSourceObject();
        if (this.isAttributeDelta()) {
            if (sourceObject.getParent() == null) {
                return sourceObject.getMetamodel();
            }
            return sourceObject.getParent();
        }
        return sourceObject;
    }

    public Relation getRelationOfDelta() {
        if (this.delta instanceof AggregationPositiveDelta) {
            return ((AggregationPositiveDelta)this.delta).getAggregation();
        }
        if (this.delta instanceof AssociationPositiveDelta) {
            return ((AssociationPositiveDelta)this.delta).getAssociation();
        }
        if (this.delta instanceof AggregationNegativeDelta) {
            return ((AggregationNegativeDelta)this.delta).getAggregation();
        }
        if (this.delta instanceof AssociationNegativeDelta) {
            return ((AssociationNegativeDelta)this.delta).getAssociation();
        }
        if (this.delta instanceof AggregationDelta) {
            return ((AggregationDelta)this.delta).getAggregation();
        }
        if (this.delta instanceof AssociationDelta) {
            return ((AssociationDelta)this.delta).getAssociation();
        }
        if (this.delta instanceof PropertyDelta) {
            MetaClass mc = this.delta.getSourceObject().getMetaClass();
            if (mc.getIsMDO()) {
                return null;
            }
            return this.delta.getSourceObject().getContainingAggregation();
        }
        return null;
    }

    public Object getObjectToChangeItsAttributes() {
        if (this.isAttributeDelta()) {
            return ((PropertyDelta)this.delta).getSourceObject();
        }
        return null;
    }

    public Object getObjectToInsert() {
        if (this.delta instanceof AggregationPositiveDelta) {
            return ((AggregationPositiveDelta)this.delta).getObjectToCreate();
        }
        if (this.delta instanceof AssociationPositiveDelta) {
            return ((AssociationPositiveDelta)this.delta).getObjectToReference();
        }
        if (this.delta instanceof AggregationDelta) {
            return ((AggregationDelta)this.delta).getObjectToCreate();
        }
        if (this.delta instanceof AssociationDelta) {
            return ((AssociationDelta)this.delta).getObjectToReference();
        }
        return null;
    }

    public Object getObjectToDelete() {
        if (this.delta instanceof AggregationNegativeDelta && !this.delta.isApplied()) {
            return ((AggregationNegativeDelta)this.delta).getObjectToDelete();
        }
        if (this.delta instanceof AssociationNegativeDelta && !this.delta.isApplied()) {
            return ((AssociationNegativeDelta)this.delta).getObjectToRemove();
        }
        if (this.delta instanceof AggregationDelta) {
            return ((AggregationDelta)this.delta).getObjectToDelete();
        }
        if (this.delta instanceof AssociationDelta) {
            return ((AssociationDelta)this.delta).getObjectToRemove();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.delta == null;
    }

    public boolean isPositiveDelta() {
        return this.delta instanceof AggregationPositiveDelta || this.delta instanceof AssociationPositiveDelta;
    }

    public boolean isNegativeDelta() {
        return this.delta instanceof AggregationNegativeDelta || this.delta instanceof AssociationNegativeDelta;
    }

    public boolean isExchangeDelta() {
        return this.delta instanceof AggregationDelta || this.delta instanceof AssociationDelta;
    }

    public boolean isAttributeDelta() {
        return this.delta instanceof PropertyDelta;
    }

    public Vector augmentSetOfDOs(DevelopmentObject developmentObject, Relation relation) {
        Vector<Object> results = new Vector<Object>();
        if (developmentObject == this.delta.getSourceObject() && relation == this.getRelationOfDelta() && this.isPositiveDelta()) {
            results.add(this.getObjectToInsert());
        }
        return results;
    }

    public Vector augmentSetOfRelations(DevelopmentObject developmentObject, Vector relations) {
        Relation relation;
        if (relations == null) {
            relations = new Vector<Relation>();
        }
        if (!(this.delta == null || this.delta instanceof PropertyDelta || developmentObject != this.delta.getSourceObject() || (relation = this.getRelationOfDelta()) == null || relations.contains(relation) || relation.getDeclarationType().equals(DeclarationTypeEnum.ABSTRACT))) {
            relations.add(relation);
        }
        return relations;
    }

    public String getMenuText() {
        String text = this.delta.toString();
        if (this.delta instanceof PropertyDelta) {
            PropertyDelta pDelta = (PropertyDelta)this.delta;
            text = "take over all properties with regards to " + pDelta.getSourceObject().getName();
        } else if (this.delta instanceof AggregationNegativeDelta) {
            AggregationNegativeDelta nDelta = (AggregationNegativeDelta)this.delta;
            text = !this.delta.isApplied() ? "delete " + nDelta.getObjectToDelete().getName() + " within " + nDelta.getSourceObject().getName() : "insert " + nDelta.getObjectToDelete().getName() + " into " + nDelta.getSourceObject().getName();
        } else if (this.delta instanceof AssociationNegativeDelta) {
            AssociationNegativeDelta nDelta = (AssociationNegativeDelta)this.delta;
            text = !this.delta.isApplied() ? "remove reference to " + nDelta.getObjectToRemove().getName() + " within " + nDelta.getSourceObject().getName() : "insert reference to " + nDelta.getObjectToRemove().getName() + " into " + nDelta.getSourceObject().getName();
        } else if (this.delta instanceof AggregationPositiveDelta) {
            AggregationPositiveDelta pDelta = (AggregationPositiveDelta)this.delta;
            text = !this.delta.isApplied() ? "insert " + pDelta.getObjectToCreate().getName() + " into " + pDelta.getSourceObject().getName() : "delete " + pDelta.getObjectToCreate().getName() + " within " + pDelta.getSourceObject().getName();
        } else if (this.delta instanceof AssociationPositiveDelta) {
            AssociationPositiveDelta pDelta = (AssociationPositiveDelta)this.delta;
            text = !this.delta.isApplied() ? "insert reference to " + pDelta.getObjectToReference().getName() + " into " + pDelta.getSourceObject().getName() : "delete reference to " + pDelta.getObjectToReference().getName() + " within " + pDelta.getSourceObject().getName();
        } else if (this.delta instanceof AggregationDelta) {
            AggregationDelta aDelta = (AggregationDelta)this.delta;
            text = this.delta.isApplied() ? "replace " + aDelta.getObjectToCreate().getName() + " with " + aDelta.getObjectToDelete().getName() + " within " + aDelta.getSourceObject().getName() : "replace " + aDelta.getObjectToDelete().getName() + " with " + aDelta.getObjectToCreate().getName() + " within " + aDelta.getSourceObject().getName();
        } else if (this.delta instanceof AssociationDelta) {
            AssociationDelta aDelta = (AssociationDelta)this.delta;
            text = this.delta.isApplied() ? "replace reference to " + aDelta.getObjectToReference().getName() + " with reference to " + aDelta.getObjectToRemove().getName() + " within " + aDelta.getSourceObject().getName() : "replace reference to " + aDelta.getObjectToRemove().getName() + " with reference to " + aDelta.getObjectToReference().getName() + " within " + aDelta.getSourceObject().getName();
        }
        if (this.delta.isApplied()) {
            return UNAPPLY_DELTA + text;
        }
        return APPLY_DELTA + text;
    }

    public IUniqueTreeIdentification transformTreeIdentification(IUniqueTreeIdentification treeIdent) {
        UniqueTreeIdentificationMDO treeIdentMDO = (UniqueTreeIdentificationMDO)treeIdent;
        Relation relation = treeIdentMDO.getRelationToThisObject();
        DevelopmentObject developmentObject = null;
        if (treeIdentMDO.getThisObject() == null) {
            return null;
        }
        if (treeIdentMDO.getThisObject() instanceof DevelopmentObject) {
            DevelopmentObjectKey key = ((DevelopmentObject)treeIdentMDO.getThisObject()).getKey();
            String name = ((DevelopmentObject)treeIdentMDO.getThisObject()).getName();
            if (this.delta instanceof AggregationDelta && (relation == null || ((AggregationDelta)this.delta).getAggregation() == relation)) {
                if (((AggregationDelta)this.delta).getObjectToCreate().getKey().equals(key) && ((AggregationDelta)this.delta).getObjectToCreate().getName().equals(name)) {
                    developmentObject = this.delta.isApplied() ? ((AggregationDelta)this.delta).getObjectToCreate() : ((AggregationDelta)this.delta).getObjectToDelete();
                } else if (((AggregationDelta)this.delta).getObjectToDelete().getKey().equals(key) && ((AggregationDelta)this.delta).getObjectToDelete().getName().equals(name)) {
                    developmentObject = this.delta.isApplied() ? ((AggregationDelta)this.delta).getObjectToDelete() : ((AggregationDelta)this.delta).getObjectToCreate();
                }
            } else if (this.delta instanceof AssociationDelta && (relation == null || ((AssociationDelta)this.delta).getAssociation() == relation)) {
                if (((AssociationDelta)this.delta).getObjectToReference().getKey().equals(key) && ((AssociationDelta)this.delta).getObjectToReference().getName().equals(name)) {
                    developmentObject = this.delta.isApplied() ? ((AssociationDelta)this.delta).getObjectToReference() : ((AssociationDelta)this.delta).getObjectToRemove();
                } else if (((AssociationDelta)this.delta).getObjectToRemove().getKey().equals(key) && ((AssociationDelta)this.delta).getObjectToRemove().getName().equals(name)) {
                    developmentObject = this.delta.isApplied() ? ((AssociationDelta)this.delta).getObjectToRemove() : ((AssociationDelta)this.delta).getObjectToReference();
                }
            }
        }
        if (developmentObject == null) {
            return null;
        }
        return new UniqueTreeIdentificationMDO(developmentObject, relation, ((UniqueTreeIdentificationMDO)treeIdent).getFatherObject());
    }

    private String stripOffTags(String value) {
        while (value.indexOf("<") > -1) {
            int startIndex = value.indexOf("<");
            int endIndex = value.substring(startIndex + 1, value.length()).indexOf(">");
            if (endIndex <= -1) continue;
            value = value.substring(0, startIndex) + value.substring(startIndex + 1 + endIndex + 1, value.length());
        }
        return value;
    }

    public String getDescribingText() {
        if (this.delta instanceof PropertyDelta) {
            PropertyDelta pDelta = (PropertyDelta)this.delta;
            String oldValue = "";
            if (pDelta.getOldValue() != null) {
                oldValue = this.stripOffTags(pDelta.getOldValue().toString());
            }
            String newValue = "";
            if (pDelta.getNewValue() != null) {
                newValue = this.stripOffTags(pDelta.getNewValue().toString());
            }
            return "<PropertyChange sourceObject=\"" + pDelta.getSourceObject().getName() + "\"" + " propertyName=\"" + pDelta.getProperty().getName() + "\">" + " <oldValue>" + oldValue + "</oldValue>" + " <newValue>" + newValue + "</newValue>" + "</PropertyChange>";
        }
        if (this.delta instanceof AggregationPositiveDelta) {
            AggregationPositiveDelta pDelta = (AggregationPositiveDelta)this.delta;
            return "<AggregationInsertion  sourceObject=\"" + (pDelta.getSourceObject() != null ? pDelta.getSourceObject().getName() : "Project itself") + "\"" + " createdObject=\"" + pDelta.getObjectToCreate().getName() + "\"/>";
        }
        if (this.delta instanceof AssociationPositiveDelta) {
            AssociationPositiveDelta pDelta = (AssociationPositiveDelta)this.delta;
            return "<AssociationInsertion sourceObject=\"" + pDelta.getSourceObject().getName() + "\"" + " createdReference=\"" + pDelta.getObjectToReference().getName() + "\"/>";
        }
        if (this.delta instanceof AggregationNegativeDelta) {
            AggregationNegativeDelta pDelta = (AggregationNegativeDelta)this.delta;
            return "<AggregationDeletion  sourceObject=\"" + (pDelta.getSourceObject() != null ? pDelta.getSourceObject().getName() : "Project itself") + "\"" + " deletedObject=\"" + pDelta.getObjectToDelete().getName() + "\"/>";
        }
        if (this.delta instanceof AssociationNegativeDelta) {
            AssociationNegativeDelta pDelta = (AssociationNegativeDelta)this.delta;
            return "<AssociationDeletion sourceObject=\"" + pDelta.getSourceObject().getName() + "\"" + " deletedReference=\"" + pDelta.getObjectToRemove().getName() + "\"/>";
        }
        if (this.delta instanceof AggregationDelta) {
            AggregationDelta pDelta = (AggregationDelta)this.delta;
            return "<AggregationExchange sourceObject=\"" + pDelta.getSourceObject().getName() + "\"" + " deletedObject=\"" + pDelta.getObjectToDelete().getName() + "\"" + " createdObject=\"" + pDelta.getObjectToCreate().getName() + "\"/>";
        }
        if (this.delta instanceof AssociationDelta) {
            AssociationDelta pDelta = (AssociationDelta)this.delta;
            return "<AssociationExchange sourceObject=\"" + pDelta.getSourceObject().getName() + "\"" + " deletedReference=\"" + pDelta.getObjectToRemove().getName() + "\"" + " createdReference=\"" + pDelta.getObjectToReference().getName() + "\"/>";
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

