/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.semantic.mdo;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.tools.merge.editor.MetamodelTreeEditorInput;
import com.sap.ide.metamodel.tools.merge.interfaces.IDataSourceManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.MergeInputObjectMDO;
import com.sap.ide.metamodel.tools.merge.services.FileNotExisting;
import com.sap.ide.metamodel.tools.merge.services.TemporaryMDOLocator;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.util.RemoteFileVersionInputStream;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DataSourceManagerMDO
implements IDataSourceManager {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO == null ? (class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO = DataSourceManagerMDO.class$("com.sap.ide.metamodel.tools.merge.semantic.mdo.DataSourceManagerMDO")) : class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO));
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO == null ? (class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO = DataSourceManagerMDO.class$("com.sap.ide.metamodel.tools.merge.semantic.mdo.DataSourceManagerMDO")) : class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO));
    private static final String mmNameprefix = "TemporaryMMFiles";
    private String projectName = null;
    private String packageName = null;
    private String fileName = null;
    private String fileExtension = null;
    private static Hashtable metamodels = new Hashtable();
    private static final String PROJECT_PREFIX = "TEMP_";
    private static final String PROJECT_INSERTION_ACTIVE = "ACTIVE_";
    private static final String PROJECT_INSERTION_CONCURRENT = "CONCURRENT_";
    private static final String PROJECT_INSERTION_ANCESTOR = "ANCESTOR_";
    private IMergeEditorInput input;
    static /* synthetic */ Class class$com$sap$ide$metamodel$tools$merge$semantic$mdo$DataSourceManagerMDO;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;

    public DataSourceManagerMDO(IVfsCheckinCollision collision, boolean check) {
        if (collision != null) {
            IVfsFile localFile = collision.getFolderItemForCollidingVersion().asFile();
            this.setGlobalFileData(localFile);
            if (!check) {
                if (this.projectName == null) {
                    this.errorMessageProjectNotExisting();
                } else {
                    this.setMetamodelEditorInput(localFile, collision.getValidSourceVersion(), collision.getCommonAncestor());
                }
            }
        }
    }

    private void errorMessageProjectNotExisting() {
        final MessageDialog message = new MessageDialog(this.getShell(), "Project not existing", null, "The project for file " + this.fileName + " doesn't exist as an Eclipse project", 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
        message.setBlockOnOpen(true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                message.open();
            }
        });
    }

    public DataSourceManagerMDO(IVfsIntegrateCollision collision, boolean check) {
        if (collision != null) {
            IVfsFile localFile = null;
            try {
                localFile = collision.getActiveVersion().getCorrespondingFile(collision.getWorkspace());
                if (localFile != null) {
                    localFile.sync();
                    this.setGlobalFileData(localFile);
                }
            }
            catch (VfsException e1) {
                tracer.log(2, "Access to integrate collision object failed", (Throwable)e1);
            }
            if (!check) {
                if (this.projectName == null) {
                    this.errorMessageProjectNotExisting();
                } else {
                    this.setMetamodelEditorInput(collision.getActiveVersion(), collision.getCollidingVersion(), collision.getCommonAncestor());
                }
            }
        }
    }

    public boolean isProjectSuited() {
        if (this.projectName == null) {
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        boolean nature = false;
        try {
            nature = project.hasNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
            if (!nature) {
                nature = project.hasNature("com.sap.dictionary.tools.archivebuilder.DictionaryNature");
            }
        }
        catch (CoreException e) {
            tracer.log(2, "Access to project nature of project " + project.getName() + " failed", (Throwable)e);
            nature = false;
        }
        return nature;
    }

    private Shell getShell() {
        IWorkbench workbench = WorkbenchPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public boolean isFileSuited() {
        if (this.fileExtension == null) {
            return false;
        }
        return this.fileExtension.equals("videf") || this.fileExtension.equals("wsdef") || this.fileExtension.equals("wdapplication") || this.fileExtension.equals("wdcomponent") || this.fileExtension.equals("wdcontroller") || this.fileExtension.equals("wdnavigation") || this.fileExtension.equals("wdwindow") || this.fileExtension.equals("wdinterfaceview") || this.fileExtension.equals("wdcomponentinterface") || this.fileExtension.equals("wdmodel") || this.fileExtension.equals("wdmodelclass") || this.fileExtension.equals("dtsimpletype") || this.fileExtension.equals("dtstructure");
    }

    private void setGlobalFileData(IVfsFile file) {
        try {
            this.fileName = file.getDisplayName();
        }
        catch (VfsException e1) {
            tracer.log(2, "DTR fileAccess failed", (Throwable)e1);
        }
        this.fileExtension = this.fileName.substring(this.fileName.indexOf(".") + 1, this.fileName.length());
        this.setProjectName(file);
        if (this.projectName != null) {
            this.setPackageName(file, MetamodelManager.getMetamodel((String)this.projectName).getMDOLocator().getSourcePath());
        }
    }

    private void setMetamodelEditorInput(Object firstObject, IVfsVersion collidingVersion, IVfsVersion ancestorVersion) {
        Metamodel localMetaModel = MetamodelManager.getMetamodel((String)this.projectName);
        try {
            localMetaModel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = DataSourceManagerMDO.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
        }
        catch (MetamodelException e2) {
            tracer.log(2, "Creation of WebDynpro root failed", (Throwable)e2);
        }
        MainDevelopmentObject firstMDO = null;
        if (firstObject instanceof IVfsFile) {
            try {
                firstMDO = this.getMDO(localMetaModel);
            }
            catch (FileNotExisting e) {
                tracer.log(2, "File " + this.fileName + " is not existing.", (Throwable)e);
            }
        } else if (firstObject instanceof IVfsVersion) {
            firstMDO = this.getMDO((IVfsVersion)firstObject, localMetaModel, PROJECT_INSERTION_ACTIVE);
        } else {
            return;
        }
        MainDevelopmentObject collidingMDO = this.getMDO(collidingVersion, localMetaModel, PROJECT_INSERTION_CONCURRENT);
        MainDevelopmentObject ancestorMDO = this.getMDO(ancestorVersion, localMetaModel, PROJECT_INSERTION_ANCESTOR);
        final Metamodel lmm = localMetaModel;
        this.input = new MetamodelTreeEditorInput(new MergeInputObjectMDO(firstMDO){

            public void save() {
                MetamodelManager.saveAllMetaData((Metamodel)lmm);
            }

            public void rollback() {
                MetamodelManager.rollbackMetaData((Metamodel)lmm);
            }
        }, new MergeInputObjectMDO(collidingMDO), new MergeInputObjectMDO(ancestorMDO));
    }

    private Metamodel getMetamodel(String projectName, MDOLocator locator) {
        Metamodel metaModel = (Metamodel)metamodels.get(projectName);
        if (metaModel == null) {
            try {
                metaModel = new Metamodel(projectName, locator);
            }
            catch (MetamodelException e) {
                tracer.log(2, "Couldn't create new metamodel instance", (Throwable)e);
            }
            try {
                metaModel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = DataSourceManagerMDO.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            }
            catch (MetamodelException e) {
                tracer.log(2, "Creation of WebDynpro root failed", (Throwable)e);
            }
            metamodels.put(projectName, metaModel);
        } else {
            try {
                metaModel.clear();
            }
            catch (MetamodelException e) {
                tracer.log(3, "Clearing of metamodel failed", (Throwable)e);
            }
        }
        return metaModel;
    }

    private File createTemporaryFileForDtrVersion(IVfsVersion version, String projectNameInsertion) {
        try {
            File targetFile;
            File targetDir = new File(this.getTargetPathDirectory(projectNameInsertion));
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            if ((targetFile = new File(targetDir, version.getDisplayName())).exists()) {
                targetFile.delete();
            }
            targetFile.createNewFile();
            targetFile.deleteOnExit();
            InputStream is = RemoteFileVersionInputStream.getInputStream((IVfsVersion)version);
            this.createFile(is, targetFile);
            return targetFile;
        }
        catch (IOException ex) {
            tracer.log(2, "Processing of local file " + version.getDisplayName() + " in path " + this.getTargetPathDirectory(projectNameInsertion) + " failed", (Throwable)ex);
            return null;
        }
    }

    private String getTargetPathDirectory(String projectNameInsertion) {
        return this.getTargetSourcePath(projectNameInsertion) + File.separator + this.packageName;
    }

    private String getTargetSourcePath(String projectNameInsertion) {
        return System.getProperty("java.io.tmpdir") + mmNameprefix + File.separator + this.getTemporaryProjectName(projectNameInsertion);
    }

    private String getTemporaryProjectName(String projectNameInsertion) {
        return PROJECT_PREFIX + projectNameInsertion + this.projectName;
    }

    private void setProjectName(IVfsFile file) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String currentPath = file.getLocalPath();
        if (currentPath != null) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    ArrayList list = MetamodelManager.getMetamodelManager((String)projects[i].getName()).getProjectSourcePaths();
                    int j = 0;
                    while (j < list.size()) {
                        if (currentPath.startsWith((String)list.get(j))) {
                            this.projectName = projects[i].getName();
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void setPackageName(IVfsFile file, String sourcePath) {
        String wholePath = file.getLocalPath();
        int i = sourcePath.indexOf("gen_wdp");
        if (i > -1) {
            sourcePath = sourcePath.substring(0, i) + "src" + sourcePath.substring(i + 7, sourcePath.length());
        }
        if (wholePath.indexOf(sourcePath) > -1) {
            if ((wholePath = wholePath.substring(sourcePath.length() + 1)).indexOf(this.fileName) > -1) {
                wholePath = wholePath.substring(0, wholePath.indexOf(this.fileName) - 1);
            }
            this.packageName = wholePath.replace('\\', '.');
        }
    }

    private MainDevelopmentObject getMDO(IVfsVersion version, Metamodel metaModel, String projectNameInsertion) {
        this.createTemporaryFileForDtrVersion(version, projectNameInsertion);
        Metamodel newMetaModel = null;
        TemporaryMDOLocator mdoLocator = new TemporaryMDOLocator(this.getTargetSourcePath(projectNameInsertion), this.projectName, this.getTemporaryProjectName(projectNameInsertion));
        newMetaModel = this.getMetamodel(this.getTemporaryProjectName(projectNameInsertion), mdoLocator);
        MainDevelopmentObject newMDO = null;
        if (newMetaModel != null) {
            String[] archives = metaModel.getArchives();
            int i = 0;
            while (i < archives.length) {
                newMetaModel.addArchive(archives[i]);
                ++i;
            }
            try {
                newMDO = this.getMDO(newMetaModel);
            }
            catch (FileNotExisting e) {
                tracer.log(2, "File " + this.fileName + " is not existing.", (Throwable)e);
            }
        }
        return newMDO;
    }

    private MainDevelopmentObject getMDO(Metamodel metaModel) throws FileNotExisting {
        String name = this.fileName.substring(0, this.fileName.indexOf(46));
        String ext = this.fileName.substring(this.fileName.indexOf(46) + 1, this.fileName.length());
        Root[] roots = metaModel.getRoots();
        int i = 0;
        while (i < roots.length) {
            MDOEnum[] enums = roots[i].getMDOEnums();
            int j = 0;
            while (j < enums.length) {
                ForeignReference key;
                MainDevelopmentObject mdo;
                if (ext.equals(enums[j].getFileExtension()) && (mdo = (MainDevelopmentObject)metaModel.getObjectFromKey((DevelopmentObjectKey)(key = new ForeignReference(enums[j].getModelName(), this.packageName, name, enums[j])))) != null) {
                    return mdo;
                }
                ++j;
            }
            ++i;
        }
        throw new FileNotExisting();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void createFile(InputStream inputStream, File file) {
        block19: {
            int bytesRead;
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                void var4_6;
                fileOutputStream.write(buffer, 0, (int)var4_6);
            }
            Object var7_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block19;
            }
            catch (IOException x) {
                tracer.log(2, "IO exception: " + x.getMessage(), (Throwable)x);
            }
            break block19;
            {
                catch (FileNotFoundException e) {
                    tracer.log(2, "File " + file.toString() + " is not existing.", (Throwable)e);
                    Object var7_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException x) {
                        tracer.log(2, "IO exception: " + x.getMessage(), (Throwable)x);
                    }
                    break block19;
                }
                catch (IOException ex) {
                    tracer.log(2, "IO exception: " + ex.getMessage(), (Throwable)ex);
                    Object var7_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException x) {
                        tracer.log(2, "IO exception: " + x.getMessage(), (Throwable)x);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException x) {
                    tracer.log(2, "IO exception: " + x.getMessage(), (Throwable)x);
                }
                throw throwable;
            }
        }
    }

    public IMergeEditorInput getMetamodelEditorInput() {
        this.input.getMergeConfiguration().setDiffingForNW04(false);
        return this.input;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

