/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.images;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class MMDecoratedImage
extends CompositeImageDescriptor {
    static final int HEIGHT = 16;
    private Image fBaseImage;
    private ImageDescriptor fOverlayImage;
    private int fWidth;
    private int position;
    public static final int TOP_LEFT = 0;
    public static final int BOTTOM_LEFT = 1;
    public static final int MIDDLE_LEFT = 2;
    public static final int TOP_RIGHT = 3;
    public static final int BOTTOM_RIGHT = 4;
    public static final int MIDDLE_RIGHT = 5;

    public MMDecoratedImage(Image base, ImageDescriptor overlay, int width, int position) {
        this.fBaseImage = base;
        this.fOverlayImage = overlay;
        this.fWidth = width;
        this.position = position;
    }

    protected Point getSize() {
        return new Point(this.fWidth, 16);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData base = null;
        ImageData overlay = null;
        if (this.fBaseImage != null && (base = this.fBaseImage.getImageData()) == null) {
            base = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        if (this.fOverlayImage != null && (overlay = this.fOverlayImage.getImageData()) == null) {
            overlay = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        int yPos = this.position == 0 || this.position == 3 ? 1 : (this.position == 2 || this.position == 5 ? (16 - overlay.height) / 2 : 16 - overlay.height - 1);
        if (this.position == 0 || this.position == 2 || this.position == 1) {
            if (this.fBaseImage != null) {
                this.drawImage(base, this.fWidth - base.width, 0);
            }
            if (this.fOverlayImage != null) {
                this.drawImage(overlay, 0, yPos);
            }
        } else if (this.position == 3 || this.position == 5 || this.position == 4) {
            if (this.fBaseImage != null) {
                this.drawImage(base, 0, 0);
            }
            if (this.fOverlayImage != null) {
                this.drawImage(overlay, this.fWidth - overlay.width, yPos);
            }
        }
    }
}

