/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.general;

import com.sap.ide.metamodel.tools.merge.editor.CorrespondingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeProperty;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeSubObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IPropertyRow;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.PropertyRowMDO;
import java.util.Vector;

public class GlobalMergeManager
implements IGlobalTreeMergeManager {
    private DifferenceStorage localStorage;
    private DifferenceStorage[] dsToAncestor = new DifferenceStorage[2];
    private IMergeTreeContentProvider[] tcps = new IMergeTreeContentProvider[3];
    private CorrespondingNodesManager correspondingNodesManager;
    private String[] treeHeaderTexts = new String[3];
    private String[] propertyHeaderTexts = new String[3];

    public GlobalMergeManager(IMergeInputObject[] inputObjects) {
        this.localStorage = inputObjects[0].buildDifferenceStorage(inputObjects[1], true);
        int i = 0;
        while (i <= 1) {
            if (inputObjects[2] != null) {
                this.dsToAncestor[i] = inputObjects[i].buildDifferenceStorage(inputObjects[2], false);
            }
            this.tcps[i] = inputObjects[i].getContentProvider();
            ++i;
        }
        if (inputObjects[2] != null) {
            this.tcps[2] = inputObjects[2].getContentProvider();
        }
        this.correspondingNodesManager = new CorrespondingNodesManager(this);
    }

    public String getTreeHeaderText(int usage) {
        if (this.treeHeaderTexts != null && this.treeHeaderTexts.length > usage) {
            return this.treeHeaderTexts[usage];
        }
        return "";
    }

    public String getPropertyHeaderText(int usage) {
        if (this.propertyHeaderTexts != null && this.propertyHeaderTexts.length > usage) {
            return this.propertyHeaderTexts[usage];
        }
        return "";
    }

    public void setTreeHeaderTexts(String[] texts) {
        this.treeHeaderTexts = texts;
    }

    public void setPropertyHeaderTexts(String[] texts) {
        this.propertyHeaderTexts = texts;
    }

    public DifferenceStorage getLocalStorage() {
        return this.localStorage;
    }

    public DifferenceStorage[] getStoragesToAncestor() {
        return this.dsToAncestor;
    }

    public IMergeTreeContentProvider getTcpForUsage(int usage) {
        return this.tcps[usage];
    }

    public CorrespondingNodesManager getCorrespondingNodesManager() {
        return this.correspondingNodesManager;
    }

    public IPropertyRow[] getAllPropertyRows(IMergeTreeNode[] treeNodes) {
        Vector properties = new Vector();
        int i = 0;
        while (i <= 2) {
            if (treeNodes[i] != null) {
                IMergeSubObject subObject = treeNodes[i].getUserObject();
                this.addAllProperties(properties, subObject.getAllProperties());
            }
            ++i;
        }
        if (properties == null || properties.size() == 0) {
            return new IPropertyRow[0];
        }
        IPropertyRow[] rows = new IPropertyRow[properties.size()];
        int i2 = 0;
        while (i2 < properties.size()) {
            rows[i2] = new PropertyRowMDO((IMergeProperty)properties.elementAt(i2), treeNodes);
            ++i2;
        }
        return rows;
    }

    private void addAllProperties(Vector properties, IMergeProperty[] additionalProperties) {
        int i = 0;
        while (i < additionalProperties.length) {
            IMergeProperty addProperty = additionalProperties[i];
            boolean found = false;
            int j = 0;
            while (j < properties.size() && !found) {
                if (addProperty.equals(properties.elementAt(j))) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                properties.add(addProperty);
            }
            ++i;
        }
    }

    public boolean isThreeWayMergePossible() {
        return this.dsToAncestor[0] != null && this.dsToAncestor[1] != null;
    }
}

