/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.refresh;

import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;

public abstract class AbstractRefreshHandler {
    private MetaModelTreeEditor mmEditor;
    private boolean refreshWithRestoring;

    public AbstractRefreshHandler(MetaModelTreeEditor editor) {
        this(editor, true);
    }

    public AbstractRefreshHandler(MetaModelTreeEditor editor, boolean refreshWithRestoring) {
        this.mmEditor = editor;
        this.refreshWithRestoring = refreshWithRestoring;
    }

    public void refresh(int index) {
        TreeViewerView tv = this.mmEditor.getTreeViewer(index);
        Vector leavesToShow = this.getLeavesToShow(tv);
        ISelection selection = tv.getSelection();
        this.actionBeforeRefresh(index);
        if (this.refreshWithRestoring) {
            tv.refresh();
        } else {
            tv.refreshWithoutRestoring();
        }
        Vector elementsToExpand = this.getElementsToExpand(leavesToShow, index);
        this.actionAfterRefresh(elementsToExpand, index);
        tv.setExpandedElements(elementsToExpand.toArray(new Object[elementsToExpand.size()]));
        this.setSelection(selection, index);
    }

    public abstract void actionBeforeRefresh(int var1);

    public abstract void actionAfterRefresh(Vector var1, int var2);

    public abstract void setSelection(ISelection var1, int var2);

    private Vector getElementsToExpand(Vector leavesToExpand, int treeIndex) {
        Vector<IMergeTreeNode> results = new Vector<IMergeTreeNode>();
        TreeViewerView tv = this.mmEditor.getTreeViewer(treeIndex);
        IMergeTreeContentProvider tcp = tv.getContentProvider();
        int i = 0;
        while (i < leavesToExpand.size()) {
            IMergeTreeNode node = (IMergeTreeNode)leavesToExpand.elementAt(i);
            if (!tcp.getNodeHider().isForbidden(node)) {
                node = (IMergeTreeNode)node.getParent();
                while (node != null) {
                    if (!results.contains(node)) {
                        results.add(node);
                        node = (IMergeTreeNode)node.getParent();
                        continue;
                    }
                    node = null;
                }
            }
            ++i;
        }
        return results;
    }

    private Vector getLeavesToShow(TreeViewerView treeViewer) {
        Object[] expandedElements = treeViewer.getExpandedElements();
        Vector<Object> results = new Vector<Object>();
        int i = 0;
        while (i < expandedElements.length) {
            IMergeTreeNode expandedElement = (IMergeTreeNode)expandedElements[i];
            Object[] children = expandedElement.getChildren();
            int j = 0;
            while (j < children.length) {
                if (!results.contains(children[j])) {
                    results.add(children[j]);
                }
                ++j;
            }
            ++i;
        }
        return results;
    }
}

