/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.property;

import com.sap.ide.metamodel.tools.merge.editor.property.MMCellEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class LongCellEditor
extends MMCellEditor {
    public LongCellEditor() {
        this.setValidator(new Validator());
    }

    protected Object doGetValue() {
        return new Long(this.text.getText());
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof Long ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(((Long)value).toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    class Validator
    implements ICellEditorValidator {
        Validator() {
        }

        public String isValid(Object value) {
            if (value instanceof Long) {
                LongCellEditor.this.setError(false);
            } else if (value instanceof String) {
                String s = (String)value;
                try {
                    Long longValue = new Long(s);
                    LongCellEditor.this.setError(false);
                }
                catch (NumberFormatException e) {
                    LongCellEditor.this.setError(true);
                }
            }
            return LongCellEditor.this.valid ? null : "Wrong value";
        }
    }
}

