/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.property;

import com.sap.ide.metamodel.tools.merge.editor.property.MMCellEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class IntegerCellEditor
extends MMCellEditor {
    public IntegerCellEditor() {
        this.setValidator(new Validator());
    }

    protected Object doGetValue() {
        return new Integer(this.text.getText());
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof Integer ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(((Integer)value).toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    class Validator
    implements ICellEditorValidator {
        Validator() {
        }

        public String isValid(Object value) {
            if (value instanceof Integer) {
                IntegerCellEditor.this.setError(false);
            } else if (value instanceof String) {
                String s = (String)value;
                try {
                    Integer intValue = new Integer(s);
                    IntegerCellEditor.this.setError(false);
                }
                catch (NumberFormatException e) {
                    IntegerCellEditor.this.setError(true);
                }
            }
            return IntegerCellEditor.this.valid ? null : "Wrong value";
        }
    }
}

