/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.property;

import com.sap.ide.metamodel.tools.merge.editor.property.MMCellEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class DoubleCellEditor
extends MMCellEditor {
    public DoubleCellEditor() {
        this.setValidator(new Validator());
    }

    protected Object doGetValue() {
        return new Double(this.text.getText());
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof Double ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(((Double)value).toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    class Validator
    implements ICellEditorValidator {
        Validator() {
        }

        public String isValid(Object value) {
            if (value instanceof Double) {
                DoubleCellEditor.this.setError(false);
            } else if (value instanceof String) {
                String s = (String)value;
                try {
                    Double doubleValue = new Double(s);
                    DoubleCellEditor.this.setError(false);
                }
                catch (NumberFormatException e) {
                    DoubleCellEditor.this.setError(true);
                }
            }
            return DoubleCellEditor.this.valid ? null : "Wrong value";
        }
    }
}

