/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.property;

import com.sap.ide.metamodel.tools.merge.editor.property.MMCellEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class ByteCellEditor
extends MMCellEditor {
    public ByteCellEditor() {
        this.setValidator(new Validator());
    }

    protected Object doGetValue() {
        return new Byte(this.text.getText());
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof Byte ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(((Byte)value).toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    class Validator
    implements ICellEditorValidator {
        Validator() {
        }

        public String isValid(Object value) {
            if (value instanceof Integer) {
                ByteCellEditor.this.setError(false);
            } else if (value instanceof String) {
                String s = (String)value;
                try {
                    Integer intValue = new Integer(s);
                    ByteCellEditor.this.setError(false);
                }
                catch (NumberFormatException e) {
                    ByteCellEditor.this.setError(true);
                }
            }
            return ByteCellEditor.this.valid ? null : "Wrong value";
        }
    }
}

