/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.property;

import com.sap.ide.metamodel.tools.merge.editor.property.MMCellEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class BooleanCellEditor
extends MMCellEditor {
    public BooleanCellEditor() {
        this.setValidator(new Validator());
    }

    protected Object doGetValue() {
        return new Boolean(this.text.getText());
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof Boolean ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(((Boolean)value).toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    class Validator
    implements ICellEditorValidator {
        Validator() {
        }

        public String isValid(Object value) {
            if (value instanceof Boolean) {
                BooleanCellEditor.this.setError(false);
            } else if (value instanceof String) {
                String s = (String)value;
                try {
                    Boolean boolValue = new Boolean(s);
                    BooleanCellEditor.this.setError(false);
                }
                catch (NumberFormatException e) {
                    BooleanCellEditor.this.setError(true);
                }
            }
            return BooleanCellEditor.this.valid ? null : "Wrong value";
        }
    }
}

