/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractSelectionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;

public class SelectionContribution
extends AbstractSelectionContribution
implements NodeSelectedListener,
ITreeViewerListener {
    private TreeViewerView targetTreeViewer;
    private TreeViewerView sourceTreeViewer;

    public SelectionContribution(DifferenceStorage ds, TreeViewerView sourceTreeViewer, TreeViewerView targetTreeViewer) {
        super(ds);
        this.targetTreeViewer = targetTreeViewer;
        this.sourceTreeViewer = sourceTreeViewer;
    }

    private IMergeTreeNode getCorrespondingNode(IMergeTreeNode originalNode) {
        if (originalNode != null) {
            return this.getCorrespondingNodeInTCP(this.targetTreeViewer.getContentProvider(), originalNode);
        }
        return null;
    }

    public void nodeSelected(IMergeTreeNode node) {
        if (node == null) {
            return;
        }
        this.sourceTreeViewer.setConflictInfo(node);
        if (!node.isSuitedForCorrespondingToOtherNodes()) {
            return;
        }
        IMergeTreeNode correspondingNode = this.getCorrespondingNode(node);
        if (correspondingNode != null) {
            IStructuredSelection treeSelection = (IStructuredSelection)this.targetTreeViewer.getSelection();
            if (treeSelection.getFirstElement() != correspondingNode) {
                this.targetTreeViewer.setSelection((ISelection)new StructuredSelection((Object)correspondingNode));
            }
        } else {
            IMergeTreeNode currentNode = node;
            while (currentNode.getDirectParent() != null) {
                currentNode = currentNode.getDirectParent();
                this.modifyTreeExpansionState(currentNode, true, false);
            }
        }
    }

    private IMergeTreeNode getNodeFromTreeExpansionEvent(TreeExpansionEvent event) {
        Object element = event.getElement();
        if (element instanceof TreeNode) {
            return (IMergeTreeNode)((TreeNode)element).getData();
        }
        if (element instanceof IMergeTreeNode) {
            return (IMergeTreeNode)element;
        }
        return null;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.modifyTreeExpansionState(this.getNodeFromTreeExpansionEvent(event), true, true);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.modifyTreeExpansionState(this.getNodeFromTreeExpansionEvent(event), false, true);
    }

    private void modifyTreeExpansionState(IMergeTreeNode node, boolean expand, boolean necessarily) {
        IMergeTreeNode correspondingNode;
        if (node != null && node.isSuitedForCorrespondingToOtherNodes() && (correspondingNode = this.getCorrespondingNode(node)) != null) {
            boolean isExpanded = false;
            if (necessarily) {
                isExpanded = !expand;
            } else {
                Object[] expandedElements = this.targetTreeViewer.getExpandedElements();
                int i = 0;
                while (i < expandedElements.length) {
                    if (expandedElements[i] == correspondingNode) {
                        isExpanded = true;
                        break;
                    }
                    ++i;
                }
            }
            if (expand != isExpanded) {
                this.targetTreeViewer.setExpandedState(correspondingNode, expand);
            }
        }
    }
}

