/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractSelectionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.sap.ide.tools.core.treemappingcomponent.tree.EnframeStyles;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite;

public class LinkContribution
extends AbstractSelectionContribution {
    private TreeMappingComposite treeMappingComposite;
    private TreeViewerView[] views;

    public LinkContribution(DifferenceStorage ds, TreeMappingComposite tmc, TreeViewerView[] views) {
        super(ds);
        this.views = views;
        this.treeMappingComposite = tmc;
    }

    public void drawAllLinks() {
        IMergeDelta[] deltas = this.getAllDeltas();
        if (deltas != null) {
            int i = 0;
            while (i < deltas.length) {
                new DeltaObject(deltas[i]).drawSingleLink();
                ++i;
            }
        }
    }

    private class DeltaObject {
        private IMergeDelta delta;

        public DeltaObject(IMergeDelta delta) {
            this.delta = delta;
        }

        private int getInt(int usage) {
            if (usage == 0) {
                return 16384;
            }
            if (usage == 1) {
                return 131072;
            }
            return -1;
        }

        public void drawSingleLink() {
            IMergeTreeNode[] nodes = new IMergeTreeNode[2];
            int i = 0;
            while (i <= 1) {
                nodes[i] = LinkContribution.this.findCorrespondingNode(LinkContribution.this.views[i], this.delta.getUniqueTreeIdentification(i));
                ++i;
            }
            if (nodes[0] != null && nodes[1] != null) {
                LinkContribution.this.treeMappingComposite.createLink((Object)nodes[0], (Object)nodes[1], EnframeStyles.RECTANGLE, EnframeStyles.RECTANGLE, !this.delta.isAttributeDelta(), !this.delta.isAttributeDelta());
            } else {
                int i2 = 0;
                while (i2 < nodes.length) {
                    if (nodes[i2] != null) {
                        LinkContribution.this.treeMappingComposite.createShape((Object)nodes[i2], EnframeStyles.RECTANGLE, !this.delta.isAttributeDelta(), this.getInt(i2));
                    }
                    ++i2;
                }
            }
        }
    }
}

