/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.ApplyUnapplyListener;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.editor.compare.LoadResetter;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DifferenceStorage {
    private LoadResetter resetter;
    private Hashtable compareTableForObjectsItself = new Hashtable();
    protected IMergeDelta[] deltas;
    private Hashtable deltasForNodes = new Hashtable();
    private IMergeInputObject originalInputObject;
    private IMergeInputObject secondInputObject;

    public DifferenceStorage(IMergeInputObject originalObject, IMergeInputObject secondObject) {
        this.originalInputObject = originalObject;
        this.secondInputObject = secondObject;
        this.resetter = new LoadResetter();
        this.reset();
    }

    protected Shell getShell() {
        IWorkbench workbench = WorkbenchPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    private void reset() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.open();
        IProgressMonitor monitor = dialog.getProgressMonitor();
        monitor.beginTask("Analysing metamodel data", 10);
        monitor.worked(2);
        this.rethinkDeltas();
        try {
            this.deltas = this.originalInputObject.compareTo(this.secondInputObject);
            if (this.deltas != null) {
                this.compareTableForObjectsItself = new Hashtable(2 * this.deltas.length + 1);
                int i = 0;
                while (i < this.deltas.length) {
                    IUniqueTreeIdentification[] treeIdents = this.deltas[i].getUniqueTreeIdentifications();
                    int j = 0;
                    while (j < treeIdents.length) {
                        if (!treeIdents[j].isEmpty()) {
                            this.putDeltaForTreeIdent(treeIdents[j], this.deltas[i]);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.done();
            dialog.close();
            throw throwable;
        }
        monitor.done();
        dialog.close();
    }

    public IMergeInputObject getInputObject(int usage) {
        if (usage == 0) {
            return this.originalInputObject;
        }
        if (usage == 1) {
            return this.secondInputObject;
        }
        return null;
    }

    public IMergeDelta[] getAllDeltas() {
        return this.deltas;
    }

    protected IMergeDelta[] getDeltasForTreeIdent(IUniqueTreeIdentification treeIdent) {
        Object o = this.compareTableForObjectsItself.get(treeIdent);
        if (o instanceof IMergeDelta) {
            return new IMergeDelta[]{(IMergeDelta)o};
        }
        if (o instanceof Vector) {
            return ((Vector)o).toArray(new IMergeDelta[((Vector)o).size()]);
        }
        return null;
    }

    protected void putDeltaForTreeIdent(IUniqueTreeIdentification treeIdent, IMergeDelta delta) {
        if (treeIdent == null) {
            return;
        }
        Object o = this.compareTableForObjectsItself.get(treeIdent);
        if (o == null) {
            this.compareTableForObjectsItself.put(treeIdent, delta);
        } else {
            Vector v;
            if (o instanceof IMergeDelta) {
                v = new Vector(2);
                v.add(o);
                this.compareTableForObjectsItself.put(treeIdent, v);
            } else if (o instanceof Vector) {
                v = (Vector)o;
            } else {
                return;
            }
            v.add(delta);
        }
    }

    public void possiblyAddLoadResetListener(IMergeDelta delta, ApplyUnapplyListener listener) {
        this.resetter.addListenerForDelta(delta, listener);
    }

    public void resetForDelta(IMergeDelta delta) {
        if (this.resetter != null) {
            this.resetter.resetForDelta(delta);
        }
    }

    public void rethinkDeltas() {
        this.deltasForNodes.clear();
    }

    public DeltaAnalyser getDeltaForNode(Object key) {
        if (key == null) {
            return null;
        }
        return (DeltaAnalyser)this.deltasForNodes.get(key);
    }

    public void putDeltaForNode(Object key, DeltaAnalyser da) {
        this.deltasForNodes.put(key, da);
    }

    public void recompare() {
        this.reset();
    }
}

