/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.images.MMImageManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import org.eclipse.jface.resource.ImageDescriptor;

public class DeltaAnalyser {
    private IMergeDelta[] deltas;
    private DifferenceStorage differenceStorage;
    private IMergeTreeNode currentNode;
    private boolean original;
    private static ImageDescriptor confPlusImageDesc = MMImageManager.createImageDescriptor("confadd_small_ov.gif");
    private static ImageDescriptor confMinusImageDesc = MMImageManager.createImageDescriptor("confdel_small_ov.gif");
    private static ImageDescriptor confChangeImageDesc = MMImageManager.createImageDescriptor("confchg_small_ov.gif");
    private static ImageDescriptor confPlusImageAppDesc = MMImageManager.createImageDescriptor("confadd_app_small_ov.gif");
    private static ImageDescriptor confMinusImageAppDesc = MMImageManager.createImageDescriptor("confdel_app_small_ov.gif");
    private static ImageDescriptor confChangeImageAppDesc = MMImageManager.createImageDescriptor("confchg_app_small_ov.gif");
    private static ImageDescriptor confPlusImageDerDesc = MMImageManager.createImageDescriptor("confadd_small_ov_derived.gif");
    private static ImageDescriptor confMinusImageDerDesc = MMImageManager.createImageDescriptor("confdel_small_ov_derived.gif");
    private static ImageDescriptor confChangeImageDerDesc = MMImageManager.createImageDescriptor("confchg_small_ov_derived.gif");
    private static ImageDescriptor confPlusImageAppDerDesc = MMImageManager.createImageDescriptor("confadd_app_small_ov_derived.gif");
    private static ImageDescriptor confMinusImageAppDerDesc = MMImageManager.createImageDescriptor("confdel_app_small_ov_derived.gif");
    private static ImageDescriptor confChangeImageAppDerDesc = MMImageManager.createImageDescriptor("confchg_app_small_ov_derived.gif");

    public DeltaAnalyser(Object delta, DifferenceStorage ds, IMergeTreeNode node) {
        this(delta, ds, node, true);
    }

    public DeltaAnalyser(Object delta, DifferenceStorage ds, IMergeTreeNode node, boolean o) {
        if (delta == null) {
            this.deltas = null;
        } else if (delta instanceof IMergeDelta[]) {
            this.deltas = (IMergeDelta[])delta;
        }
        this.differenceStorage = ds;
        if (node != null) {
            this.currentNode = node;
            this.differenceStorage.putDeltaForNode(node, this);
        }
        this.original = o;
    }

    public DeltaAnalyser clone(IMergeTreeNode newNode) {
        return new DeltaAnalyser(this.deltas, this.differenceStorage, newNode, false);
    }

    public IMergeDelta[] getDeltas() {
        return this.deltas;
    }

    public boolean isEmpty() {
        return this.deltas == null;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public boolean isApplicable() {
        int i = 0;
        while (i < this.deltas.length) {
            if (!this.deltas[i].isApplied()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRevertable() {
        int i = 0;
        while (i < this.deltas.length) {
            IMergeDelta mergeDelta = this.deltas[i];
            if (mergeDelta.isApplied()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean mayBeSetAsRoot() {
        if (this.deltas == null) {
            return true;
        }
        int i = 0;
        while (i < this.deltas.length) {
            IMergeDelta mergeDelta = this.deltas[i];
            if (mergeDelta == null) {
                return true;
            }
            if (mergeDelta.isExchangeDelta()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.deltas == null || this.currentNode == null || this.currentNode.getUserObject() == null) {
            return null;
        }
        IMergeDelta mergeDelta = this.deltas[0];
        if (mergeDelta == null) {
            return null;
        }
        if (mergeDelta.isNegativeDelta()) {
            if (mergeDelta.isApplied()) {
                if (!this.original) {
                    return confPlusImageAppDerDesc;
                }
                return confPlusImageAppDesc;
            }
            if (!this.original) {
                return confPlusImageDerDesc;
            }
            return confPlusImageDesc;
        }
        if (mergeDelta.isAttributeDelta()) {
            if (this.isApplicable()) {
                if (!this.original) {
                    return null;
                }
                return confChangeImageDesc;
            }
            if (!this.original) {
                return confChangeImageAppDerDesc;
            }
            return confChangeImageAppDesc;
        }
        if (mergeDelta.isExchangeDelta()) {
            if (mergeDelta.isApplied()) {
                if (this.currentNode.getUserObject().getContent() == mergeDelta.getObjectToDelete()) {
                    return confChangeImageAppDesc;
                }
                return confChangeImageAppDerDesc;
            }
            if (this.currentNode.getUserObject().getContent() == mergeDelta.getObjectToDelete()) {
                return confChangeImageDesc;
            }
            return confChangeImageDerDesc;
        }
        return null;
    }
}

