/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.CorrespondingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractSelectionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import com.sap.ide.metamodel.tools.merge.tree.ConflictingNode;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ChildBackwardGetter;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ChildForwardGetter;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ChildGetter;
import com.sap.ide.metamodel.tools.merge.tree.iterator.MMMParallelIterator;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ParallelBackwardIterator;
import com.sap.ide.metamodel.tools.merge.tree.iterator.ParallelForwardIterator;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ConflictingNodesContribution
extends AbstractSelectionContribution {
    private Vector conflictingNodes;
    private CorrespondingNodesManager manager;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$metamodel$tools$merge$editor$compare$ConflictingNodesContribution == null ? (class$com$sap$ide$metamodel$tools$merge$editor$compare$ConflictingNodesContribution = ConflictingNodesContribution.class$("com.sap.ide.metamodel.tools.merge.editor.compare.ConflictingNodesContribution")) : class$com$sap$ide$metamodel$tools$merge$editor$compare$ConflictingNodesContribution));
    static /* synthetic */ Class class$com$sap$ide$metamodel$tools$merge$editor$compare$ConflictingNodesContribution;

    public ConflictingNodesContribution(DifferenceStorage ds, CorrespondingNodesManager manager) {
        super(ds);
        this.manager = manager;
    }

    public void rebuildConflictingNodes(TreeViewerView[] views) {
        IMergeDelta[] deltas = this.getAllDeltas();
        if (deltas == null) {
            return;
        }
        this.conflictingNodes = new Vector(deltas.length);
        int i = 0;
        while (i < deltas.length) {
            block12: {
                ConflictingNode newNode;
                IMergeDelta delta;
                block9: {
                    IUniqueTreeIdentification[] treeIdents;
                    block11: {
                        block10: {
                            block8: {
                                delta = deltas[i];
                                treeIdents = delta.getUniqueTreeIdentifications();
                                newNode = null;
                                if (!delta.isAttributeDelta()) break block8;
                                newNode = new ConflictingNode(this.findCorrespondingNode(views[0], treeIdents[0]), this.findCorrespondingNode(views[1], treeIdents[0]), delta);
                                break block9;
                            }
                            if (!delta.isExchangeDelta()) break block10;
                            newNode = new ConflictingNode(this.findCorrespondingNode(views[0], treeIdents[0]), this.findCorrespondingNode(views[1], treeIdents[1]), delta);
                            break block9;
                        }
                        if (!delta.isPositiveDelta()) break block11;
                        newNode = new ConflictingNode(null, this.findCorrespondingNode(views[1], treeIdents[0]), delta);
                        break block9;
                    }
                    if (!delta.isNegativeDelta() || delta.isApplied()) break block12;
                    newNode = new ConflictingNode(this.findCorrespondingNode(views[0], treeIdents[0]), null, delta);
                }
                boolean found = false;
                int j = 0;
                while (j < this.conflictingNodes.size()) {
                    ConflictingNode cn = (ConflictingNode)this.conflictingNodes.elementAt(j);
                    if (cn.equals(newNode)) {
                        cn.addDelta(delta);
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.conflictingNodes.add(newNode);
                }
            }
            ++i;
        }
    }

    private int getNumberOfConflictingAncestorNode(int treeNumber, IMergeTreeNode node, boolean forward) {
        int number = -1;
        while (this.noConflictDetected(number) && node != null) {
            number = this.getNumberOfConflictingNode(treeNumber, node, forward);
            node = node.getDirectParent();
        }
        return number;
    }

    public int getNumberOfConflictingNode(int treeNumber, IMergeTreeNode node, boolean forward) {
        if (this.conflictingNodes != null) {
            int i = 0;
            while (i < this.conflictingNodes.size()) {
                ConflictingNode cn = (ConflictingNode)this.conflictingNodes.elementAt(i);
                if (cn.containsNode(treeNumber, node)) {
                    return i;
                }
                ++i;
            }
        }
        if (forward) {
            return -1;
        }
        return 10000;
    }

    public boolean noConflictDetected(int index) {
        return index == -1 || index == 10000;
    }

    public ConflictingNode getConflictingNode(int index) {
        if (index < 0 || index >= this.conflictingNodes.size()) {
            return new ConflictingNode(null, null, null);
        }
        return (ConflictingNode)this.conflictingNodes.elementAt(index);
    }

    public ConflictingNode selectError(IMergeTreeNode[] selectedNodes, boolean next) {
        ConflictingNode firstCheck = this.detectNextConflict(selectedNodes, next, true);
        if (firstCheck != null) {
            return firstCheck;
        }
        MMMParallelIterator iterator = this.getParallelIterator(next, selectedNodes);
        boolean search = false;
        while (iterator.hasNext()) {
            TreeNode[] nodes = (TreeNode[])iterator.next();
            if (nodes[0] == null || nodes[1] == null) {
                return null;
            }
            if (!search) {
                if (nodes[0] != selectedNodes[0]) continue;
                search = true;
                continue;
            }
            ConflictingNode nextCheck = this.detectNextConflict((IMergeTreeNode[])nodes, next, false);
            if (nextCheck == null) continue;
            return nextCheck;
        }
        return null;
    }

    private boolean doNodesCorrespond(IMergeTreeNode[] nodes) {
        if (nodes[0] == null || nodes[1] == null) {
            return false;
        }
        IMergeTreeNode corrNode = this.manager.getCorrespondingNode(nodes[0], 1);
        return nodes[1].equals(corrNode);
    }

    private ConflictingNode detectNextConflict(IMergeTreeNode[] nodes, boolean forward, boolean nextConflict) {
        int index;
        int i;
        int[] indices = new int[2];
        indices[1] = -1;
        indices[0] = -1;
        if (nodes[0] == null && nodes[1] == null) {
            return null;
        }
        if (!nextConflict || this.doNodesCorrespond(nodes)) {
            i = 0;
            while (i <= 1) {
                if (nodes[i] != null) {
                    indices[i] = this.getNumberOfConflictingNode(i, nodes[i], forward);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i <= 1) {
                if (nodes[i] != null) {
                    indices[i] = this.getNumberOfConflictingAncestorNode(i, nodes[i], forward);
                }
                ++i;
            }
        }
        if (this.noConflictDetected(indices[0]) && this.noConflictDetected(indices[1])) {
            return null;
        }
        if (this.noConflictDetected(indices[0])) {
            index = indices[1];
        } else if (this.noConflictDetected(indices[1])) {
            index = indices[0];
        } else if (nextConflict) {
            index = forward ? Math.max(indices[0], indices[1]) : Math.min(indices[0], indices[1]);
        } else {
            int n = index = forward ? Math.min(indices[0], indices[1]) : Math.max(indices[0], indices[1]);
        }
        if (nextConflict) {
            index = forward ? index + 1 : index - 1;
        }
        return this.getConflictingNode(index);
    }

    public MMMParallelIterator getParallelIterator(boolean forward, IMergeTreeNode[] startingNodes) {
        if (forward) {
            return new ParallelForwardIterator(startingNodes, (ChildGetter)new ChildForwardGetter());
        }
        return new ParallelBackwardIterator(startingNodes, (ChildGetter)new ChildBackwardGetter());
    }

    public void printAllConflicts(FileWriter writer) {
        int i = 0;
        while (i < this.conflictingNodes.size()) {
            try {
                writer.write(("<Conflict number=\"" + new Integer(i + 1).toString() + "\">").toCharArray());
                this.printSingleConflict((ConflictingNode)this.conflictingNodes.elementAt(i), writer);
                writer.write("</Conflict>");
            }
            catch (IOException e) {
                tracer.log(2, "IOException occured when printing file of all deltas", (Throwable)e);
            }
            ++i;
        }
    }

    private void printSingleConflict(ConflictingNode confNode, FileWriter writer) {
        try {
            writer.write(confNode.getText().toCharArray());
        }
        catch (IOException e) {
            tracer.log(2, "IOException occured when printing file of all deltas", (Throwable)e);
        }
    }

    public String getNumberOfAllConflictingNodes() {
        return new Integer(this.conflictingNodes.size()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

