/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractSelectionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.ApplyUnapplyListener;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import org.eclipse.jface.action.Action;

public class ActionContribution
extends AbstractSelectionContribution {
    private static final String PROCESS_DELTA = "process: ";
    private static final String APPLY_DELTA = "apply: ";
    private static final String UNAPPLY_DELTA = "revert: ";
    private IMergeTreeContentProvider localProvider;

    public ActionContribution(IGlobalTreeMergeManager manager) {
        super(manager.getLocalStorage());
        this.localProvider = manager.getTcpForUsage(0);
    }

    public Action getAction(IMergeTreeNode node, DeltaAnalyser da, ApplyUnapplyListener listener) {
        return new SingleMergeAction(da.getDeltas(), node, listener);
    }

    private class SingleMergeAction
    extends Action {
        private final IMergeDelta[] deltas;
        private final IMergeTreeNode currentNode;
        private ApplyUnapplyListener listener;
        private String preferredOperation;

        public SingleMergeAction(IMergeDelta[] deltas, IMergeTreeNode currentNode, ApplyUnapplyListener listener) {
            this(deltas, currentNode, listener, ActionContribution.PROCESS_DELTA);
        }

        public SingleMergeAction(IMergeDelta[] deltas, IMergeTreeNode currentNode, ApplyUnapplyListener listener, String preferredOperation) {
            this.deltas = deltas;
            this.currentNode = currentNode;
            this.listener = listener;
            this.preferredOperation = preferredOperation;
        }

        public String getText() {
            if (this.deltas != null && this.deltas.length > 0) {
                return this.deltas[0].getMenuText();
            }
            return null;
        }

        public void run() {
            if (this.currentNode.isSuitedForDeltaApplication()) {
                int i = 0;
                while (i < this.deltas.length) {
                    IMergeDelta mergeDelta = this.deltas[i];
                    if (!mergeDelta.isAttributeDelta()) {
                        IMergeTreeNode correspondingNode = mergeDelta.isPositiveDelta() ? this.currentNode : ActionContribution.this.getCorrespondingNodeInTCP(ActionContribution.this.localProvider, this.currentNode);
                        ActionContribution.this.possiblyAddLoadResetListener(mergeDelta, new ApplyUnapplyListener(this, correspondingNode){
                            private final /* synthetic */ IMergeTreeNode val$correspondingNode;
                            private final /* synthetic */ SingleMergeAction this$1;
                            {
                                this.this$1 = this$1;
                                this.val$correspondingNode = val$correspondingNode;
                            }

                            public void resetLoadStatus() {
                                this.val$correspondingNode.getDirectParent().resetChildren();
                            }
                        });
                    }
                    if (mergeDelta.isPositiveDelta()) {
                        ActionContribution.this.possiblyAddLoadResetListener(mergeDelta, new ApplyUnapplyListener(this){
                            private final /* synthetic */ SingleMergeAction this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void resetLoadStatus() {
                                IMergeTreeNode parent = (IMergeTreeNode)SingleMergeAction.access$100(this.this$1).getParent();
                                if (!parent.isSuitedForDeltaApplication()) {
                                    parent = (IMergeTreeNode)parent.getParent();
                                }
                                IMergeTreeNode corrNode = SingleMergeAction.access$200(this.this$1).getCorrespondingNodeInTCP(ActionContribution.access$000(SingleMergeAction.access$200(this.this$1)), parent);
                                corrNode.resetChildren();
                            }
                        });
                    }
                    ActionContribution.this.possiblyAddLoadResetListener(mergeDelta, this.listener);
                    if (this.preferredOperation.equals(ActionContribution.PROCESS_DELTA) || this.preferredOperation.equals(ActionContribution.APPLY_DELTA) && !mergeDelta.isApplied() || this.preferredOperation.equals(ActionContribution.UNAPPLY_DELTA) && mergeDelta.isApplied()) {
                        ActionContribution.this.processDelta(mergeDelta);
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ IMergeTreeNode access$100(SingleMergeAction x0) {
            return x0.currentNode;
        }

        static /* synthetic */ ActionContribution access$200(SingleMergeAction x0) {
            return x0.ActionContribution.this;
        }
    }
}

