/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;

public class AbstractSelectionContribution
extends AbstractContribution {
    public AbstractSelectionContribution(DifferenceStorage ds) {
        super(ds);
    }

    public IMergeTreeNode getCorrespondingNodeInTCP(IMergeTreeContentProvider tcp, IMergeTreeNode node) {
        if (node == null || tcp == null || node.getRootNode() == tcp.getOriginalRootNode()) {
            return node;
        }
        IUniqueTreeIdentification treeIdent = node.getUniqueTreeIdentification();
        IMergeDelta[] deltas = this.getAllDeltas();
        IUniqueTreeIdentification newTreeIdent = null;
        if (deltas != null) {
            int i = 0;
            while (i < deltas.length && newTreeIdent == null) {
                if (deltas[i].isExchangeDelta()) {
                    newTreeIdent = deltas[i].transformTreeIdentification(treeIdent);
                }
                ++i;
            }
        }
        if (newTreeIdent == null) {
            newTreeIdent = treeIdent;
        }
        return this.findCorrespondingNode(new IMergeTreeNode[]{tcp.getRootNode()}, newTreeIdent);
    }

    public IMergeTreeNode findCorrespondingNode(TreeViewerView view, IUniqueTreeIdentification uti) {
        if (uti == null) {
            return null;
        }
        IMergeTreeContentProvider tcp = view.getContentProvider();
        return this.findCorrespondingNode(new IMergeTreeNode[]{tcp.getRootNode()}, uti);
    }

    private IMergeTreeNode findCorrespondingNode(IMergeTreeNode[] nodes, IUniqueTreeIdentification treeIdent) {
        int i = 0;
        while (i < nodes.length) {
            if (treeIdent.equals(nodes[i].getUniqueTreeIdentification())) {
                return nodes[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes.length) {
            Object[] children = nodes[i2].getChildren();
            IMergeTreeNode[] mChildren = new IMergeTreeNode[children.length];
            int j = 0;
            while (j < children.length) {
                mChildren[j] = (IMergeTreeNode)children[j];
                ++j;
            }
            IMergeTreeNode subNode = this.findCorrespondingNode(mChildren, treeIdent);
            if (subNode != null) {
                return subNode;
            }
            ++i2;
        }
        return null;
    }
}

