/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.compare;

import com.sap.ide.metamodel.tools.merge.IMergeConflict;
import com.sap.ide.metamodel.tools.merge.editor.compare.ApplyUnapplyListener;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeDelta;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.interfaces.IUniqueTreeIdentification;

public abstract class AbstractContribution
implements IMergeConflict {
    protected DifferenceStorage differenceStorage;
    private DeltaAnalyser noDelta;

    public AbstractContribution(DifferenceStorage ds) {
        this.differenceStorage = ds;
        this.noDelta = new DeltaAnalyser(null, ds, null);
    }

    protected IMergeDelta[] getAllDeltas() {
        return this.differenceStorage.getAllDeltas();
    }

    protected void processDelta(IMergeDelta delta) {
        if (delta.isApplied()) {
            delta.revert();
        } else {
            delta.apply();
        }
        this.differenceStorage.rethinkDeltas();
        this.differenceStorage.resetForDelta(delta);
    }

    public void possiblyAddLoadResetListener(IMergeDelta delta, ApplyUnapplyListener listener) {
        if (this.differenceStorage != null) {
            this.differenceStorage.possiblyAddLoadResetListener(delta, listener);
        }
    }

    public IMergeDelta[] getDeltasForTreeIdent(IUniqueTreeIdentification treeIdent) {
        if (this.differenceStorage != null) {
            return this.differenceStorage.getDeltasForTreeIdent(treeIdent);
        }
        return null;
    }

    public boolean isDOExternal(IMergeTreeNode node) {
        if (this.differenceStorage == null) {
            return false;
        }
        IMergeInputObject input = this.differenceStorage.getInputObject(0);
        return !input.isSubObjectIncluded(node.getUserObject());
    }

    public DeltaAnalyser findCorrectDeltaVector(IMergeTreeNode node) {
        if (this.differenceStorage == null) {
            return this.noDelta;
        }
        DeltaAnalyser result = this.differenceStorage.getDeltaForNode(node);
        if (result != null) {
            return result;
        }
        if (node == null) {
            return this.noDelta;
        }
        IMergeDelta[] deltas = this.getDeltasForTreeIdent(node.getUniqueTreeIdentification());
        if (deltas == null) {
            return this.findCorrectDeltaVector((IMergeTreeNode)node.getParent()).clone(node);
        }
        return new DeltaAnalyser(deltas, this.differenceStorage, node);
    }

    protected void recompare() {
        this.differenceStorage.recompare();
    }
}

