/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.editor.MetamodelTreeEditorInput;
import com.sap.ide.metamodel.tools.merge.editor.actions.MergeAction;
import com.sap.ide.metamodel.tools.merge.editor.compare.ActionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.ApplyUnapplyListener;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.ToolItem;

public class TakeOverSingleAction
extends MergeAction
implements NodeSelectedListener {
    private ActionContribution actionContribution;
    private DeltaAnalyser deltaAnalyser;
    private IMergeTreeNode currentNode;

    public TakeOverSingleAction(ToolItem item, MetaModelTreeEditor editor) {
        super(item, editor);
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)this.currentEditor.getEditorInput();
        IGlobalTreeMergeManager treeManager = (IGlobalTreeMergeManager)input.getGlobalMergeManager();
        this.actionContribution = new ActionContribution(treeManager);
    }

    public void nodeSelected(IMergeTreeNode node) {
        boolean enabled = false;
        this.deltaAnalyser = this.actionContribution.findCorrectDeltaVector(node);
        if (this.deltaAnalyser.isOriginal() && !this.deltaAnalyser.isEmpty() && this.deltaAnalyser.isApplicable()) {
            enabled = true;
            this.currentNode = node;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IMergeTreeNode target = this.currentNode;
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)this.currentEditor.getEditorInput();
        final IMergeTreeNode t = target = input.getCorrespondingNodesManager().getCorrespondingNode(this.currentNode, 1);
        DeltaAnalyser da = this.actionContribution.findCorrectDeltaVector(this.currentNode);
        if (da.isOriginal()) {
            Action a = this.actionContribution.getAction(this.currentNode, da, new ApplyUnapplyListener(){

                public void resetLoadStatus() {
                    TakeOverSingleAction.this.currentEditor.recompare();
                    if (t != null) {
                        TakeOverSingleAction.this.currentEditor.getTreeViewer(1).setSelection((ISelection)new StructuredSelection((Object)t));
                    }
                }
            });
            a.run();
        }
    }
}

