/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.editor.CorrespondingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.editor.MetamodelTreeEditorInput;
import com.sap.ide.metamodel.tools.merge.editor.actions.MergeToggleAction;
import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.editor.refresh.AbstractRefreshHandler;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.ToolItem;

public class PresentationToggleAction
extends MergeToggleAction
implements NodeSelectedListener {
    private IMergeTreeNode selectedNode;
    private Vector[] oldExpandedElements = new Vector[3];
    private CorrespondingNodesManager correspondingNodesManager;
    private boolean threeWayMergePossible;

    public PresentationToggleAction(ToolItem item, MetaModelTreeEditor editor, String toolTipInitialState, String toolTipNonInitialState) {
        super(item, editor, false, toolTipInitialState, toolTipNonInitialState);
        TreeViewerView tv = this.currentEditor.getTreeViewer(0);
        IMergeTreeContentProvider tcp = tv.getContentProvider();
        if (tcp.isRootChanged()) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)this.currentEditor.getEditorInput();
        this.correspondingNodesManager = input.getCorrespondingNodesManager();
        this.threeWayMergePossible = input.getGlobalMergeManager().isThreeWayMergePossible();
    }

    protected AbstractRefreshHandler getRefreshHandler() {
        return new AbstractRefreshHandler(this.currentEditor){

            public void actionBeforeRefresh(int treeIndex) {
                IMergeTreeNode newRoot = !PresentationToggleAction.this.isChecked() ? PresentationToggleAction.this.correspondingNodesManager.getCorrespondingNode(PresentationToggleAction.this.selectedNode, treeIndex) : null;
                TreeViewerView tv = PresentationToggleAction.this.currentEditor.getTreeViewer(treeIndex);
                IMergeTreeContentProvider tcp = tv.getContentProvider();
                if (tcp != null) {
                    tcp.setNewRoot(newRoot);
                    PresentationToggleAction.this.setExpandedAncestorsOfRoot(tv, tcp.getRootNode(), treeIndex);
                }
            }

            public void actionAfterRefresh(Vector elementsToExpand, int treeIndex) {
                if (PresentationToggleAction.this.oldExpandedElements[treeIndex] != null) {
                    elementsToExpand.addAll(PresentationToggleAction.this.oldExpandedElements[treeIndex]);
                }
            }

            public void setSelection(ISelection oldSelection, int treeIndex) {
                PresentationToggleAction.this.currentEditor.getTreeViewer(treeIndex).setSelection(oldSelection);
            }
        };
    }

    private void setExpandedAncestorsOfRoot(TreeViewerView tv, IMergeTreeNode rootNode, int treeIndex) {
        if (rootNode.getParent() == null) {
            return;
        }
        Object[] temp = tv.getExpandedElements();
        this.oldExpandedElements[treeIndex] = new Vector();
        int i = 0;
        while (i < temp.length) {
            IMergeTreeNode origNode;
            IMergeTreeNode node = origNode = (IMergeTreeNode)temp[i];
            while (node != null && node != rootNode) {
                node = (IMergeTreeNode)node.getParent();
            }
            if (node == null) {
                this.oldExpandedElements[treeIndex].add(origNode);
            }
            ++i;
        }
    }

    public void nodeSelected(IMergeTreeNode node) {
        boolean enabled;
        TreeViewerView tv = this.currentEditor.getTreeViewer(0);
        IMergeTreeContentProvider tcp = tv.getContentProvider();
        if (tcp.isRootChanged()) {
            enabled = true;
        } else {
            enabled = false;
            this.selectedNode = node;
            if (node.mayBeSetAsNewRoot()) {
                enabled = true;
                IMergeTreeNode[] corrNodes = this.correspondingNodesManager.getAllCorrespondingNodes(this.selectedNode);
                int i = 0;
                while (i < corrNodes.length) {
                    if (corrNodes[i] == null && (i < 2 || i == 2 && this.threeWayMergePossible)) {
                        enabled = false;
                    }
                    ++i;
                }
            }
            if (enabled) {
                DifferenceStorage localStorage = this.correspondingNodesManager.getGlobalMergeManager().getLocalStorage();
                AbstractContribution ac = new AbstractContribution(localStorage){};
                enabled = ac.findCorrectDeltaVector(node).mayBeSetAsRoot();
            }
        }
        this.setEnabled(enabled);
    }
}

