/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.editor.actions.MergeAction;
import com.sap.ide.metamodel.tools.merge.editor.refresh.AbstractRefreshHandler;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import org.eclipse.swt.widgets.ToolItem;

public abstract class MergeToggleAction
extends MergeAction {
    private boolean isChecked;
    private String toolTipInitialState;
    private String toolTipNonInitialState;
    private boolean initialState;

    public MergeToggleAction(ToolItem item, MetaModelTreeEditor editor, boolean initialState, String toolTipInitialState, String toolTipNonInitialState) {
        super(item, editor);
        this.initialState = initialState;
        this.toolTipInitialState = toolTipInitialState;
        this.toolTipNonInitialState = toolTipNonInitialState;
        this.setChecked(initialState);
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
        if (this.item.getSelection() != this.isChecked) {
            this.item.setSelection(checked);
        }
        if (this.isChecked == this.initialState) {
            this.item.setToolTipText(this.toolTipInitialState);
        } else {
            this.item.setToolTipText(this.toolTipNonInitialState);
        }
    }

    protected void toggleChecked() {
        this.setChecked(!this.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    protected abstract AbstractRefreshHandler getRefreshHandler();

    public void run() {
        boolean b = ((IMergeEditorInput)this.currentEditor.getEditorInput()).getMergeConfiguration().isAncestorExisting();
        int upperLimit = b ? 2 : 1;
        AbstractRefreshHandler handler = this.getRefreshHandler();
        int i = 0;
        while (i <= upperLimit) {
            handler.refresh(i);
            ++i;
        }
        this.toggleChecked();
    }
}

