/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.editor.actions.MergeToggleAction;
import com.sap.ide.metamodel.tools.merge.editor.refresh.AbstractRefreshHandler;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.sap.ide.metamodel.tools.merge.tree.node.hider.DefaultNodeHider;
import com.sap.ide.metamodel.tools.merge.tree.node.hider.NoRelationHider;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.ToolItem;

public class EdgeToggleAction
extends MergeToggleAction {
    public EdgeToggleAction(ToolItem item, MetaModelTreeEditor editor, String toolTipInitialState, String toolTipNonInitialState) {
        super(item, editor, true, toolTipInitialState, toolTipNonInitialState);
    }

    protected AbstractRefreshHandler getRefreshHandler() {
        return new AbstractRefreshHandler(this.currentEditor, false){

            public void actionBeforeRefresh(int treeIndex) {
                TreeViewerView tv = EdgeToggleAction.this.currentEditor.getTreeViewer(treeIndex);
                IMergeTreeContentProvider tcp = tv.getContentProvider();
                if (tcp != null) {
                    if (!EdgeToggleAction.this.isChecked()) {
                        tcp.setNodeHider(new DefaultNodeHider());
                    } else {
                        tcp.setNodeHider(new NoRelationHider());
                    }
                }
            }

            public void actionAfterRefresh(Vector elementsToExpand, int treeIndex) {
            }

            public void setSelection(ISelection oldSelection, int treeIndex) {
                TreeViewerView tv = EdgeToggleAction.this.currentEditor.getTreeViewer(treeIndex);
                IMergeTreeContentProvider tcp = tv.getContentProvider();
                if (tcp != null && oldSelection instanceof StructuredSelection) {
                    StructuredSelection sel = (StructuredSelection)oldSelection;
                    if (!tcp.getNodeHider().isForbidden((IMergeTreeNode)sel.getFirstElement())) {
                        tv.setSelection((ISelection)sel);
                    }
                }
            }
        };
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setEnabled(true);
    }
}

