/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.dialog.MetamodelMergeDialog;
import com.sap.ide.metamodel.tools.merge.editor.actions.BaseCompareAction;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import com.sap.ide.metamodel.tools.merge.semantic.metamodel.DataSourceManagerMetaModel;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DiffTwoProjects
extends BaseCompareAction
implements IObjectActionDelegate {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffTwoProjects == null ? (class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffTwoProjects = DiffTwoProjects.class$("com.sap.ide.metamodel.tools.merge.editor.actions.DiffTwoProjects")) : class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffTwoProjects));
    private IProject[] projects;
    static /* synthetic */ Class class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffTwoProjects;

    private void setSelectedProjects(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            this.projects = new IProject[2];
            int counter = 0;
            Iterator iterator = sel.iterator();
            if (sel.size() == 2) {
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof IProject) || counter >= 2) continue;
                    this.projects[counter++] = (IProject)next;
                }
            }
        }
    }

    protected boolean isEnabled(ISelection selection) {
        this.setSelectedProjects(selection);
        return this.isProjectSuited(this.projects[0]) && this.isProjectSuited(this.projects[1]);
    }

    private boolean isProjectSuited(IProject project) {
        if (project == null) {
            return false;
        }
        boolean nature = false;
        try {
            nature = project.hasNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
        }
        catch (CoreException e) {
            tracer.log(2, "Access to project nature of project " + project.getName() + " failed", (Throwable)e);
            nature = false;
        }
        return nature;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        boolean bl = false;
    }

    protected Shell getShell() {
        return WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected int runInternalMerge(IMergeEditorInput input) {
        MetamodelMergeDialog dialog = new MetamodelMergeDialog(this.getShell(), input);
        return dialog.open();
    }

    protected void run(ISelection selection) {
        String valid;
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell());
        if (dialog.open() == 1) {
            return;
        }
        if (dialog.getSelectionIndex() == 1) {
            this.projects = new IProject[]{this.projects[1], this.projects[0]};
        }
        DataSourceManagerMetaModel manager = new DataSourceManagerMetaModel(this.projects);
        IMergeEditorInput input = manager.getMetamodelEditorInput();
        input.getMergeConfiguration().setEditable(false);
        if (input.getMergeConfiguration().isEditable() && (valid = input.isValid()) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Input Objects invalid for Merge", (String)valid);
            return;
        }
        input.getMergeConfiguration().setDiffingForNW04(true);
        IGlobalTreeMergeManager gmm = (IGlobalTreeMergeManager)input.getGlobalMergeManager();
        gmm.setTreeHeaderTexts(new String[]{"Project: " + this.projects[0].getName(), "Project: " + this.projects[1].getName(), ""});
        gmm.setPropertyHeaderTexts(new String[]{"Value in " + this.projects[0].getName(), "Value in " + this.projects[1].getName(), ""});
        this.runInternalMerge(input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProjectSelectionDialog
    extends Dialog {
        Button r1;
        Button r2;
        private boolean select;

        protected ProjectSelectionDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            IGridLayoutPane gp = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
            gp.addTextLabel("Select source project of comparison");
            gp.addPlaceholder();
            this.r1 = gp.addRadioButton(DiffTwoProjects.this.projects[0].getName());
            this.r2 = gp.addRadioButton(DiffTwoProjects.this.projects[1].getName());
            return gp.getComposite();
        }

        protected void okPressed() {
            this.select = this.r1.getSelection();
            super.okPressed();
        }

        public int getSelectionIndex() {
            return this.select ? 0 : 1;
        }
    }
}

