/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor.actions;

import com.sap.ide.metamodel.tools.merge.dialog.MetamodelMergeDialog;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import com.sap.ide.metamodel.tools.merge.semantic.mdo.DataSourceManagerMDO;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.automerge.ICollisionListener;
import com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DiffMergeSingleSelectionAction
extends AbstractDiffMergeAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffMergeSingleSelectionAction == null ? (class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffMergeSingleSelectionAction = DiffMergeSingleSelectionAction.class$("com.sap.ide.metamodel.tools.merge.editor.actions.DiffMergeSingleSelectionAction")) : class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffMergeSingleSelectionAction));
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Conflict resolution";
    private static final String DEFAULT_DIALOG_MESSAGE_CHECKIN = "Do you want to resolve the conflict by accepting your (local) file ?";
    private static final String DEFAULT_DIALOG_MESSAGE_INTEGRATE = "Do you want to resolve the conflict by accepting the merged version ?";
    private static final String ERROR_DIALOG_MESSAGE = "Error occured during conflict resolution : ";
    static /* synthetic */ Class class$com$sap$ide$metamodel$tools$merge$editor$actions$DiffMergeSingleSelectionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    public boolean isEnabled(IStructuredSelection selection) {
        String actionName = this.getConfigProperty("ActionName", null);
        if (actionName.equalsIgnoreCase("MergeIntegrateCollision") && selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selection.getFirstElement();
            DataSourceManagerMDO manager = new DataSourceManagerMDO(selectedCollision, true);
            return manager.isProjectSuited() && manager.isFileSuited();
        }
        if (actionName.equalsIgnoreCase("ViewConflictDifference")) {
            return false;
        }
        if (actionName.equalsIgnoreCase("MergeCheckinCollision")) {
            IVfsCheckinCollision checkInCollision = this.getCheckinCollision(selection);
            DataSourceManagerMDO manager = new DataSourceManagerMDO(checkInCollision, true);
            return manager.isProjectSuited() && manager.isFileSuited();
        }
        if (actionName.equalsIgnoreCase("Diff") || actionName.equalsIgnoreCase("Merge")) {
            // empty if block
        }
        return false;
    }

    protected void execute(final IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        this.setProgressMonitor(workerThreadMonitor);
        final String actionName = this.getConfigProperty("ActionName", null);
        if (actionName.equalsIgnoreCase("MergeCheckinCollision")) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiffMergeSingleSelectionAction.this.mergeCheckinCollision(DiffMergeSingleSelectionAction.super.getCheckinCollision(selection), null);
                }
            });
            return;
        }
        if (actionName.equalsIgnoreCase("MergeIntegrateCollision") && selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            final boolean[] revertMergeversion = new boolean[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IVfsIntegrateCollision col = (IVfsIntegrateCollision)selection.getFirstElement();
                    revertMergeversion[0] = col.getMergeVersion() == null;
                }
            });
            this.resolveIntegrateCollision((IVfsIntegrateCollision)selection.getFirstElement(), revertMergeversion[0], null);
        }
        if (actionName.equalsIgnoreCase("ViewConflictDifference") && selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiffMergeSingleSelectionAction.this.viewConflictDifference((IVfsIntegrateCollision)selection.getFirstElement());
                }
            });
            return;
        }
        if (selection.getFirstElement() instanceof IVfsVersion) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (!((IVfsVersion)selection.getFirstElement()).isFile()) {
                            return;
                        }
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        return;
                    }
                    if (actionName.equalsIgnoreCase("Diff")) {
                        DiffMergeSingleSelectionAction.this.diffWithOrignalVersion((IVfsVersion)selection.getFirstElement());
                    }
                }
            });
            return;
        }
        if (selection.getFirstElement() instanceof IVfsFile || selection.getFirstElement() instanceof IFile) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiffMergeSingleSelectionAction.this.diffMergeFile(selection);
                }
            });
            return;
        }
    }

    private void diffWithOrignalVersion(IVfsVersion version) {
        block14: {
            try {
                File localFile;
                boolean workspaceFileFound = false;
                IVfsVersion originalVersion = null;
                IVfsVersionRelation[] predecessorRelations = version.getPredecessorRelationSet();
                if (predecessorRelations.length > 0) {
                    int i = 0;
                    while (i < predecessorRelations.length) {
                        if (predecessorRelations[i].getRelationType() == VfsVersionRelationType.BRANCH || predecessorRelations[i].getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                            originalVersion = version.getVersionHistory().getVersion(predecessorRelations[i].getSourceVersionId());
                            break;
                        }
                        ++i;
                    }
                }
                if (originalVersion == null) {
                    originalVersion = version;
                }
                if (originalVersion == null) break block14;
                String workspacePath = version.getCreatorWorkspaceName();
                IVfsContext context = version.getVersionedFileSystemManager().getCurrentContext();
                try {
                    if (version.isOpen()) {
                        IVfsFile vfsFile = version.getRepresentingFile(workspacePath, context);
                        if (vfsFile != null && vfsFile.getLocalFile().exists()) {
                            workspaceFileFound = true;
                            localFile = new File(vfsFile.getLocalFile().getAbsolutePath());
                        } else {
                            localFile = ExternalAction.createTmpFile((IVfsVersion)version, (String)("Version_" + version.getBranchSequenceNumber() + "_"));
                        }
                    } else {
                        localFile = ExternalAction.createTmpFile((IVfsVersion)version, (String)("Version_" + version.getBranchSequenceNumber() + "_"));
                    }
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    localFile = ExternalAction.createTmpFile((IVfsVersion)version, (String)("Version_" + version.getBranchSequenceNumber() + "_"));
                }
                boolean useExternalTool = this.myPreferenceManager.isUseExternalDiff();
                if (useExternalTool) {
                    final IVfsProgressMonitor monitor = this.getProgressMonitor();
                    final IVfsVersion origVersion = originalVersion;
                    final File locFile = localFile;
                    Thread actionThread = new Thread(){

                        public void run() {
                            monitor.onStart();
                            File leftFile = ExternalAction.createTmpFile((IVfsVersion)origVersion, (String)("Version_" + origVersion.getBranchSequenceNumber() + "_"));
                            DiffMergeSingleSelectionAction.super.runExternalDiff(leftFile, locFile, true);
                            monitor.onFinish(null);
                        }
                    };
                    actionThread.start();
                    return;
                }
                String leftVersionTitle = workspaceFileFound ? localFile.getAbsolutePath() : version.getLocationInGraph(version.getCreatorWorkspaceName());
                String rightVersionTitle = originalVersion.getLocationInGraph(originalVersion.getCreatorWorkspaceName());
                DiffEditorInput input = new DiffEditorInput(localFile, new IVfsVersion[]{originalVersion}, null, false);
                input.setTitle("/" + version.getWorkspaceRelativePath());
                input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
                input.getCompareConfiguration().setLeftEditable(this.isVersionOpenByCurrentUser(version));
                input.getCompareConfiguration().setRightLabel(rightVersionTitle);
                input.getCompareConfiguration().setRightEditable(this.isVersionOpenByCurrentUser(originalVersion));
                if (input.getCompareConfiguration().isLeftEditable()) {
                    input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                }
                this.runInternalDiff(input);
            }
            catch (Exception e) {
                this.showErrorMessage("Problem occurred during diff command: " + e.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    public void resolveIntegrateCollision(IVfsIntegrateCollision collision, boolean discardAfterCancel, ICollisionListener listener) {
        String valid;
        boolean resolved = false;
        IMergeEditorInput input = new DataSourceManagerMDO(collision, false).getMetamodelEditorInput();
        input.getMergeConfiguration().setEditable(false);
        if (input.getMergeConfiguration().isEditable() && (valid = input.isValid()) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Input Objects invalid for Merge", (String)valid);
            return;
        }
        IVfsVersion localVersion = null;
        String text1 = null;
        String text11 = null;
        if (input.getMergeConfiguration().isEditable()) {
            IVfsMergeVersion mergeVersion = collision.getMergeVersion();
            if (mergeVersion == null) {
                try {
                    mergeVersion = IntegrateCollisionUtil.getMergedVersion((IVfsIntegrateCollision)collision, (Shell)this.getShell());
                }
                catch (VfsException e) {
                    this.showErrorMessage("Creating merge version failed: " + e.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    return;
                }
            }
            if (mergeVersion == null) {
                return;
            }
            text1 = "Merge Version : " + mergeVersion.getLocationInGraph(mergeVersion.getCreatorWorkspaceName());
            text11 = "Merge Version Value";
            localVersion = mergeVersion;
        } else {
            localVersion = collision.getActiveVersion();
            text1 = "Active Version : " + localVersion.getLocationInGraph(localVersion.getCreatorWorkspaceName());
            text11 = "Active Version Value";
        }
        IVfsVersion commonAncestor = collision.getCommonAncestor();
        String text2 = "Conflicting Version : " + collision.getCollidingVersionDescription();
        String text3 = "Common Ancestor : " + commonAncestor.getLocationInGraph(commonAncestor.getCreatorWorkspaceName());
        IGlobalTreeMergeManager manager = (IGlobalTreeMergeManager)input.getGlobalMergeManager();
        manager.setTreeHeaderTexts(new String[]{text1, text2, text3});
        manager.setPropertyHeaderTexts(new String[]{text11, "Conflicting Version Value", "Ancestor Version Value"});
        if (this.runInternalMerge(input) == 0) {
            resolved = this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
        }
    }

    private boolean checkEnabled(IVfsFile file) {
        if (file.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT || file.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_MOVE) {
            String name = this.getConfigProperty("ActionName", "Diff");
            if (name.equalsIgnoreCase("Merge")) {
                return file.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER;
            }
            return true;
        }
        return false;
    }

    private void diffMergeFile(IStructuredSelection selection) {
        File localFile = null;
        IVfsVersion[] versions = new IVfsVersion[]{};
        Object selectedItem = selection.getFirstElement();
        boolean useExternalTools = this.myPreferenceManager.isUseExternalDiff();
        boolean doDiff = false;
        boolean doMerge = false;
        String name = this.getConfigProperty("ActionName", "Diff");
        if (name.equalsIgnoreCase("Diff")) {
            doDiff = true;
        } else if (name.equalsIgnoreCase("Merge")) {
            doMerge = true;
        }
        IVfsFile vfsFile = null;
        if (selectedItem instanceof IVfsFile) {
            vfsFile = (IVfsFile)selectedItem;
        } else if (selectedItem instanceof IFile) {
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)((IFile)selectedItem));
            vfsFile = teamProvider.getFolderItem((IResource)((IFile)selectedItem)).asFile();
        } else {
            return;
        }
        IVfsVersion ancestor = null;
        IVfsVersionRelation[] predRelation = vfsFile.getSyncedVersion().getPredecessorRelationSet();
        int i = 0;
        while (i < predRelation.length) {
            if (predRelation[i].getRelationType() == VfsVersionRelationType.BRANCH || predRelation[i].getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                ancestor = vfsFile.getSyncedVersion().getVersionHistory().getVersion(predRelation[i].getSourceVersionId());
            }
            ++i;
        }
        if (useExternalTools) {
            File ancestorFile = null;
            File activeFile = null;
            File collidingFile = null;
            File mergedFile = null;
            try {
                ancestorFile = ancestor != null ? ExternalAction.createTmpFile((IVfsVersion)ancestor, (String)"ancestor_") : ExternalAction.createTmpFile((IVfsVersion)vfsFile.getSyncedVersion(), (String)"ancestor_");
                activeFile = doDiff ? ExternalAction.createTmpFile((IVfsVersion)vfsFile.refreshAndGetVersion(), (String)("Version_" + vfsFile.refreshAndGetVersion().getBranchSequenceNumber() + "_")) : ExternalAction.createTmpFile((IVfsVersion)vfsFile.refreshAndGetVersion(), (String)("Version_" + vfsFile.refreshAndGetVersion().getBranchSequenceNumber() + "_"));
                collidingFile = doDiff ? ExternalAction.createTmpFile((IVfsFile)vfsFile, (String)"file2_") : ExternalAction.createTmpFile((IVfsFile)vfsFile, (String)"conflicting_");
                mergedFile = new File(vfsFile.getLocalFile().getAbsolutePath());
            }
            catch (VfsException e) {
                this.showErrorMessage("Retreiving version for " + vfsFile + " failed: " + e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            final File actFile = activeFile;
            final IVfsFile vfsFil = vfsFile;
            final File ancFile = ancestorFile;
            final File mergFile = mergedFile;
            final File colFile = collidingFile;
            final boolean diff = doDiff;
            final boolean merge = doMerge;
            Thread actionThread = new Thread(){

                public void run() {
                    monitor.onStart();
                    if (diff) {
                        DiffMergeSingleSelectionAction.super.runExternalDiff(actFile, new File(vfsFil.getLocalFile().getAbsolutePath()), true);
                    } else if (merge) {
                        DiffMergeSingleSelectionAction.super.runExternalMerge(null, ancFile, actFile, mergFile, colFile, true);
                    }
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        localFile = new File(vfsFile.getLocalFile().getAbsolutePath());
        if (this.isVersionTreeVisible()) {
            versions = this.getVersions(vfsFile);
        } else {
            try {
                versions = doMerge ? new IVfsVersion[]{vfsFile.getCheckinCollision().getValidSourceVersion()} : new IVfsVersion[]{vfsFile.refreshAndGetVersion()};
            }
            catch (VfsException x) {
                this.showErrorMessage("Retreiving version failed: " + x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        if (localFile == null || !localFile.exists() || localFile.isDirectory() || versions.length == 0) {
            this.showErrorMessage("Unable to perform comparison - local file does not exist or remote file version history is empty.");
            return;
        }
        DiffEditorInput input = new DiffEditorInput(localFile, versions, null, this.isEditable());
        IVfsVersionHistory versionHistory = vfsFile.refreshAndGetVersionHistory();
        if (versionHistory == null) {
            this.showErrorMessage("Unable to perform comparison - could not retrieve version history");
            return;
        }
        IVfsWorkspace workspace = vfsFile.getWorkspace();
        IVfsVersion versionOnClient = versionHistory.getVersionInClientWorkspace(workspace);
        input.getCompareConfiguration().setLeftLabel("Workspace (Local) " + versionOnClient.getLocationInGraph(versionOnClient.getCreatorWorkspaceName()));
        input.getCompareConfiguration().setLeftEditable(true);
        input.getCompareConfiguration().setRightLabel("Repository (Remote) " + versions[0].getLocationInGraph(versions[0].getCreatorWorkspaceName()));
        input.getCompareConfiguration().setRightEditable(false);
        input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        try {
            input.setTitle("/" + vfsFile.getWorkspaceRelativePath() + " - " + "  ( Changes between: 'local file' & 'active version in Workspace: " + vfsFile.getActiveVersion().getCreatorWorkspaceName() + "' )");
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        this.runInternalDiff(input);
    }

    public void mergeCheckinCollision(IVfsCheckinCollision collision, ICollisionListener listener) {
        String valid;
        boolean resolved = false;
        IVfsFile mergeVfsFile = collision.getFolderItemForCollidingVersion().asFile();
        IMergeEditorInput input = new DataSourceManagerMDO(collision, false).getMetamodelEditorInput();
        input.getMergeConfiguration().setEditable(false);
        if (input.getMergeConfiguration().isEditable() && (valid = input.isValid()) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Input Objects invalid for Merge", (String)valid);
            return;
        }
        IVfsVersionHistory versionHistory = mergeVfsFile.refreshAndGetVersionHistory();
        if (versionHistory == null) {
            this.showErrorMessage("Unable to perform merge - could not retrieve version history");
            return;
        }
        IVfsVersion activeVersion = collision.getValidSourceVersion();
        IVfsVersion commonAncestor = collision.getCommonAncestor();
        IVfsWorkspace workspace = mergeVfsFile.getWorkspace();
        IVfsVersion versionOnClient = versionHistory.getVersionInClientWorkspace(workspace);
        String text1 = "Your (local) " + versionOnClient.getLocationInGraph(versionOnClient.getCreatorWorkspaceName());
        String text2 = "Active (Remote) " + activeVersion.getLocationInGraph(activeVersion.getCreatorWorkspaceName());
        String text3 = "Common Ancestor : " + commonAncestor.getLocationInGraph(commonAncestor.getCreatorWorkspaceName());
        IGlobalTreeMergeManager manager = (IGlobalTreeMergeManager)input.getGlobalMergeManager();
        manager.setTreeHeaderTexts(new String[]{text1, text2, text3});
        manager.setPropertyHeaderTexts(new String[]{"Local Version Value", "Active Version Value", "Ancestor version Value"});
        if (this.runInternalMerge(input) == 0) {
            resolved = this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
        }
        try {
            IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(mergeVfsFile.getLocalPath()));
            if (res != null) {
                res.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        if (resolved && listener != null) {
            listener.collisionResolved((IVfsCollision)collision);
        }
    }

    protected int runInternalMerge(IMergeEditorInput input) {
        MetamodelMergeDialog dialog = new MetamodelMergeDialog(this.getShell(), input);
        return dialog.open();
    }

    private boolean queryUserAndAcceptCollidingVersion(final IVfsCollision collision) {
        boolean accepted = false;
        String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
        String dialogMessage = null;
        dialogMessage = collision instanceof IVfsCheckinCollision ? this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE_CHECKIN) : this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE_INTEGRATE);
        final MessageDialog message = new MessageDialog(this.getShell(), dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        message.setBlockOnOpen(true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                message.open();
            }
        });
        int userResponse = message.getReturnCode();
        if (userResponse == 0) {
            if (collision instanceof IVfsCheckinCollision) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            ((IVfsCheckinCollision)collision).acceptCollidingVersion();
                        }
                        catch (VfsException e) {
                            DiffMergeSingleSelectionAction.super.showErrorMessage(DiffMergeSingleSelectionAction.ERROR_DIALOG_MESSAGE + e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                });
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.super.showMessage("Your (local) version accepted. Conflict resolved successully.", 1);
                    }
                });
            } else {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            ((IVfsIntegrateCollision)collision).markAsResolved();
                        }
                        catch (VfsException e) {
                            DiffMergeSingleSelectionAction.super.showErrorMessage(DiffMergeSingleSelectionAction.ERROR_DIALOG_MESSAGE + e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                });
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.super.showMessage("Conflict has been marked as resolved. To resolve it fully, check-in the activity containing the merge version.", 1);
                    }
                });
            }
            accepted = true;
        }
        return accepted;
    }

    private void viewConflictDifference(IVfsIntegrateCollision collision) {
        boolean useExternalTool = this.myPreferenceManager.isUseExternalDiff();
        final IVfsVersion activeVersion = collision.getActiveVersion();
        IVfsVersion collidingVersion = collision.getCollidingVersion();
        final File collidingFile = ExternalAction.createTmpFile((IVfsVersion)collidingVersion, (String)("Conflicting_Version_" + collidingVersion.getBranchSequenceNumber() + "_"));
        if (useExternalTool) {
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    File activeFile = ExternalAction.createTmpFile((IVfsVersion)activeVersion, (String)("Active_Version_" + activeVersion.getBranchSequenceNumber() + "_"));
                    monitor.onStart();
                    DiffMergeSingleSelectionAction.super.runExternalDiff(collidingFile, activeFile, true);
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        String leftVersionTitle = "( Conflicting ) version " + String.valueOf(collidingVersion.getBranchSequenceNumber()) + "  in Workspace : " + collidingVersion.getCreatorWorkspaceName();
        String rightVersionTitle = "( Active ) version " + String.valueOf(activeVersion.getBranchSequenceNumber()) + " in Workspace : " + activeVersion.getCreatorWorkspaceName();
        DiffEditorInput input = new DiffEditorInput(collidingFile, new IVfsVersion[]{activeVersion}, null, false);
        input.setTitle("/" + activeVersion.getWorkspaceRelativePath() + " - " + "  ( Changes between: 'Version " + collidingVersion.getBranchSequenceNumber() + " in Workspace: " + collidingVersion.getCreatorWorkspaceName() + "' & 'Version " + activeVersion.getBranchSequenceNumber() + " in Workspace: " + activeVersion.getCreatorWorkspaceName() + "' )");
        input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
        input.getCompareConfiguration().setLeftEditable(false);
        input.getCompareConfiguration().setRightLabel(rightVersionTitle);
        input.getCompareConfiguration().setRightEditable(false);
        if (input.getCompareConfiguration().isLeftEditable()) {
            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        }
        this.runInternalDiff(input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

