/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor;

import com.sap.ide.metamodel.tools.merge.IMergeConflict;
import com.sap.ide.metamodel.tools.merge.editor.ConflictingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.CorrespondingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.MetamodelTreeEditorInput;
import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.ActionContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.ApplyUnapplyListener;
import com.sap.ide.metamodel.tools.merge.editor.compare.DeltaAnalyser;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeContentProvider;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.table.PropertyArea;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import com.sap.ide.metamodel.tools.merge.tree.TreeConflictComposite;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;

public class MetaModelTreeEditor
extends EditorPart
implements IMergeConflict {
    private IGridLayoutPane groundPane;
    private PropertyArea propertyArea;
    private TreeConflictComposite tcc;

    public MetaModelTreeEditor(String title) {
    }

    public void doSave(IProgressMonitor monitor) {
        IMergeEditorInput input = (IMergeEditorInput)this.getEditorInput();
        if (input.getMergeConfiguration().isEditable()) {
            input.getMainMergeObject(0).save();
        }
    }

    public void doRollBack(IProgressMonitor monitor) {
        IMergeEditorInput input = (IMergeEditorInput)this.getEditorInput();
        if (input.getMergeConfiguration().isEditable()) {
            input.getMainMergeObject(0).rollback();
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public TreeViewerView getTreeViewer(int usage) {
        return this.tcc.getTreeViewer(usage);
    }

    public void setTwoWayMerge(boolean twoWayMerge) {
        this.propertyArea.setTwoWayMerge(twoWayMerge);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)super.getEditorInput();
        this.groundPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        this.groundPane.setMargin(0, 0);
        ISashPane sashPane = this.groundPane.addVerticalSashPane(this.groundPane.createGridLayoutData(4, 4, true, true));
        ISimplePane sp = sashPane.addSimplePane();
        this.tcc = new TreeConflictComposite(sp.getComposite(), input.getConflictingNodesManager());
        IGridLayoutPane lowerPane = sashPane.addGridLayoutPane(1);
        DifferenceStorage[] storages = input.getGlobalMergeManager().getStoragesToAncestor();
        this.propertyArea = new PropertyArea(new AbstractContribution[]{new AbstractContribution(storages[0]){}, new AbstractContribution(storages[1]){}}, new String[]{input.getGlobalMergeManager().getPropertyHeaderText(0), input.getGlobalMergeManager().getPropertyHeaderText(1), input.getGlobalMergeManager().getPropertyHeaderText(2)}, input.getMergeConfiguration().isDiffingForNW04());
        this.decorateControls();
        this.propertyArea.createControl(lowerPane.getComposite());
        this.setTwoWayMerge(!input.getGlobalMergeManager().isThreeWayMergePossible());
        int i = 0;
        while (i <= 2) {
            this.getTreeViewer(i).addSelectionChangedListener(new NodeSelectedListener(){

                public void nodeSelected(IMergeTreeNode node) {
                    if (node != null && node.isSuitedForPropertyDisplay()) {
                        MetaModelTreeEditor.this.refreshPropertyArea(node);
                    }
                }
            });
            ++i;
        }
        sashPane.setWeights(new int[]{5, 2});
    }

    public void refreshPropertyArea(IMergeTreeNode node) {
        if (node == null) {
            return;
        }
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)super.getEditorInput();
        IMergeTreeNode[] correspondingNodes = input.getCorrespondingNodesManager().getAllCorrespondingNodes(node);
        this.propertyArea.setInput(input.getGlobalMergeManager().getAllPropertyRows(correspondingNodes));
        this.propertyArea.refresh();
    }

    public Control getControl() {
        return this.groundPane.getComposite();
    }

    public void decorateControls() {
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)this.getEditorInput();
        IGlobalTreeMergeManager manager = (IGlobalTreeMergeManager)input.getGlobalMergeManager();
        this.tcc.setDifferenceStorage(manager);
        this.rebuildConflictNodes();
        ActionContribution ac = new ActionContribution(manager);
        if (input.getMergeConfiguration().isEditable()) {
            this.addContextMenu(ac);
        }
        IMergeTreeContentProvider provider = manager.getTcpForUsage(0);
        IMergeTreeNode[] correspondingNodes = input.getCorrespondingNodesManager().getAllCorrespondingNodes(provider.getRootNode());
        this.propertyArea.setInput(input.getGlobalMergeManager().getAllPropertyRows(correspondingNodes));
    }

    public void recompare() {
        this.tcc.recompare();
        this.rebuildConflictNodes();
    }

    private void rebuildConflictNodes() {
        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)this.getEditorInput();
        ConflictingNodesManager manager = input.getConflictingNodesManager();
        manager.rebuildConflictNodes(new TreeViewerView[]{this.tcc.getTreeViewer(0), this.tcc.getTreeViewer(1)});
    }

    private void addContextMenu(final ActionContribution actionContribution) {
        int i = 0;
        while (i <= 1) {
            final int j = i;
            this.getTreeViewer(i).addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    IStructuredSelection strSel = (IStructuredSelection)MetaModelTreeEditor.this.getTreeViewer(j).getSelection();
                    IMergeTreeNode currentNode = (IMergeTreeNode)strSel.getFirstElement();
                    if (currentNode.isSuitedForDeltaApplication() && actionContribution != null) {
                        IMergeTreeNode target = currentNode;
                        MetamodelTreeEditorInput input = (MetamodelTreeEditorInput)MetaModelTreeEditor.this.getEditorInput();
                        CorrespondingNodesManager corrManager = input.getCorrespondingNodesManager();
                        IMergeTreeNode t = target = corrManager.getCorrespondingNode(currentNode, 1);
                        DeltaAnalyser da = actionContribution.findCorrectDeltaVector(currentNode);
                        if (da.isOriginal()) {
                            manager.add((IAction)actionContribution.getAction(currentNode, da, new ApplyUnapplyListener(this, t){
                                private final /* synthetic */ IMergeTreeNode val$t;
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$t = val$t;
                                }

                                public void resetLoadStatus() {
                                    4.access$000(this.this$1).recompare();
                                    if (this.val$t != null) {
                                        4.access$000(this.this$1).getTreeViewer(1).setSelection((ISelection)new StructuredSelection((Object)this.val$t));
                                    }
                                    4.access$000(this.this$1).refreshPropertyArea(this.val$t);
                                }
                            }));
                        }
                    }
                }

                static /* synthetic */ MetaModelTreeEditor access$000(4 x0) {
                    return x0.MetaModelTreeEditor.this;
                }
            });
            ++i;
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    public void setDialogClosed() {
        this.tcc.setDialogClosed();
    }
}

