/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor;

import com.sap.ide.metamodel.tools.merge.editor.compare.AbstractSelectionContribution;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IGlobalTreeMergeManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;

public class CorrespondingNodesManager {
    private IGlobalTreeMergeManager globalMergeManager;
    private AbstractSelectionContribution[] contributions = new AbstractSelectionContribution[4];

    public CorrespondingNodesManager(IGlobalTreeMergeManager globalMergeManager) {
        this.globalMergeManager = globalMergeManager;
        this.contributions[1] = new AbstractSelectionContribution(globalMergeManager.getLocalStorage());
        if (globalMergeManager.getStoragesToAncestor()[0] != null) {
            this.contributions[2] = new AbstractSelectionContribution(globalMergeManager.getStoragesToAncestor()[0]);
        }
        if (globalMergeManager.getStoragesToAncestor()[1] != null) {
            this.contributions[3] = new AbstractSelectionContribution(globalMergeManager.getStoragesToAncestor()[1]);
        }
    }

    public IGlobalMergeManager getGlobalMergeManager() {
        return this.globalMergeManager;
    }

    public IMergeTreeNode[] getAllCorrespondingNodes(IMergeTreeNode node) {
        IMergeTreeNode[] results = new IMergeTreeNode[3];
        int source = this.getNumberOfTreeViewer(node);
        int i = 0;
        while (i <= 2) {
            results[i] = i == source ? node : this.getCorrespondingNode(node, source, i);
            ++i;
        }
        return results;
    }

    private int getNumberOfTreeViewer(IMergeTreeNode node) {
        IMergeTreeNode rootNode = node;
        while (rootNode.getParent() != null) {
            rootNode = (IMergeTreeNode)rootNode.getParent();
        }
        int i = 0;
        while (i <= 2) {
            if (this.globalMergeManager.getTcpForUsage(i).getOriginalRootNode() == rootNode) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private IMergeTreeNode getCorrespondingNode(IMergeTreeNode node, int source, int target) {
        AbstractSelectionContribution asc = this.contributions[source + target];
        if (asc != null) {
            return asc.getCorrespondingNodeInTCP(this.globalMergeManager.getTcpForUsage(target), node);
        }
        return null;
    }

    public IMergeTreeNode getCorrespondingNode(IMergeTreeNode node, int target) {
        int source = this.getNumberOfTreeViewer(node);
        if (source == target) {
            return node;
        }
        return this.getCorrespondingNode(node, source, target);
    }
}

