/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.editor;

import com.sap.ide.metamodel.tools.merge.editor.CorrespondingNodesManager;
import com.sap.ide.metamodel.tools.merge.editor.compare.ConflictingNodesContribution;
import com.sap.ide.metamodel.tools.merge.editor.compare.DifferenceStorage;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeInputObject;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeTreeNode;
import com.sap.ide.metamodel.tools.merge.tree.ConflictingNode;
import com.sap.ide.metamodel.tools.merge.tree.TreeViewerView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ConflictingNodesManager {
    private ConflictingNodesContribution localContribution;

    public ConflictingNodesManager(DifferenceStorage localStorage, CorrespondingNodesManager manager) {
        this.localContribution = new ConflictingNodesContribution(localStorage, manager){};
    }

    public void rebuildConflictNodes(TreeViewerView[] views) {
        this.localContribution.rebuildConflictingNodes(views);
    }

    public ConflictingNode selectError(IMergeTreeNode[] selectedNodes, boolean next) {
        return this.localContribution.selectError(selectedNodes, next);
    }

    public void printAllConflicts(File file, IMergeInputObject object1, IMergeInputObject object2) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            if (writer != null) {
                writer.write("<Comparison source=\"" + object1.getName() + "\" target=\"" + object2.getName() + "\">");
                this.localContribution.printAllConflicts(writer);
                writer.write("</Comparison>");
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getConflictInfo(int treeNumber, IMergeTreeNode node) {
        int usage = treeNumber == 16384 ? 0 : 1;
        int i = this.localContribution.getNumberOfConflictingNode(usage, node, true) + 1;
        if (i == 0) {
            return "";
        }
        return "Conflict: " + new Integer(i).toString() + "/" + this.localContribution.getNumberOfAllConflictingNodes();
    }
}

