/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.dialog;

import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.i18n.ResourceTypeEnum;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.tools.merge.dialog.AddNewLanguageDialog;
import com.sap.ide.metamodel.tools.merge.wizard.EditTranslatableTextsWizardPage;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TranslatableTextPropertyDialog
extends Dialog
implements SelectionListener {
    private Shell mShell;
    private DevelopmentObject mObject;
    private String mPropertyName;
    private String mSelectedLanguage;
    private String mKey;
    private Text mTextText;
    private Text mMaxLengthText;
    private Button mCheckboxButton;
    private TextPoolProxy mTextPool;
    private TranslatableText mTranslatableText;
    private Combo mAvailableLanguagesCombo;
    private Combo mResourceTypesCombo;
    private ArrayList mResourceTypeStrings;
    private boolean mIsReadOnly;
    private boolean mDoNotTranslate;
    private String mObjectName;
    private boolean readonly;

    public TranslatableTextPropertyDialog(Shell parent, DevelopmentObject lObject, String property, boolean readonly) {
        super(parent);
        this.mObject = lObject;
        this.mPropertyName = property;
        this.mSelectedLanguage = "";
        this.mResourceTypeStrings = new ArrayList();
        this.mTextPool = (TextPoolProxy)this.mObject.getMDO().getTextPool();
        String lObjectKey = this.mObject.getKey().toString();
        String lMDOName = this.mObject.getKey().getMDOName();
        if (!(this.mObject instanceof MainDevelopmentObject)) {
            this.mKey = lObjectKey.substring(lObjectKey.indexOf(lMDOName) + lMDOName.length() + 1) + "@" + this.mPropertyName;
            this.mObjectName = this.mKey.substring(0, this.mKey.indexOf("@"));
        } else {
            this.mKey = "@" + this.mPropertyName;
            this.mObjectName = this.mObject.getKey().getMDOName();
        }
        this.mTranslatableText = this.mTextPool.getText(this.mKey);
        ArrayList resourceTypes = ResourceTypeEnum.getValues();
        Iterator iter = ((AbstractList)resourceTypes).iterator();
        while (iter.hasNext()) {
            ResourceTypeEnum element = (ResourceTypeEnum)iter.next();
            this.mResourceTypeStrings.add(element.toString());
        }
        this.readonly = readonly;
    }

    public void open() {
        Shell parent = this.getParent();
        this.mShell = new Shell(parent, 64);
        this.mShell.setText("Metamodel Editor - Translatable Text");
        this.mShell.setLayout((Layout)new GridLayout(1, false));
        this.mShell.setSize(400, 320);
        Composite lMainContainer = new Composite((Composite)this.mShell, 0);
        lMainContainer.setLayout((Layout)new GridLayout(1, false));
        GridData lGridData = new GridData(1808);
        lGridData.grabExcessHorizontalSpace = true;
        lGridData.grabExcessVerticalSpace = true;
        lMainContainer.setLayoutData((Object)lGridData);
        Composite lUIContainer = null;
        if (this.mTranslatableText == null) {
            lUIContainer = new Composite(lMainContainer, 0);
            lUIContainer.setLayout((Layout)new GridLayout(1, false));
            Label lInfoLabel = new Label(lUIContainer, 0);
            lInfoLabel.setText("There is no translatable text available for this property.\nPlease enter the required data for the raw language.");
        } else {
            lUIContainer = new Composite(lMainContainer, 0);
            lUIContainer.setLayout((Layout)new GridLayout(3, false));
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            lUIContainer.setLayoutData((Object)gridData);
            Label lLabel = new Label(lUIContainer, 0);
            lLabel.setText("Select Language: ");
            this.mAvailableLanguagesCombo = new Combo(lUIContainer, 8);
            this.mAvailableLanguagesCombo.addSelectionListener((SelectionListener)this);
            Label lMasterLanguageLabel = new Label(lUIContainer, 0);
            lMasterLanguageLabel.setText("Master Language: " + this.mObject.getMDO().getMasterLanguage());
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 3;
            lMasterLanguageLabel.setLayoutData((Object)gridData);
        }
        Label titleBarSeparator = new Label(lMainContainer, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        Composite lEditableContainer = new Composite(lMainContainer, 0);
        lEditableContainer.setLayout((Layout)new GridLayout(2, false));
        lGridData = new GridData(1808);
        lEditableContainer.setLayoutData((Object)lGridData);
        lGridData = new GridData(128);
        Label lObjectLabel = new Label(lEditableContainer, 0);
        lObjectLabel.setText("Object:");
        lObjectLabel.setLayoutData((Object)new GridData(128));
        Text lObjectText = new Text(lEditableContainer, 2056);
        lObjectText.setText(this.mObjectName);
        GridData lObjectGridData = new GridData(768);
        lObjectGridData.grabExcessHorizontalSpace = true;
        lObjectText.setLayoutData((Object)lObjectGridData);
        Label lAttributeLabel = new Label(lEditableContainer, 0);
        lAttributeLabel.setText("Attribute:");
        lAttributeLabel.setLayoutData((Object)new GridData(128));
        Text lAttributeText = new Text(lEditableContainer, 2056);
        lAttributeText.setText(this.mPropertyName);
        Label lTextLabel = new Label(lEditableContainer, 0);
        lTextLabel.setText("Text:");
        lTextLabel.setLayoutData((Object)new GridData(128));
        this.mTextText = new Text(lEditableContainer, 2048);
        GridData lTextGridData = new GridData(768);
        lTextGridData.grabExcessHorizontalSpace = true;
        this.mTextText.setLayoutData((Object)lTextGridData);
        Label lMaxLengthLabel = new Label(lEditableContainer, 0);
        lMaxLengthLabel.setText("Max Length:");
        lMaxLengthLabel.setLayoutData((Object)new GridData(128));
        this.mMaxLengthText = new Text(lEditableContainer, 2048);
        GridData lMaxLengthGridData = new GridData(768);
        lMaxLengthGridData.grabExcessHorizontalSpace = true;
        this.mMaxLengthText.setLayoutData((Object)lMaxLengthGridData);
        Label lResourceTypesLabel = new Label(lEditableContainer, 0);
        lResourceTypesLabel.setText("Resource Type:");
        lResourceTypesLabel.setLayoutData((Object)new GridData(128));
        this.mResourceTypesCombo = new Combo(lEditableContainer, 8);
        this.mResourceTypesCombo.setItems(this.mResourceTypeStrings.toArray(new String[0]));
        Label lEmptyLabel1 = new Label(lEditableContainer, 0);
        Label lEmptyLabel2 = new Label(lEditableContainer, 0);
        Label lDoNotTranslateLabel = new Label(lEditableContainer, 0);
        lDoNotTranslateLabel.setText("Don't translate!");
        lDoNotTranslateLabel.setLayoutData((Object)new GridData(128));
        this.mCheckboxButton = new Button(lEditableContainer, 32);
        this.mCheckboxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatableTextPropertyDialog.this.saveData();
                TranslatableTextPropertyDialog.this.updateControls();
            }
        });
        Label buttonBarSeparator = new Label(lMainContainer, 258);
        buttonBarSeparator.setLayoutData((Object)new GridData(768));
        this.updateControls();
        Composite lButtonBarContainer = new Composite(lMainContainer, 0);
        if (this.readonly) {
            lButtonBarContainer.setLayout((Layout)new GridLayout(1, false));
        } else {
            lButtonBarContainer.setLayout((Layout)new GridLayout(3, false));
        }
        lGridData = new GridData(768);
        lButtonBarContainer.setLayoutData((Object)lGridData);
        if (!this.readonly) {
            Button lAddLanguageButton = new Button(lButtonBarContainer, 8);
            lAddLanguageButton.setText("Add new language");
            lAddLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainDevelopmentObject lMDO = TranslatableTextPropertyDialog.this.mObject.getMDO();
                    AddNewLanguageDialog lDialog = new AddNewLanguageDialog(TranslatableTextPropertyDialog.this.mShell, lMDO);
                    String lResult = lDialog.open();
                    if (lResult != null) {
                        TranslatableTextPropertyDialog.this.mTranslatableText.setText(lResult, "enter translation");
                        TranslatableTextPropertyDialog.this.mSelectedLanguage = lResult;
                        TranslatableTextPropertyDialog.this.updateControls();
                    }
                }
            });
        }
        if (!this.readonly) {
            Button lOKButton = new Button(lButtonBarContainer, 8);
            lOKButton.setText("OK");
            lGridData = new GridData();
            lGridData.horizontalAlignment = 3;
            lGridData.grabExcessHorizontalSpace = true;
            lGridData.widthHint = 50;
            lOKButton.setLayoutData((Object)lGridData);
            lOKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TranslatableTextPropertyDialog.this.saveData();
                    TranslatableTextPropertyDialog.this.mShell.dispose();
                }
            });
        }
        Button lCancelButton = new Button(lButtonBarContainer, 8);
        lCancelButton.setText("Cancel");
        lCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatableTextPropertyDialog.this.mShell.dispose();
            }
        });
        this.mShell.open();
        Display display = parent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void fillAvailableLanguagesCombo() {
        MainDevelopmentObject lMDO = this.mObject.getMDO();
        String[] lAvailableLanguages = lMDO.getMDO().getTextPool().getAvailableLanguages();
        ArrayList<String> lComboText = new ArrayList<String>();
        int i = 0;
        while (i < lAvailableLanguages.length) {
            if (lAvailableLanguages[i].equals("")) {
                lComboText.add("RAW Language (raw)");
            } else {
                lComboText.add(EditTranslatableTextsWizardPage.getLanguageDescriptionByName(lAvailableLanguages[i]));
            }
            ++i;
        }
        this.mAvailableLanguagesCombo.setItems(lComboText.toArray(new String[0]));
    }

    public void widgetSelected(SelectionEvent e) {
        this.saveData();
        this.mSelectedLanguage = this.mAvailableLanguagesCombo.getItem(this.mAvailableLanguagesCombo.getSelectionIndex());
        if (this.mSelectedLanguage.equals("RAW Language (raw)")) {
            this.mSelectedLanguage = "";
        } else {
            this.mSelectedLanguage = this.mSelectedLanguage.substring(this.mSelectedLanguage.lastIndexOf(" "));
            this.mSelectedLanguage = this.mSelectedLanguage.substring(2, this.mSelectedLanguage.length());
            this.mSelectedLanguage = this.mSelectedLanguage.substring(0, this.mSelectedLanguage.length() - 1);
        }
        this.updateControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void updateControls() {
        String lText = "";
        this.mIsReadOnly = false;
        String lMaxLength = "";
        this.mDoNotTranslate = false;
        int lResourceTypeIndex = 0;
        if (this.mTranslatableText != null) {
            lText = this.mTranslatableText.getText(this.mSelectedLanguage);
            this.mIsReadOnly = this.mTranslatableText.isReadOnly(this.mSelectedLanguage);
            lMaxLength = new Integer(this.mTranslatableText.getMaxLength()).toString();
            this.mDoNotTranslate = this.mTranslatableText.getDoNotTranslate();
            String lResourceType = this.mTranslatableText.getResourceType().toString();
            lResourceTypeIndex = this.mResourceTypeStrings.indexOf(lResourceType);
        }
        this.mTextText.setText(lText);
        this.mMaxLengthText.setText(lMaxLength);
        this.mCheckboxButton.setSelection(this.mDoNotTranslate);
        this.mResourceTypesCombo.select(lResourceTypeIndex);
        this.mCheckboxButton.setEnabled(!this.mIsReadOnly);
        this.mTextText.setEnabled(!this.mIsReadOnly && !this.mDoNotTranslate);
        this.mMaxLengthText.setEnabled(!this.mIsReadOnly);
        this.mResourceTypesCombo.setEnabled(!this.mIsReadOnly);
        if (this.mSelectedLanguage.equals("")) {
            this.mTextText.setEnabled(!this.mIsReadOnly);
        }
        if (this.mTranslatableText != null) {
            this.fillAvailableLanguagesCombo();
            this.mAvailableLanguagesCombo.select(this.mAvailableLanguagesCombo.indexOf(EditTranslatableTextsWizardPage.getLanguageDescriptionByName(this.mSelectedLanguage)));
        }
    }

    public void saveData() {
        if (!this.mIsReadOnly) {
            this.mTextPool.setTextData(this.mKey, this.mSelectedLanguage, this.mTextText.getText(), this.mResourceTypeStrings.get(this.mResourceTypesCombo.getSelectionIndex()).toString(), this.mMaxLengthText.getText());
            this.mTranslatableText = this.mTextPool.getText(this.mKey);
            if (this.mTranslatableText != null) {
                this.mTranslatableText.setDoNotTranslate(this.mCheckboxButton.getSelection());
                String lMaxLength = "255";
                if (!this.mMaxLengthText.getText().equals("")) {
                    lMaxLength = this.mMaxLengthText.getText();
                }
                this.mTranslatableText.setMaxLength(new Integer(lMaxLength).intValue());
                this.mTranslatableText.setText(this.mSelectedLanguage, this.mTextText.getText());
                String lResourceTypeIndex = this.mResourceTypeStrings.get(this.mResourceTypesCombo.getSelectionIndex()).toString();
                ResourceTypeEnum lResourceType = ResourceTypeEnum.valueOf((String)lResourceTypeIndex);
                this.mTranslatableText.setResourceType(lResourceType);
            }
        }
    }
}

