/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.tools.merge.dialog;

import com.sap.ide.metamodel.tools.merge.editor.MetaModelTreeEditor;
import com.sap.ide.metamodel.tools.merge.editor.MetamodelTreeEditorInput;
import com.sap.ide.metamodel.tools.merge.editor.actions.AncestorPaneAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.EdgeToggleAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.MergeAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.NextErrorAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.PresentationToggleAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.TakeOverSingleAction;
import com.sap.ide.metamodel.tools.merge.editor.actions.TwoWayMergeAction;
import com.sap.ide.metamodel.tools.merge.images.MMImageManager;
import com.sap.ide.metamodel.tools.merge.interfaces.IMergeEditorInput;
import com.sap.ide.metamodel.tools.merge.tree.NodeSelectedListener;
import com.tssap.dtr.client.eclipse.ui.conflict.Messages;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.IToolBarPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;

public class MetamodelMergeDialog
extends ResizableTitleDialog
implements IPropertyListener {
    private MetaModelTreeEditor editor;
    private Button commitButton;
    private Button printButton;
    private IMergeEditorInput input;
    private Shell shell;
    private AncestorPaneAction apa;
    private static final String DIFF_DIALOG_LOCATION = "com.tssap.dtr.client.eclipse_diffDialogLocation";
    private static final String DIFF_DIALOG_SIZE = "com.tssap.dtr.client.eclipse_diffDialogSize";
    private static final int ACTION_EDGE = 0;
    private static final int ACTION_PRESENTATION = 1;
    private static final int ACTION_ANCESTOR = 2;
    private static final int ACTION_TWO_WAY = 3;
    private static final int ACTION_TAKE_OVER_SINGLE = 4;
    private static final int ACTION_TAKE_OVER_ALL = 5;
    private static final int ACTION_PREV_ERROR = 6;
    private static final int ACTION_NEXT_ERROR = 7;

    public MetamodelMergeDialog(Shell shell, IMergeEditorInput input) {
        super(shell, "MetamodelMerge", null);
        this.input = input;
    }

    public void propertyChanged(Object source, int propId) {
        if (this.commitButton == null || this.editor != null) {
            // empty if block
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.input.getMergeConfiguration().isDiffingForNW04()) {
            this.printButton = this.createButton(parent, 3, "Print Deltas", false);
            this.printButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MetamodelMergeDialog.this.printAllDeltas();
                }
            });
            this.printButton.setEnabled(true);
        }
        if (this.input.getMergeConfiguration().isEditable()) {
            this.commitButton = this.createButton(parent, 0, Messages.getString((String)"DAVCompareDialog.commitAction.label"), true);
            this.commitButton.setEnabled(true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void printAllDeltas() {
        DirectoryDialog dialog = new DirectoryDialog(this.shell, 4096);
        dialog.setText("Choose path");
        String path = dialog.open();
        if (path == null) {
            return;
        }
        String fileName = this.input.getMainMergeObject(0).getName().replace('.', '_') + "_CompareWith_" + this.input.getMainMergeObject(1).getName().replace('.', '_') + ".xml";
        File newFile = new File(path + "\\" + fileName);
        ((MetamodelTreeEditorInput)this.input).getConflictingNodesManager().printAllConflicts(newFile, this.input.getMainMergeObject(0), this.input.getMainMergeObject(1));
    }

    public int open() {
        ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(this.getShell());
        pmDialog.open();
        pmDialog.close();
        int rc = super.open();
        return rc;
    }

    public boolean close() {
        this.editor.doRollBack(null);
        this.persistShellGeometry();
        if (super.close()) {
            if (this.editor != null) {
                this.editor.removePropertyListener(this);
            }
            return true;
        }
        return false;
    }

    protected void cancelPressed() {
        this.editor.setDialogClosed();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.editor.doSave(null);
        this.editor.setDialogClosed();
        super.okPressed();
    }

    private void createButton(int number, ToolItem[] items, IToolBarPane toolbar, Image image, String quickInfo) {
        this.createButton(number, items, toolbar, image, quickInfo, "");
    }

    private void createButton(int number, ToolItem[] items, IToolBarPane toolbar, Image image, String quickInfo1, String quickInfo2) {
        ToolItem item = quickInfo2.equals("") ? (items[number] = toolbar.addPushButton(image, quickInfo1)) : (items[number] = toolbar.addToggleButton(image, quickInfo1));
        MergeAction action = null;
        if (number == 0) {
            action = new EdgeToggleAction(item, this.editor, quickInfo1, quickInfo2);
        } else if (number == 1) {
            action = new PresentationToggleAction(item, this.editor, quickInfo1, quickInfo2);
        } else if (number == 4) {
            action = new TakeOverSingleAction(item, this.editor);
        } else if (number == 6) {
            action = new NextErrorAction(item, this.editor, false);
        } else if (number == 7) {
            action = new NextErrorAction(item, this.editor, true);
        } else if (number == 2) {
            this.apa = new AncestorPaneAction(item, this.editor, quickInfo1, quickInfo2);
            action = this.apa;
        } else if (number == 3) {
            action = new TwoWayMergeAction(item, this.editor, this.apa, quickInfo1, quickInfo2);
        }
        final EdgeToggleAction a = action;
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                a.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (action instanceof NodeSelectedListener) {
            int i = 0;
            while (i <= 2) {
                this.editor.getTreeViewer(i).addSelectionChangedListener((NodeSelectedListener)((Object)action));
                ++i;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.shell = parent.getShell();
        ToolItem[] items = new ToolItem[8];
        IGridLayoutPane groundPane = PaneFactory.createGridLayoutPaneEqualCols((Composite)parent, (int)1);
        groundPane.setMargin(0, 0);
        IGridLayoutPane wholePane = groundPane.addGridLayoutPane(3, true, groundPane.createGridLayoutData(4, 4, true, true));
        IToolBarPane leftToolbar = wholePane.addHorizontalToolBar(groundPane.createGridLayoutData(1, 2, false, false));
        wholePane.addPlaceholder(groundPane.createGridLayoutData(4, 4, true, false));
        IToolBarPane rightToolbar = wholePane.addHorizontalToolBar(groundPane.createGridLayoutData(3, 2, false, false));
        this.editor = new MetaModelTreeEditor("MDO structure");
        try {
            this.editor.init(null, this.input);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
        ISimplePane sp = wholePane.addSimplePane("", groundPane.createGridLayoutData(4, 4, true, true, 3, 1));
        this.editor.createPartControl(sp.getComposite());
        this.createButton(1, items, leftToolbar, MMImageManager.createImage("segment_edit.gif"), "Set Current Node as New Root", "Set Original Root as Root again");
        if (this.input.getMergeConfiguration().isAncestorExisting()) {
            this.createButton(2, items, rightToolbar, MMImageManager.createImage("clcl16/ancestorpane_co.gif"), "Show Ancestor Pane", "Hide Ancestor Pane");
            this.createButton(3, items, rightToolbar, MMImageManager.createImage("clcl16/twowaycompare_co.gif"), "Two-Way Compare (Ignore Ancestor)", "Three-Way Compare");
            rightToolbar.addSeparator();
        }
        if (this.input.getMergeConfiguration().isEditable()) {
            this.createButton(5, items, rightToolbar, MMImageManager.createImage("clcl16/copy_l_co.gif"), "Copy All Non-Conflicting Changes from Right to Left");
            this.createButton(4, items, rightToolbar, MMImageManager.createImage("clcl16/copycont_l_co.gif"), "Copy Current Change from Right to Left");
            rightToolbar.addSeparator();
        }
        this.createButton(6, items, rightToolbar, MMImageManager.createImage("clcl16/prev_nav.gif"), "Select Previous Change");
        this.createButton(7, items, rightToolbar, MMImageManager.createImage("clcl16/next_nav.gif"), "Select Next Change");
        Composite c = groundPane.getComposite();
        c.setLayoutData((Object)new GridData(1808));
        return c;
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords((Point)shellLocation);
        String sizeString = LayoutHelper.serializeCoords((Point)shellSize);
        this.getPreferenceStore().setValue(DIFF_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(DIFF_DIALOG_SIZE, sizeString);
    }
}

