/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.dictionary.datatype.StructureTypeEnum;
import com.sap.ide.metamodel.dictionary.implementation.DtComplexTypeState;
import com.sap.ide.metamodel.dictionary.implementation.DtStructureElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

abstract class DtStructureState
extends DtComplexTypeState {
    private boolean mMultiClientEnabled;
    private boolean mHasMultiClientEnabled = false;
    private String mStructureType = "flat";
    private boolean mHasStructureType = false;
    private Vector mStructureElements = new Vector();

    DtStructureState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        DtStructureState lState = (DtStructureState)object;
        if (!String.valueOf(this.mMultiClientEnabled).equals(String.valueOf(lState.mMultiClientEnabled))) {
            return false;
        }
        return String.valueOf(this.mStructureType).equals(String.valueOf(lState.mStructureType));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        DtStructureState lState = (DtStructureState)object;
        if (!String.valueOf(this.mMultiClientEnabled).equals(String.valueOf(lState.mMultiClientEnabled))) {
            compareContext.addPropertyDelta(sourceObject, "multiClientEnabled", (Object)new Boolean(lState.mMultiClientEnabled));
        }
        if (!String.valueOf(this.mStructureType).equals(String.valueOf(lState.mStructureType))) {
            compareContext.addPropertyDelta(sourceObject, "structureType", (Object)StructureTypeEnum.valueOf(lState.mStructureType));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DtStructureState lState = (DtStructureState)((Object)super.clone());
        lState.mStructureElements = new Vector();
        int i = 0;
        while (i < this.mStructureElements.size()) {
            lState.mStructureElements.add(((DtStructureElementState)((Object)this.mStructureElements.get(i))).clone());
            ++i;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mStructureElements).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mStructureElements).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mStructureElements).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setMultiClientEnabled(boolean value) {
        this.mMultiClientEnabled = value;
        this.mHasMultiClientEnabled = true;
    }

    boolean getMultiClientEnabled() {
        return this.mMultiClientEnabled;
    }

    boolean hasMultiClientEnabled() {
        return this.mHasMultiClientEnabled;
    }

    void setStructureType(String value) {
        this.mStructureType = value;
        this.mHasStructureType = true;
    }

    String getStructureType() {
        return this.mStructureType;
    }

    boolean hasStructureType() {
        return this.mHasStructureType;
    }

    void addStructureElement(DtStructureElementState state) {
        this.mStructureElements.add(state);
    }

    void addStructureElement(DtStructureElementState state, int position) {
        this.mStructureElements.add(position, state);
    }

    int getStructureElementCount() {
        return this.mStructureElements.size();
    }

    DtStructureElementState getStructureElement(String name) {
        int i = 0;
        while (i < this.mStructureElements.size()) {
            DtStructureElementState lState = (DtStructureElementState)((Object)this.mStructureElements.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getStructureElements() {
        return this.mStructureElements;
    }

    void removeStructureElement(DtStructureElementState state) {
        this.mStructureElements.remove((Object)state);
    }

    void removeAllStructureElements() {
        this.mStructureElements.clear();
    }

    void moveStructureElement(int fromPosition, int toPosition) {
        this.mStructureElements.add(toPosition, this.mStructureElements.remove(fromPosition));
    }

    void reorderStructureElements(Vector orderedStates) {
        this.mStructureElements = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("multiClientEnabled")) {
            this.setMultiClientEnabled(new Boolean((String)value));
        } else if (propertyName.equals("structureType")) {
            if (StructureTypeEnum.valueOf((String)value) != null) {
                this.setStructureType((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("StructureElements")) {
            this.addStructureElement((DtStructureElementState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

