/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.FieldTypeEnum;
import com.sap.ide.metamodel.dictionary.implementation.DtDbTypeInfoState;
import com.sap.ide.metamodel.dictionary.implementation.DtStructureElementState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class DtFieldState
extends DtStructureElementState {
    private String mBackendName = null;
    private boolean mHasBackendName = false;
    private String mBuiltInType = null;
    private boolean mHasBuiltInType = false;
    private String mDbDefault = null;
    private boolean mHasDbDefault = false;
    private String mFieldType = "simple";
    private boolean mHasFieldType = false;
    private int mFractionDigits;
    private boolean mHasFractionDigits = false;
    private String mGroup = null;
    private boolean mHasGroup = false;
    private String mJdbcTypeName = null;
    private boolean mHasJdbcTypeName = false;
    private int mLength;
    private boolean mHasLength = false;
    private String mNotNull = "not_set";
    private boolean mHasNotNull = false;
    private boolean mRefNormalized;
    private boolean mHasRefNormalized = false;
    private int mTotalDigits;
    private boolean mHasTotalDigits = false;
    private HashMap mTypeInfos = new HashMap();
    private Reference mRefFieldRef = null;
    private Reference mReferencedTypeRef = null;

    DtFieldState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        DtFieldState lState = (DtFieldState)object;
        if (!String.valueOf(this.mBackendName).equals(String.valueOf(lState.mBackendName))) {
            return false;
        }
        if (!String.valueOf(this.mBuiltInType).equals(String.valueOf(lState.mBuiltInType))) {
            return false;
        }
        if (!String.valueOf(this.mDbDefault).equals(String.valueOf(lState.mDbDefault))) {
            return false;
        }
        if (!String.valueOf(this.mFieldType).equals(String.valueOf(lState.mFieldType))) {
            return false;
        }
        if (!String.valueOf(this.mFractionDigits).equals(String.valueOf(lState.mFractionDigits))) {
            return false;
        }
        if (!String.valueOf(this.mGroup).equals(String.valueOf(lState.mGroup))) {
            return false;
        }
        if (!String.valueOf(this.mJdbcTypeName).equals(String.valueOf(lState.mJdbcTypeName))) {
            return false;
        }
        if (!String.valueOf(this.mLength).equals(String.valueOf(lState.mLength))) {
            return false;
        }
        if (!String.valueOf(this.mNotNull).equals(String.valueOf(lState.mNotNull))) {
            return false;
        }
        if (!String.valueOf(this.mRefNormalized).equals(String.valueOf(lState.mRefNormalized))) {
            return false;
        }
        return String.valueOf(this.mTotalDigits).equals(String.valueOf(lState.mTotalDigits));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        DtFieldState lState = (DtFieldState)object;
        if (!String.valueOf(this.mBackendName).equals(String.valueOf(lState.mBackendName))) {
            compareContext.addPropertyDelta(sourceObject, "backendName", (Object)lState.mBackendName);
        }
        if (!String.valueOf(this.mBuiltInType).equals(String.valueOf(lState.mBuiltInType))) {
            compareContext.addPropertyDelta(sourceObject, "builtInType", (Object)lState.mBuiltInType);
        }
        if (!String.valueOf(this.mDbDefault).equals(String.valueOf(lState.mDbDefault))) {
            compareContext.addPropertyDelta(sourceObject, "dbDefault", (Object)lState.mDbDefault);
        }
        if (!String.valueOf(this.mFieldType).equals(String.valueOf(lState.mFieldType))) {
            compareContext.addPropertyDelta(sourceObject, "fieldType", (Object)FieldTypeEnum.valueOf(lState.mFieldType));
        }
        if (!String.valueOf(this.mFractionDigits).equals(String.valueOf(lState.mFractionDigits))) {
            compareContext.addPropertyDelta(sourceObject, "fractionDigits", (Object)new Integer(lState.mFractionDigits));
        }
        if (!String.valueOf(this.mGroup).equals(String.valueOf(lState.mGroup))) {
            compareContext.addPropertyDelta(sourceObject, "group", (Object)lState.mGroup);
        }
        if (!String.valueOf(this.mJdbcTypeName).equals(String.valueOf(lState.mJdbcTypeName))) {
            compareContext.addPropertyDelta(sourceObject, "jdbcTypeName", (Object)lState.mJdbcTypeName);
        }
        if (!String.valueOf(this.mLength).equals(String.valueOf(lState.mLength))) {
            compareContext.addPropertyDelta(sourceObject, "length", (Object)new Integer(lState.mLength));
        }
        if (!String.valueOf(this.mNotNull).equals(String.valueOf(lState.mNotNull))) {
            compareContext.addPropertyDelta(sourceObject, "notNull", (Object)BooleanEnum.valueOf(lState.mNotNull));
        }
        if (!String.valueOf(this.mRefNormalized).equals(String.valueOf(lState.mRefNormalized))) {
            compareContext.addPropertyDelta(sourceObject, "refNormalized", (Object)new Boolean(lState.mRefNormalized));
        }
        if (!String.valueOf(this.mTotalDigits).equals(String.valueOf(lState.mTotalDigits))) {
            compareContext.addPropertyDelta(sourceObject, "totalDigits", (Object)new Integer(lState.mTotalDigits));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DtFieldState lState = (DtFieldState)((Object)super.clone());
        lState.mTypeInfos = new HashMap();
        Iterator it = this.mTypeInfos.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mTypeInfos.put(lKey, ((DtDbTypeInfoState)((Object)this.mTypeInfos.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mRefFieldRef != null && !innerObjectKeys.contains(this.mRefFieldRef.toString())) {
            this.mRefFieldRef = null;
        }
        Iterator it = this.mTypeInfos.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mTypeInfos.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mTypeInfos.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mRefFieldRef != null) {
            if (clipboardService.isExcluded(this.mRefFieldRef)) {
                this.mRefFieldRef = null;
            } else if (innerObjectKeys.contains(this.mRefFieldRef.toReferenceString())) {
                this.mRefFieldRef = clipboardService.refactor(this.mRefFieldRef);
            }
        }
        if (this.mReferencedTypeRef != null) {
            if (clipboardService.isExcluded(this.mReferencedTypeRef)) {
                this.mReferencedTypeRef = null;
            } else if (innerObjectKeys.contains(this.mReferencedTypeRef.toReferenceString())) {
                this.mReferencedTypeRef = clipboardService.refactor(this.mReferencedTypeRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mRefFieldRef != null && this.mRefFieldRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mReferencedTypeRef != null && this.mReferencedTypeRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mRefFieldRef != null) {
            this.mRefFieldRef = refactoringService.refactor(this.mRefFieldRef);
        }
        if (this.mReferencedTypeRef != null) {
            this.mReferencedTypeRef = refactoringService.refactor(this.mReferencedTypeRef);
        }
    }

    void setBackendName(String value) {
        if (value == null) {
            this.unsetBackendName();
            return;
        }
        this.mBackendName = value;
        this.mHasBackendName = true;
    }

    String getBackendName() {
        return this.mBackendName;
    }

    boolean hasBackendName() {
        return this.mHasBackendName;
    }

    void unsetBackendName() {
        this.mBackendName = null;
        this.mHasBackendName = false;
    }

    void setBuiltInType(String value) {
        if (value == null) {
            this.unsetBuiltInType();
            return;
        }
        this.mBuiltInType = value;
        this.mHasBuiltInType = true;
    }

    String getBuiltInType() {
        return this.mBuiltInType;
    }

    boolean hasBuiltInType() {
        return this.mHasBuiltInType;
    }

    void unsetBuiltInType() {
        this.mBuiltInType = null;
        this.mHasBuiltInType = false;
    }

    void setDbDefault(String value) {
        if (value == null) {
            this.unsetDbDefault();
            return;
        }
        this.mDbDefault = value;
        this.mHasDbDefault = true;
    }

    String getDbDefault() {
        return this.mDbDefault;
    }

    boolean hasDbDefault() {
        return this.mHasDbDefault;
    }

    void unsetDbDefault() {
        this.mDbDefault = null;
        this.mHasDbDefault = false;
    }

    void setFieldType(String value) {
        this.mFieldType = value;
        this.mHasFieldType = true;
    }

    String getFieldType() {
        return this.mFieldType;
    }

    boolean hasFieldType() {
        return this.mHasFieldType;
    }

    void setFractionDigits(int value) {
        this.mFractionDigits = value;
        this.mHasFractionDigits = true;
    }

    int getFractionDigits() {
        return this.mFractionDigits;
    }

    boolean hasFractionDigits() {
        return this.mHasFractionDigits;
    }

    void setGroup(String value) {
        if (value == null) {
            this.unsetGroup();
            return;
        }
        this.mGroup = value;
        this.mHasGroup = true;
    }

    String getGroup() {
        return this.mGroup;
    }

    boolean hasGroup() {
        return this.mHasGroup;
    }

    void unsetGroup() {
        this.mGroup = null;
        this.mHasGroup = false;
    }

    void setJdbcTypeName(String value) {
        if (value == null) {
            this.unsetJdbcTypeName();
            return;
        }
        this.mJdbcTypeName = value;
        this.mHasJdbcTypeName = true;
    }

    String getJdbcTypeName() {
        return this.mJdbcTypeName;
    }

    boolean hasJdbcTypeName() {
        return this.mHasJdbcTypeName;
    }

    void unsetJdbcTypeName() {
        this.mJdbcTypeName = null;
        this.mHasJdbcTypeName = false;
    }

    void setLength(int value) {
        this.mLength = value;
        this.mHasLength = true;
    }

    int getLength() {
        return this.mLength;
    }

    boolean hasLength() {
        return this.mHasLength;
    }

    void setNotNull(String value) {
        this.mNotNull = value;
        this.mHasNotNull = true;
    }

    String getNotNull() {
        return this.mNotNull;
    }

    boolean hasNotNull() {
        return this.mHasNotNull;
    }

    void setRefNormalized(boolean value) {
        this.mRefNormalized = value;
        this.mHasRefNormalized = true;
    }

    boolean getRefNormalized() {
        return this.mRefNormalized;
    }

    boolean hasRefNormalized() {
        return this.mHasRefNormalized;
    }

    void setTotalDigits(int value) {
        this.mTotalDigits = value;
        this.mHasTotalDigits = true;
    }

    int getTotalDigits() {
        return this.mTotalDigits;
    }

    boolean hasTotalDigits() {
        return this.mHasTotalDigits;
    }

    void addTypeInfo(DtDbTypeInfoState state) {
        this.mTypeInfos.put(state.getName().toLowerCase(), state);
    }

    int getTypeInfoCount() {
        return this.mTypeInfos.size();
    }

    DtDbTypeInfoState getTypeInfo(String name) {
        return (DtDbTypeInfoState)((Object)this.mTypeInfos.get(name.toLowerCase()));
    }

    Vector getTypeInfos() {
        return new Vector(this.mTypeInfos.values());
    }

    void removeTypeInfo(String aggregationKey) {
        this.mTypeInfos.remove(aggregationKey.toLowerCase());
    }

    void removeTypeInfo(DtDbTypeInfoState state) {
        this.mTypeInfos.remove(state.getName().toLowerCase());
    }

    void removeAllTypeInfos() {
        this.mTypeInfos.clear();
    }

    Reference getRefField() {
        return this.mRefFieldRef;
    }

    void setRefField(Reference reference) {
        this.mRefFieldRef = reference;
    }

    Reference getReferencedType() {
        return this.mReferencedTypeRef;
    }

    void setReferencedType(Reference reference) {
        this.mReferencedTypeRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("backendName")) {
            this.setBackendName((String)value);
        } else if (propertyName.equals("builtInType")) {
            this.setBuiltInType((String)value);
        } else if (propertyName.equals("dbDefault")) {
            this.setDbDefault((String)value);
        } else if (propertyName.equals("fieldType")) {
            if (FieldTypeEnum.valueOf((String)value) != null) {
                this.setFieldType((String)value);
            }
        } else if (propertyName.equals("fractionDigits")) {
            this.setFractionDigits(new Integer((String)value));
        } else if (propertyName.equals("group")) {
            this.setGroup((String)value);
        } else if (propertyName.equals("jdbcTypeName")) {
            this.setJdbcTypeName((String)value);
        } else if (propertyName.equals("length")) {
            this.setLength(new Integer((String)value));
        } else if (propertyName.equals("notNull")) {
            if (BooleanEnum.valueOf((String)value) != null) {
                this.setNotNull((String)value);
            }
        } else if (propertyName.equals("refNormalized")) {
            this.setRefNormalized(new Boolean((String)value));
        } else if (propertyName.equals("totalDigits")) {
            this.setTotalDigits(new Integer((String)value));
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("TypeInfos")) {
            this.addTypeInfo((DtDbTypeInfoState)((Object)data));
        } else if (roleName.equals("RefField")) {
            this.setRefField((Reference)data);
        } else if (roleName.equals("ReferencedType")) {
            this.setReferencedType((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

