/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.vi;

import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ViModelMetaInfo {
    private static final String STRUCTURE_NODE_DOMAIN = "model";
    private static final String STRUCTURE_NODE_SUBDOMAIN = "project";
    private static final String DOMAIN = "WebServicesObject";
    private static final String VIRTUAL_INTERFACES_SUBDOMAIN = "VirtualInterfaces";
    private static final String VIRTUAL_INTERFACE_SUBDOMAIN = "VirtualInterface";
    private static final String VIRTUAL_INTERFACES_METACLASS = "Virtual Interfaces";
    private static final String VIRTUAL_INTERFACE_METACLASS = "Virtual Interface";

    public static boolean isVi(UniqueName uniqueName) {
        return uniqueName.getDomain().equals(DOMAIN) && uniqueName.getSubDomain().equals(VIRTUAL_INTERFACE_SUBDOMAIN);
    }

    public static boolean isViStructureNode(UniqueName uniqueName) {
        return uniqueName.getDomain().equals(DOMAIN) && uniqueName.getSubDomain().equals(VIRTUAL_INTERFACES_SUBDOMAIN);
    }

    public static boolean canCreateUniqueName(UniqueName uniqueName, String shapeType) {
        return ViModelMetaInfo.isVi(uniqueName) && shapeType.equals(VIRTUAL_INTERFACE_METACLASS);
    }

    public static String getMetaClass() {
        return VIRTUAL_INTERFACE_METACLASS;
    }

    public static String getSubDomain() {
        return VIRTUAL_INTERFACE_SUBDOMAIN;
    }

    public static String getSubDomainForStructureNode() {
        return VIRTUAL_INTERFACES_SUBDOMAIN;
    }

    public static String getMetaClassForStructureNode() {
        return VIRTUAL_INTERFACES_METACLASS;
    }

    public static String getNameForStructureNode() {
        return VIRTUAL_INTERFACES_METACLASS;
    }

    public static String getWebServiceObjectDomain() {
        return DOMAIN;
    }

    public static String getProjectDomain() {
        return STRUCTURE_NODE_DOMAIN;
    }

    public static String getProjectSubDomain() {
        return STRUCTURE_NODE_SUBDOMAIN;
    }

    private static boolean hasNatureByProjectNameID(String projectName, String Id) {
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        boolean hasNature = false;
        try {
            hasNature = eclipseProject.hasNature(Id);
        }
        catch (CoreException e) {
            // empty catch block
        }
        return hasNature;
    }

    public static boolean projectHasEarNature(String projectName) {
        return ViModelMetaInfo.hasNatureByProjectNameID(projectName, "com.tssap.j2ee.core.ear.earNature");
    }

    public static boolean projectHasEjbNature(String projectName) {
        return ViModelMetaInfo.hasNatureByProjectNameID(projectName, "com.tssap.j2ee.core.ejb.ejbNature");
    }

    public static boolean projectHasEjbJarNature(String projectName) {
        return ViModelMetaInfo.hasNatureByProjectNameID(projectName, "com.tssap.j2ee.core.ejbjar.ejbJarNature");
    }
}

