/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConditionalExpression
extends OperatorExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ConditionalExpression(Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
        this.condition = condition;
        this.valueIfTrue = valueIfTrue;
        this.valueIfFalse = valueIfFalse;
        this.sourceStart = condition.sourceStart;
        this.sourceEnd = valueIfFalse.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo mergedInfo;
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != AstNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != AstNode.NotAConstant && !cst.booleanValue();
        int mode = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo, cst == AstNode.NotAConstant);
        FlowInfo trueFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            trueFlowInfo.setReachMode(1);
        }
        this.trueInitStateIndex = currentScope.methodScope().recordInitializationStates(trueFlowInfo);
        trueFlowInfo = this.valueIfTrue.analyseCode(currentScope, flowContext, trueFlowInfo);
        FlowInfo falseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            falseFlowInfo.setReachMode(1);
        }
        this.falseInitStateIndex = currentScope.methodScope().recordInitializationStates(falseFlowInfo);
        falseFlowInfo = this.valueIfFalse.analyseCode(currentScope, flowContext, falseFlowInfo);
        if (isConditionOptimizedTrue) {
            mergedInfo = trueFlowInfo.addPotentialInitializationsFrom(falseFlowInfo);
        } else if (isConditionOptimizedFalse) {
            mergedInfo = falseFlowInfo.addPotentialInitializationsFrom(trueFlowInfo);
        } else {
            cst = this.optimizedIfTrueConstant;
            boolean isValueIfTrueOptimizedTrue = cst != null && cst != AstNode.NotAConstant && cst.booleanValue();
            boolean isValueIfTrueOptimizedFalse = cst != null && cst != AstNode.NotAConstant && !cst.booleanValue();
            cst = this.optimizedIfFalseConstant;
            boolean isValueIfFalseOptimizedTrue = cst != null && cst != AstNode.NotAConstant && cst.booleanValue();
            boolean isValueIfFalseOptimizedFalse = cst != null && cst != AstNode.NotAConstant && !cst.booleanValue();
            UnconditionalFlowInfo trueInfoWhenTrue = trueFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfTrueOptimizedFalse) {
                trueInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenTrue = falseFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfFalseOptimizedFalse) {
                falseInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo trueInfoWhenFalse = trueFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfTrueOptimizedTrue) {
                trueInfoWhenFalse.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenFalse = falseFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfFalseOptimizedTrue) {
                falseInfoWhenFalse.setReachMode(1);
            }
            mergedInfo = FlowInfo.conditional(trueInfoWhenTrue.mergedWith(falseInfoWhenTrue), trueInfoWhenFalse.mergedWith(falseInfoWhenFalse));
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        mergedInfo.setReachMode(mode);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != AstNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        Constant cst = this.condition.constant;
        Constant condCst = this.condition.optimizedBooleanConstant();
        boolean needTruePart = !(cst != AstNode.NotAConstant && !cst.booleanValue() || condCst != AstNode.NotAConstant && !condCst.booleanValue());
        boolean needFalsePart = !(cst != AstNode.NotAConstant && cst.booleanValue() || condCst != AstNode.NotAConstant && condCst.booleanValue());
        Label endifLabel = new Label(codeStream);
        boolean needConditionValue = cst == AstNode.NotAConstant && condCst == AstNode.NotAConstant;
        Label falseLabel = new Label(codeStream);
        this.condition.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, needConditionValue);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
        }
        if (needTruePart) {
            this.valueIfTrue.generateCode(currentScope, codeStream, valueRequired);
            if (needFalsePart) {
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(position);
                if (valueRequired) {
                    codeStream.decrStackSize(this.resolvedType == BaseTypes.LongBinding || this.resolvedType == BaseTypes.DoubleBinding ? 2 : 1);
                }
            }
        }
        if (needFalsePart) {
            falseLabel.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateCode(currentScope, codeStream, valueRequired);
            endifLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5 || this.valueIfTrue.implicitConversion >> 4 != 5) {
            super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            return;
        }
        Constant cst = this.condition.constant;
        Constant condCst = this.condition.optimizedBooleanConstant();
        boolean needTruePart = !(cst != AstNode.NotAConstant && !cst.booleanValue() || condCst != AstNode.NotAConstant && !condCst.booleanValue());
        boolean needFalsePart = !(cst != AstNode.NotAConstant && cst.booleanValue() || condCst != AstNode.NotAConstant && condCst.booleanValue());
        Label endifLabel = new Label(codeStream);
        boolean needConditionValue = cst == AstNode.NotAConstant && condCst == AstNode.NotAConstant;
        Label internalFalseLabel = new Label(codeStream);
        this.condition.generateOptimizedBoolean(currentScope, codeStream, null, internalFalseLabel, needConditionValue);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
        }
        if (needTruePart) {
            this.valueIfTrue.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            if (needFalsePart) {
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(position);
            }
        }
        if (needFalsePart) {
            internalFalseLabel.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            endifLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public TypeBinding resolveType(BlockScope scope) {
        Constant falseConstant;
        Constant trueConstant;
        this.constant = AstNode.NotAConstant;
        TypeBinding conditionType = this.condition.resolveTypeExpecting(scope, BaseTypes.BooleanBinding);
        TypeBinding valueIfTrueType = this.valueIfTrue.resolveType(scope);
        TypeBinding valueIfFalseType = this.valueIfFalse.resolveType(scope);
        if (conditionType == null || valueIfTrueType == null || valueIfFalseType == null) {
            return null;
        }
        Constant condConstant = this.condition.constant;
        if (condConstant != AstNode.NotAConstant && (trueConstant = this.valueIfTrue.constant) != AstNode.NotAConstant && (falseConstant = this.valueIfFalse.constant) != AstNode.NotAConstant) {
            Constant constant = this.constant = condConstant.booleanValue() ? trueConstant : falseConstant;
        }
        if (valueIfTrueType == valueIfFalseType) {
            this.valueIfTrue.implicitWidening(valueIfTrueType, valueIfTrueType);
            this.valueIfFalse.implicitConversion = this.valueIfTrue.implicitConversion;
            if (valueIfTrueType == BaseTypes.BooleanBinding) {
                this.optimizedIfTrueConstant = this.valueIfTrue.optimizedBooleanConstant();
                this.optimizedIfFalseConstant = this.valueIfFalse.optimizedBooleanConstant();
                if (this.optimizedIfTrueConstant != AstNode.NotAConstant && this.optimizedIfFalseConstant != AstNode.NotAConstant && this.optimizedIfTrueConstant.booleanValue() == this.optimizedIfFalseConstant.booleanValue()) {
                    this.optimizedBooleanConstant = this.optimizedIfTrueConstant;
                } else {
                    condConstant = this.condition.optimizedBooleanConstant();
                    if (condConstant != AstNode.NotAConstant) {
                        this.optimizedBooleanConstant = condConstant.booleanValue() ? this.optimizedIfTrueConstant : this.optimizedIfFalseConstant;
                    }
                }
            }
            this.resolvedType = valueIfTrueType;
            return this.resolvedType;
        }
        if (valueIfTrueType.isNumericType() && valueIfFalseType.isNumericType()) {
            if (valueIfTrueType == BaseTypes.ByteBinding && valueIfFalseType == BaseTypes.ShortBinding || valueIfTrueType == BaseTypes.ShortBinding && valueIfFalseType == BaseTypes.ByteBinding) {
                this.valueIfTrue.implicitWidening(BaseTypes.ShortBinding, valueIfTrueType);
                this.valueIfFalse.implicitWidening(BaseTypes.ShortBinding, valueIfFalseType);
                this.resolvedType = BaseTypes.ShortBinding;
                return this.resolvedType;
            }
            if ((valueIfTrueType == BaseTypes.ByteBinding || valueIfTrueType == BaseTypes.ShortBinding || valueIfTrueType == BaseTypes.CharBinding) && valueIfFalseType == BaseTypes.IntBinding && this.valueIfFalse.isConstantValueOfTypeAssignableToType(valueIfFalseType, valueIfTrueType)) {
                this.valueIfTrue.implicitWidening(valueIfTrueType, valueIfTrueType);
                this.valueIfFalse.implicitWidening(valueIfTrueType, valueIfFalseType);
                this.resolvedType = valueIfTrueType;
                return this.resolvedType;
            }
            if ((valueIfFalseType == BaseTypes.ByteBinding || valueIfFalseType == BaseTypes.ShortBinding || valueIfFalseType == BaseTypes.CharBinding) && valueIfTrueType == BaseTypes.IntBinding && this.valueIfTrue.isConstantValueOfTypeAssignableToType(valueIfTrueType, valueIfFalseType)) {
                this.valueIfTrue.implicitWidening(valueIfFalseType, valueIfTrueType);
                this.valueIfFalse.implicitWidening(valueIfFalseType, valueIfFalseType);
                this.resolvedType = valueIfFalseType;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 10) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 10)) {
                this.valueIfTrue.implicitWidening(BaseTypes.IntBinding, valueIfTrueType);
                this.valueIfFalse.implicitWidening(BaseTypes.IntBinding, valueIfFalseType);
                this.resolvedType = BaseTypes.IntBinding;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 7) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 7)) {
                this.valueIfTrue.implicitWidening(BaseTypes.LongBinding, valueIfTrueType);
                this.valueIfFalse.implicitWidening(BaseTypes.LongBinding, valueIfFalseType);
                this.resolvedType = BaseTypes.LongBinding;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 9) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 9)) {
                this.valueIfTrue.implicitWidening(BaseTypes.FloatBinding, valueIfTrueType);
                this.valueIfFalse.implicitWidening(BaseTypes.FloatBinding, valueIfFalseType);
                this.resolvedType = BaseTypes.FloatBinding;
                return this.resolvedType;
            }
            this.valueIfTrue.implicitWidening(BaseTypes.DoubleBinding, valueIfTrueType);
            this.valueIfFalse.implicitWidening(BaseTypes.DoubleBinding, valueIfFalseType);
            this.resolvedType = BaseTypes.DoubleBinding;
            return this.resolvedType;
        }
        if (valueIfTrueType.isBaseType() && valueIfTrueType != BaseTypes.NullBinding || valueIfFalseType.isBaseType() && valueIfFalseType != BaseTypes.NullBinding) {
            scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
            return null;
        }
        if (valueIfFalseType.isCompatibleWith(valueIfTrueType)) {
            this.valueIfTrue.implicitWidening(valueIfTrueType, valueIfTrueType);
            this.valueIfFalse.implicitWidening(valueIfTrueType, valueIfFalseType);
            this.resolvedType = valueIfTrueType;
            return this.resolvedType;
        }
        if (valueIfTrueType.isCompatibleWith(valueIfFalseType)) {
            this.valueIfTrue.implicitWidening(valueIfFalseType, valueIfTrueType);
            this.valueIfFalse.implicitWidening(valueIfFalseType, valueIfFalseType);
            this.resolvedType = valueIfFalseType;
            return this.resolvedType;
        }
        scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
        return null;
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.condition.toStringExpression()) + " ? " + this.valueIfTrue.toStringExpression() + " : " + this.valueIfFalse.toStringExpression();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.valueIfTrue.traverse(visitor, scope);
            this.valueIfFalse.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

