/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import org.eclipse.jdt.core.compiler.CharOperation;

public final class Signature {
    public static final char C_BOOLEAN = 'Z';
    public static final char C_BYTE = 'B';
    public static final char C_CHAR = 'C';
    public static final char C_DOUBLE = 'D';
    public static final char C_FLOAT = 'F';
    public static final char C_INT = 'I';
    public static final char C_SEMICOLON = ';';
    public static final char C_LONG = 'J';
    public static final char C_SHORT = 'S';
    public static final char C_VOID = 'V';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final String SIG_BOOLEAN = "Z";
    public static final String SIG_BYTE = "B";
    public static final String SIG_CHAR = "C";
    public static final String SIG_DOUBLE = "D";
    public static final String SIG_FLOAT = "F";
    public static final String SIG_INT = "I";
    public static final String SIG_LONG = "J";
    public static final String SIG_SHORT = "S";
    public static final String SIG_VOID = "V";
    private static final char[] BOOLEAN = new char[]{'b', 'o', 'o', 'l', 'e', 'a', 'n'};
    private static final char[] BYTE = new char[]{'b', 'y', 't', 'e'};
    private static final char[] CHAR = new char[]{'c', 'h', 'a', 'r'};
    private static final char[] DOUBLE = new char[]{'d', 'o', 'u', 'b', 'l', 'e'};
    private static final char[] FLOAT = new char[]{'f', 'l', 'o', 'a', 't'};
    private static final char[] INT = new char[]{'i', 'n', 't'};
    private static final char[] LONG = new char[]{'l', 'o', 'n', 'g'};
    private static final char[] SHORT = new char[]{'s', 'h', 'o', 'r', 't'};
    private static final char[] VOID = new char[]{'v', 'o', 'i', 'd'};
    private static final String EMPTY = new String(CharOperation.NO_CHAR);

    private Signature() {
    }

    /*
     * Unable to fully structure code
     */
    private static long copyType(char[] signature, int sigPos, char[] dest, int index, boolean fullyQualifyTypeNames) {
        arrayCount = 0;
        while (true) {
            switch (signature[sigPos++]) {
                case '[': {
                    ++arrayCount;
                    break;
                }
                case 'Z': {
                    length = Signature.BOOLEAN.length;
                    System.arraycopy(Signature.BOOLEAN, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'B': {
                    length = Signature.BYTE.length;
                    System.arraycopy(Signature.BYTE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'C': {
                    length = Signature.CHAR.length;
                    System.arraycopy(Signature.CHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'D': {
                    length = Signature.DOUBLE.length;
                    System.arraycopy(Signature.DOUBLE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'F': {
                    length = Signature.FLOAT.length;
                    System.arraycopy(Signature.FLOAT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'I': {
                    length = Signature.INT.length;
                    System.arraycopy(Signature.INT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'J': {
                    length = Signature.LONG.length;
                    System.arraycopy(Signature.LONG, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'S': {
                    length = Signature.SHORT.length;
                    System.arraycopy(Signature.SHORT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'V': {
                    length = Signature.VOID.length;
                    System.arraycopy(Signature.VOID, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl71
                }
                case 'L': 
                case 'Q': {
                    end = CharOperation.indexOf(';', signature, sigPos);
                    if (end == -1) {
                        throw new IllegalArgumentException();
                    }
                    if (fullyQualifyTypeNames) {
                        start = sigPos;
                    } else {
                        start = CharOperation.lastIndexOf('.', signature, sigPos, end) + 1;
                        if (start == 0) {
                            start = sigPos;
                        }
                    }
                    length = end - start;
                    System.arraycopy(signature, start, dest, index, length);
                    sigPos = end + 1;
                    index += length;
                    if (true) ** GOTO lbl71
                }
            }
        }
        do {
            dest[index++] = 91;
            dest[index++] = 93;
lbl71:
            // 11 sources

        } while (arrayCount-- > 0);
        return ((long)index << 32) + (long)sigPos;
    }

    public static char[] createArraySignature(char[] typeSignature, int arrayCount) {
        if (arrayCount == 0) {
            return typeSignature;
        }
        int sigLength = typeSignature.length;
        char[] result = new char[arrayCount + sigLength];
        int i = 0;
        while (i < arrayCount) {
            result[i] = 91;
            ++i;
        }
        System.arraycopy(typeSignature, 0, result, arrayCount, sigLength);
        return result;
    }

    public static String createArraySignature(String typeSignature, int arrayCount) {
        return new String(Signature.createArraySignature(typeSignature.toCharArray(), arrayCount));
    }

    public static char[] createMethodSignature(char[][] parameterTypes, char[] returnType) {
        int parameterTypesLength = parameterTypes.length;
        int parameterLength = 0;
        int i = 0;
        while (i < parameterTypesLength) {
            parameterLength += parameterTypes[i].length;
            ++i;
        }
        int returnTypeLength = returnType.length;
        char[] result = new char[1 + parameterLength + 1 + returnTypeLength];
        result[0] = 40;
        int index = 1;
        int i2 = 0;
        while (i2 < parameterTypesLength) {
            char[] parameterType = parameterTypes[i2];
            int length = parameterType.length;
            System.arraycopy(parameterType, 0, result, index, length);
            index += length;
            ++i2;
        }
        result[index] = 41;
        System.arraycopy(returnType, 0, result, index + 1, returnTypeLength);
        return result;
    }

    public static String createMethodSignature(String[] parameterTypes, String returnType) {
        int parameterTypesLenth = parameterTypes.length;
        char[][] parameters = new char[parameterTypesLenth][];
        int i = 0;
        while (i < parameterTypesLenth) {
            parameters[i] = parameterTypes[i].toCharArray();
            ++i;
        }
        return new String(Signature.createMethodSignature(parameters, returnType.toCharArray()));
    }

    public static String createTypeSignature(char[] typeName, boolean isResolved) {
        return new String(Signature.createCharArrayTypeSignature(typeName, isResolved));
    }

    public static char[] createCharArrayTypeSignature(char[] typeName, boolean isResolved) {
        char[] sig;
        if (typeName == null) {
            throw new IllegalArgumentException("null");
        }
        int length = typeName.length;
        if (length == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        int arrayCount = CharOperation.occurencesOf('[', typeName);
        switch (typeName[0]) {
            case 'b': {
                if (CharOperation.fragmentEquals(BOOLEAN, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 90;
                    break;
                }
                if (CharOperation.fragmentEquals(BYTE, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 66;
                    break;
                }
            }
            case 'c': {
                if (CharOperation.fragmentEquals(CHAR, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 67;
                    break;
                }
            }
            case 'd': {
                if (CharOperation.fragmentEquals(DOUBLE, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 68;
                    break;
                }
            }
            case 'f': {
                if (CharOperation.fragmentEquals(FLOAT, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 70;
                    break;
                }
            }
            case 'i': {
                if (CharOperation.fragmentEquals(INT, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 73;
                    break;
                }
            }
            case 'l': {
                if (CharOperation.fragmentEquals(LONG, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 74;
                    break;
                }
            }
            case 's': {
                if (CharOperation.fragmentEquals(SHORT, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 83;
                    break;
                }
            }
            case 'v': {
                if (CharOperation.fragmentEquals(VOID, typeName, 0, true)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 86;
                    break;
                }
            }
            default: {
                int sigLength = arrayCount + 1 + length + 1;
                sig = new char[sigLength];
                int sigIndex = arrayCount + 1;
                int startID = 0;
                int index = 0;
                while (index < length) {
                    char currentChar = typeName[index];
                    switch (currentChar) {
                        case '.': {
                            if (startID == -1) {
                                throw new IllegalArgumentException(new String(typeName));
                            }
                            if (startID < index) {
                                sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                sigIndex += index - startID;
                            }
                            sig[sigIndex++] = 46;
                            startID = ++index;
                            break;
                        }
                        case '[': {
                            if (startID != -1) {
                                if (startID < index) {
                                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                    sigIndex += index - startID;
                                }
                                startID = -1;
                            }
                            ++index;
                            break;
                        }
                        default: {
                            if (startID != -1 && CharOperation.isWhitespace(currentChar)) {
                                if (startID < index) {
                                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                                    sigIndex += index - startID;
                                }
                                startID = index + 1;
                            }
                            ++index;
                        }
                    }
                }
                if (startID != -1 && startID < index) {
                    sig = CharOperation.append(sig, sigIndex, typeName, startID, index);
                    sigIndex += index - startID;
                }
                sig[arrayCount] = isResolved ? 76 : 81;
                sig[sigIndex++] = 59;
                if (sigLength <= sigIndex) break;
                char[] cArray = sig;
                sig = new char[sigIndex];
                System.arraycopy(cArray, 0, sig, 0, sigIndex);
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sig[i] = 91;
            ++i;
        }
        return sig;
    }

    public static String createTypeSignature(String typeName, boolean isResolved) {
        return Signature.createTypeSignature(typeName == null ? null : typeName.toCharArray(), isResolved);
    }

    public static int getArrayCount(char[] typeSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            while (typeSignature[count] == '[') {
                ++count;
            }
            return count;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getArrayCount(String typeSignature) throws IllegalArgumentException {
        return Signature.getArrayCount(typeSignature.toCharArray());
    }

    public static char[] getElementType(char[] typeSignature) throws IllegalArgumentException {
        int count = Signature.getArrayCount(typeSignature);
        if (count == 0) {
            return typeSignature;
        }
        int length = typeSignature.length;
        char[] result = new char[length - count];
        System.arraycopy(typeSignature, count, result, 0, length - count);
        return result;
    }

    public static String getElementType(String typeSignature) throws IllegalArgumentException {
        return new String(Signature.getElementType(typeSignature.toCharArray()));
    }

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature) + 1;
            if (i == 0) {
                throw new IllegalArgumentException();
            }
            block8: while (true) {
                char c = methodSignature[i++];
                switch (c) {
                    case '[': {
                        continue block8;
                    }
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        ++count;
                        continue block8;
                    }
                    case 'L': 
                    case 'Q': {
                        i = CharOperation.indexOf(';', methodSignature, i) + 1;
                        if (i == 0) {
                            throw new IllegalArgumentException();
                        }
                        ++count;
                        continue block8;
                    }
                    case ')': {
                        return count;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getParameterCount(String methodSignature) throws IllegalArgumentException {
        return Signature.getParameterCount(methodSignature.toCharArray());
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf('(', methodSignature) + 1;
            count = 0;
            int start = i;
            block19: while (true) {
                char c = methodSignature[i++];
                switch (c) {
                    case '[': {
                        continue block19;
                    }
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        if (i - start == 1) {
                            switch (c) {
                                case 'Z': {
                                    result[count++] = new char[]{'Z'};
                                    break;
                                }
                                case 'B': {
                                    result[count++] = new char[]{'B'};
                                    break;
                                }
                                case 'C': {
                                    result[count++] = new char[]{'C'};
                                    break;
                                }
                                case 'D': {
                                    result[count++] = new char[]{'D'};
                                    break;
                                }
                                case 'F': {
                                    result[count++] = new char[]{'F'};
                                    break;
                                }
                                case 'I': {
                                    result[count++] = new char[]{'I'};
                                    break;
                                }
                                case 'J': {
                                    result[count++] = new char[]{'J'};
                                    break;
                                }
                                case 'S': {
                                    result[count++] = new char[]{'S'};
                                    break;
                                }
                                case 'V': {
                                    result[count++] = new char[]{'V'};
                                }
                            }
                        } else {
                            result[count++] = CharOperation.subarray(methodSignature, start, i);
                        }
                        start = i;
                        continue block19;
                    }
                    case 'L': 
                    case 'Q': {
                        i = CharOperation.indexOf(';', methodSignature, i) + 1;
                        if (i == 0) {
                            throw new IllegalArgumentException();
                        }
                        result[count++] = CharOperation.subarray(methodSignature, start, i);
                        start = i;
                        continue block19;
                    }
                    case ')': {
                        return result;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static String[] getParameterTypes(String methodSignature) throws IllegalArgumentException {
        char[][] parameterTypes = Signature.getParameterTypes(methodSignature.toCharArray());
        int length = parameterTypes.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(parameterTypes[i]);
            ++i;
        }
        return result;
    }

    public static char[] getQualifier(char[] name) {
        int lastDot = CharOperation.lastIndexOf('.', name);
        if (lastDot == -1) {
            return CharOperation.NO_CHAR;
        }
        return CharOperation.subarray(name, 0, lastDot);
    }

    public static String getQualifier(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return EMPTY;
        }
        return name.substring(0, lastDot);
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        int i = CharOperation.lastIndexOf(')', methodSignature);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray(methodSignature, i + 1, methodSignature.length);
    }

    public static String getReturnType(String methodSignature) throws IllegalArgumentException {
        return new String(Signature.getReturnType(methodSignature.toCharArray()));
    }

    public static char[] getSimpleName(char[] name) {
        int lastDot = CharOperation.lastIndexOf('.', name);
        if (lastDot == -1) {
            return name;
        }
        return CharOperation.subarray(name, lastDot + 1, name.length);
    }

    public static String getSimpleName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1, name.length());
    }

    public static char[][] getSimpleNames(char[] name) {
        if (name.length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int dot = CharOperation.indexOf('.', name);
        if (dot == -1) {
            return new char[][]{name};
        }
        int n = 1;
        while ((dot = CharOperation.indexOf('.', name, dot + 1)) != -1) {
            ++n;
        }
        char[][] result = new char[n + 1][];
        int segStart = 0;
        int i = 0;
        while (i < n) {
            dot = CharOperation.indexOf('.', name, segStart);
            result[i] = CharOperation.subarray(name, segStart, dot);
            segStart = dot + 1;
            ++i;
        }
        result[n] = CharOperation.subarray(name, segStart, name.length);
        return result;
    }

    public static String[] getSimpleNames(String name) {
        char[][] simpleNames = Signature.getSimpleNames(name.toCharArray());
        int length = simpleNames.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(simpleNames[i]);
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        try {
            int firstParen = CharOperation.indexOf('(', methodSignature);
            if (firstParen == -1) {
                throw new IllegalArgumentException();
            }
            int sigLength = methodSignature.length;
            int paramCount = 0;
            int lastParen = -1;
            int resultLength = 0;
            int i = firstParen;
            block17: while (i < sigLength) {
                block34: {
                    switch (methodSignature[i]) {
                        case '[': {
                            resultLength += 2;
                            break block34;
                        }
                        case 'Z': {
                            resultLength += BOOLEAN.length;
                            break;
                        }
                        case 'B': {
                            resultLength += BYTE.length;
                            break;
                        }
                        case 'C': {
                            resultLength += CHAR.length;
                            break;
                        }
                        case 'D': {
                            resultLength += DOUBLE.length;
                            break;
                        }
                        case 'F': {
                            resultLength += FLOAT.length;
                            break;
                        }
                        case 'I': {
                            resultLength += INT.length;
                            break;
                        }
                        case 'J': {
                            resultLength += LONG.length;
                            break;
                        }
                        case 'S': {
                            resultLength += SHORT.length;
                            break;
                        }
                        case 'V': {
                            resultLength += VOID.length;
                            break;
                        }
                        case 'L': 
                        case 'Q': {
                            int start;
                            int end = CharOperation.indexOf(';', methodSignature, i);
                            if (end == -1) {
                                throw new IllegalArgumentException();
                            }
                            if (fullyQualifyTypeNames) {
                                start = i + 1;
                            } else {
                                start = CharOperation.lastIndexOf('.', methodSignature, i, end) + 1;
                                if (start == 0) {
                                    start = i + 1;
                                }
                            }
                            resultLength += end - start;
                            i = end;
                            break;
                        }
                        case '(': {
                            ++resultLength;
                            break block34;
                        }
                        case ')': {
                            lastParen = i;
                            if (includeReturnType) {
                                if (paramCount > 0) {
                                    resultLength -= 2;
                                }
                                --paramCount;
                                break block34;
                            } else {
                                if (paramCount > 0) {
                                    --resultLength;
                                    break block17;
                                }
                                ++resultLength;
                                break block17;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    resultLength += 2;
                    ++paramCount;
                }
                ++i;
            }
            int parameterNamesLength = parameterNames == null ? 0 : parameterNames.length;
            int i2 = 0;
            while (true) {
                block35: {
                    if (i2 < parameterNamesLength) break block35;
                }
                resultLength += parameterNames[i2].length + 1;
                ++i2;
            }
            int selectorLength = methodName == null ? 0 : methodName.length;
            char[] result = new char[resultLength += selectorLength];
            int index = 0;
            if (includeReturnType) {
                long pos = Signature.copyType(methodSignature, lastParen + 1, result, index, fullyQualifyTypeNames);
                index = (int)(pos >>> 32);
                result[index++] = 32;
            }
            if (methodName != null) {
                System.arraycopy(methodName, 0, result, index, selectorLength);
                index += selectorLength;
            }
            result[index++] = 40;
            int sigPos = firstParen + 1;
            int i3 = 0;
            while (true) {
                if (i3 >= paramCount) {
                    if (sigPos < sigLength) break;
                    throw new IllegalArgumentException();
                }
                long pos = Signature.copyType(methodSignature, sigPos, result, index, fullyQualifyTypeNames);
                index = (int)(pos >>> 32);
                sigPos = (int)pos;
                if (parameterNames != null) {
                    result[index++] = 32;
                    char[] parameterName = parameterNames[i3];
                    int paramLength = parameterName.length;
                    System.arraycopy(parameterName, 0, result, index, paramLength);
                    index += paramLength;
                }
                if (i3 != paramCount - 1) {
                    result[index++] = 44;
                    result[index++] = 32;
                }
                ++i3;
            }
            result[index++] = 41;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        try {
            int sigLength = signature.length;
            if (sigLength == 0 || signature[0] == '(') {
                return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
            }
            int resultLength = 0;
            int index = -1;
            while (signature[++index] == '[') {
                resultLength += 2;
            }
            switch (signature[index]) {
                case 'Z': {
                    resultLength += BOOLEAN.length;
                    break;
                }
                case 'B': {
                    resultLength += BYTE.length;
                    break;
                }
                case 'C': {
                    resultLength += CHAR.length;
                    break;
                }
                case 'D': {
                    resultLength += DOUBLE.length;
                    break;
                }
                case 'F': {
                    resultLength += FLOAT.length;
                    break;
                }
                case 'I': {
                    resultLength += INT.length;
                    break;
                }
                case 'J': {
                    resultLength += LONG.length;
                    break;
                }
                case 'S': {
                    resultLength += SHORT.length;
                    break;
                }
                case 'V': {
                    resultLength += VOID.length;
                    break;
                }
                case 'L': 
                case 'Q': {
                    int end = CharOperation.indexOf(';', signature, index);
                    if (end == -1) {
                        throw new IllegalArgumentException();
                    }
                    int start = index + 1;
                    resultLength += end - start;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            char[] result = new char[resultLength];
            Signature.copyType(signature, 0, result, 0, true);
            CharOperation.replace(result, '$', '.');
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[] toQualifiedName(char[][] segments) {
        int length = segments.length;
        if (length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (length == 1) {
            return segments[0];
        }
        int resultLength = 0;
        int i = 0;
        while (i < length) {
            resultLength += segments[i].length + 1;
            ++i;
        }
        char[] result = new char[--resultLength];
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            char[] segment = segments[i2];
            int segmentLength = segment.length;
            System.arraycopy(segment, 0, result, index, segmentLength);
            index += segmentLength;
            if (i2 != length - 1) {
                result[index++] = 46;
            }
            ++i2;
        }
        return result;
    }

    public static String toQualifiedName(String[] segments) {
        int length = segments.length;
        char[][] charArrays = new char[length][];
        int i = 0;
        while (i < length) {
            charArrays[i] = segments[i].toCharArray();
            ++i;
        }
        return new String(Signature.toQualifiedName(charArrays));
    }

    public static String toString(String signature) throws IllegalArgumentException {
        return new String(Signature.toCharArray(signature.toCharArray()));
    }

    public static String toString(String methodSignature, String methodName, String[] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        char[][] params;
        if (parameterNames == null) {
            params = null;
        } else {
            int paramLength = parameterNames.length;
            params = new char[paramLength][];
            int i = 0;
            while (i < paramLength) {
                params[i] = parameterNames[i].toCharArray();
                ++i;
            }
        }
        return new String(Signature.toCharArray(methodSignature.toCharArray(), methodName == null ? null : methodName.toCharArray(), params, fullyQualifyTypeNames, includeReturnType));
    }
}

