/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;

public final class JavaConventions {
    private static final char fgDot = '.';
    private static final Scanner SCANNER = new Scanner();

    private JavaConventions() {
    }

    private static int indexOfEnclosingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (!paths[i].equals((Object)checkedPath) && paths[i].isPrefixOf(checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfMatchingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (paths[i].equals((Object)checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfNestedPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (!checkedPath.equals((Object)paths[i]) && checkedPath.isPrefixOf(paths[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isOverlappingRoots(IPath rootPath1, IPath rootPath2) {
        if (rootPath1 == null || rootPath2 == null) {
            return false;
        }
        String extension1 = rootPath1.getFileExtension();
        String extension2 = rootPath2.getFileExtension();
        String jarExtension = "JAR";
        String zipExtension = "ZIP";
        if (extension1 != null && (extension1.equalsIgnoreCase(jarExtension) || extension1.equalsIgnoreCase(zipExtension))) {
            return false;
        }
        if (extension2 != null && (extension2.equalsIgnoreCase(jarExtension) || extension2.equalsIgnoreCase(zipExtension))) {
            return false;
        }
        return rootPath1.isPrefixOf(rootPath2) || rootPath2.isPrefixOf(rootPath1);
    }

    private static synchronized char[] scannedIdentifier(String id) {
        if (id == null) {
            return null;
        }
        String trimmed = id.trim();
        if (!trimmed.equals(id)) {
            return null;
        }
        try {
            char[] currentIdentifier;
            SCANNER.setSource(id.toCharArray());
            int token = SCANNER.getNextToken();
            try {
                currentIdentifier = SCANNER.getCurrentIdentifierSource();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            int nextToken = SCANNER.getNextToken();
            if (token == 6 && nextToken == 114 && JavaConventions.SCANNER.startPosition == JavaConventions.SCANNER.source.length) {
                return currentIdentifier;
            }
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    public static IStatus validateCompilationUnitName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.unit.nullName"), null);
        }
        if (!org.eclipse.jdt.internal.core.Util.isJavaFileName(name)) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.unit.notJavaName"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.unit.notJavaName"), null);
        }
        String identifier = name.substring(0, index);
        IStatus status = JavaConventions.validateIdentifier(identifier);
        if (!status.isOK()) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.classFile.nullName"), null);
        }
        if (!org.eclipse.jdt.internal.core.Util.isClassFileName(name)) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.classFile.notClassFileName"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.classFile.notClassFileName"), null);
        }
        String identifier = name.substring(0, index);
        IStatus status = JavaConventions.validateIdentifier(identifier);
        if (!status.isOK()) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return JavaConventions.validateIdentifier(name);
    }

    public static IStatus validateIdentifier(String id) {
        if (JavaConventions.scannedIdentifier(id) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.illegalIdentifier", id), null);
    }

    public static IStatus validateImportDeclaration(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.import.nullImport"), null);
        }
        if (name.charAt(name.length() - 1) == '*') {
            if (name.charAt(name.length() - 2) == '.') {
                return JavaConventions.validatePackageName(name.substring(0, name.length() - 2));
            }
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.import.unqualifiedImport"), null);
        }
        return JavaConventions.validatePackageName(name);
    }

    public static IStatus validateJavaTypeName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.type.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed)) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.type.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            scannedID = JavaConventions.scannedIdentifier(name);
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = JavaConventions.validatePackageName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + 1).trim();
            scannedID = JavaConventions.scannedIdentifier(type);
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.type.dollarName"), null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.type.lowercaseName"), null);
            }
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.type.invalidName", name), null);
    }

    public static IStatus validateMethodName(String name) {
        return JavaConventions.validateIdentifier(name);
    }

    public static IStatus validatePackageName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.nullName"), null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.emptyName"), null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.dotName"), null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.nameWithBlanks"), null);
        }
        int dot = 0;
        while (dot != -1 && dot < length - 1) {
            if ((dot = name.indexOf(46, dot + 1)) == -1 || dot >= length - 1 || name.charAt(dot + 1) != '.') continue;
            return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.consecutiveDotsName"), null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, new String(new char[]{'.'}));
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(typeName = typeName.trim());
            if (scannedID == null) {
                return new Status(4, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.illegalIdentifier", typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && Character.isUpperCase(scannedID[0])) {
                return new Status(2, "org.eclipse.jdt.core", -1, org.eclipse.jdt.internal.core.Util.bind("convention.package.uppercaseName"), null);
            }
            firstToken = false;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        int kind;
        IClasspathEntry entry;
        int index;
        IClasspathEntry resolvedEntry;
        IClasspathEntry[] classpath;
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        if (projectOutputLocation == null) {
            return new JavaModelStatus(970);
        }
        if (projectOutputLocation.isAbsolute()) {
            if (!projectPath.isPrefixOf(projectOutputLocation)) {
                return new JavaModelStatus(971, (IJavaElement)javaProject, projectOutputLocation.toString());
            }
        } else {
            return new JavaModelStatus(972, projectOutputLocation);
        }
        boolean hasSource = false;
        boolean hasLibFolder = false;
        if (rawClasspath == null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath(rawClasspath, null, true, false, null);
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        int length = classpath.length;
        int outputCount = 1;
        IPath[] outputLocations = new IPath[length + 1];
        boolean[] allowNestingInOutputLocations = new boolean[length + 1];
        outputLocations[0] = projectOutputLocation;
        IPath potentialNestedOutput = null;
        int sourceEntryCount = 0;
        int i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    ++sourceEntryCount;
                    if (resolvedEntry.getExclusionPatterns() != null && resolvedEntry.getExclusionPatterns().length > 0 && "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true))) {
                        return new JavaModelStatus(1002, resolvedEntry.getPath());
                    }
                    IPath customOutput = resolvedEntry.getOutputLocation();
                    if (customOutput == null) break;
                    if ("disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true))) {
                        return new JavaModelStatus(1003, resolvedEntry.getPath());
                    }
                    if (customOutput.isAbsolute()) {
                        if (!javaProject.getPath().isPrefixOf(customOutput)) {
                            return new JavaModelStatus(971, (IJavaElement)javaProject, customOutput.toString());
                        }
                    } else {
                        return new JavaModelStatus(972, customOutput);
                    }
                    index = JavaConventions.indexOfMatchingPath(customOutput, outputLocations, outputCount);
                    if (index != -1) break;
                    index = JavaConventions.indexOfEnclosingPath(customOutput, outputLocations, outputCount);
                    if (index != -1) {
                        if (index == 0) {
                            if (potentialNestedOutput == null) {
                                potentialNestedOutput = customOutput;
                            }
                        } else {
                            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestOutputInOutput", customOutput.makeRelative().toString(), outputLocations[index].makeRelative().toString()));
                        }
                    }
                    outputLocations[outputCount++] = resolvedEntry.getOutputLocation();
                }
            }
            ++i;
        }
        if (potentialNestedOutput != null && sourceEntryCount > outputCount - 1) {
            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestOutputInOutput", potentialNestedOutput.makeRelative().toString(), outputLocations[0].makeRelative().toString()));
        }
        i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            IPath path = resolvedEntry.getPath();
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    hasSource = true;
                    index = JavaConventions.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                    break;
                }
                case 1: {
                    hasLibFolder |= !Util.isArchiveFileName(path.lastSegment());
                    index = JavaConventions.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                }
            }
            ++i;
        }
        if (!hasSource && !hasLibFolder) {
            i = 0;
            while (i < outputCount) {
                allowNestingInOutputLocations[i] = true;
                ++i;
            }
        }
        HashSet<IPath> pathes = new HashSet<IPath>(length);
        int i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                if (!pathes.add(entryPath)) {
                    return new JavaModelStatus(977, org.eclipse.jdt.internal.core.Util.bind("classpath.duplicateEntryPath", entryPath.makeRelative().toString()));
                }
                if (entryPath.equals((Object)projectPath)) {
                    if (kind == 2) {
                        return new JavaModelStatus(979, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotReferToItself", entryPath.makeRelative().toString()));
                    }
                } else {
                    int index2;
                    if (kind == 3 || kind == 1 && !Util.isArchiveFileName(entryPath.lastSegment())) {
                        int j = 0;
                        while (j < classpath.length) {
                            IClasspathEntry otherEntry = classpath[j];
                            if (otherEntry != null) {
                                int otherKind = otherEntry.getEntryKind();
                                IPath otherPath = otherEntry.getPath();
                                if (entry != otherEntry && (otherKind == 3 || otherKind == 1 && !Util.isArchiveFileName(otherPath.lastSegment())) && otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath)) {
                                    char[][] exclusionPatterns = ((ClasspathEntry)otherEntry).fullExclusionPatternChars();
                                    if (!org.eclipse.jdt.internal.core.Util.isExcluded(entryPath.append("*"), exclusionPatterns)) {
                                        String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                        if (org.eclipse.jdt.internal.core.Util.isExcluded(entryPath, exclusionPatterns)) {
                                            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.mustEndWithSlash", exclusionPattern, entryPath.makeRelative().toString()));
                                        }
                                        if (otherKind == 3) {
                                            exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestEntryInEntry", new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString(), exclusionPattern}));
                                        }
                                        return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestEntryInLibrary", new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()}));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if ((index2 = JavaConventions.indexOfNestedPath(entryPath, outputLocations, outputCount)) != -1) {
                        return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestOutputInEntry", outputLocations[index2].makeRelative().toString(), entryPath.makeRelative().toString()));
                    }
                    index2 = JavaConventions.indexOfEnclosingPath(entryPath, outputLocations, outputCount);
                    if (!(index2 == -1 || allowNestingInOutputLocations[index2] || index2 == 0 && sourceEntryCount <= outputCount - 1)) {
                        return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotNestEntryInOutput", entryPath.makeRelative().toString(), outputLocations[index2].makeRelative().toString()));
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath output;
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                if (kind == 3 && (output = entry.getOutputLocation()) != null) {
                    int j = 0;
                    while (j < length) {
                        IClasspathEntry otherEntry = classpath[j];
                        if (otherEntry != entry) {
                            switch (otherEntry.getEntryKind()) {
                                case 3: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotUseDistinctSourceFolderAsOutput", entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()));
                                }
                                case 1: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.cannotUseLibraryAsOutput", entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IJavaModelStatus validateClasspathEntry(IJavaProject javaProject, IClasspathEntry entry, boolean checkSourceAttachment) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        switch (entry.getEntryKind()) {
            case 5: {
                if (path == null || path.segmentCount() < 1) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.illegalContainerPath", path.makeRelative().toString()));
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer(path, javaProject);
                    if (container == null) {
                        return new JavaModelStatus(963, (IJavaElement)javaProject, path);
                    }
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    if (containerEntries == null) return JavaModelStatus.VERIFIED_OK;
                    int i = 0;
                    int length = containerEntries.length;
                    while (i < length) {
                        int kind;
                        IClasspathEntry containerEntry = containerEntries[i];
                        int n = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                        if (containerEntry == null || kind == 3 || kind == 4 || kind == 5) {
                            String description = container.getDescription();
                            if (description != null) return new JavaModelStatus(962, (IJavaElement)javaProject, path);
                            description = path.makeRelative().toString();
                            return new JavaModelStatus(962, (IJavaElement)javaProject, path);
                        }
                        IJavaModelStatus containerEntryStatus = JavaConventions.validateClasspathEntry(javaProject, containerEntry, checkSourceAttachment);
                        if (!containerEntryStatus.isOK()) {
                            return containerEntryStatus;
                        }
                        ++i;
                    }
                    return JavaModelStatus.VERIFIED_OK;
                }
                catch (JavaModelException e) {
                    return new JavaModelStatus(e);
                }
            }
            case 4: {
                if (path == null || path.segmentCount() < 1) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.illegalVariablePath", path.makeRelative().toString()));
                if ((entry = JavaCore.getResolvedClasspathEntry(entry)) != null) return JavaConventions.validateClasspathEntry(javaProject, entry, checkSourceAttachment);
                return new JavaModelStatus(965, (IJavaElement)javaProject, path);
            }
            case 1: {
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.illegalLibraryPath", path.makeRelative().toString()));
                IPath sourceAttachment = entry.getSourceAttachmentPath();
                Object target = JavaModel.getTarget((IContainer)workspaceRoot, path, true);
                if (target instanceof IResource) {
                    IResource resolvedResource = (IResource)target;
                    switch (resolvedResource.getType()) {
                        case 1: {
                            if (!org.eclipse.jdt.internal.core.Util.isArchiveFileName(resolvedResource.getFileExtension()) || !checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundSourceAttachment", sourceAttachment.makeRelative().toString(), path.makeRelative().toString()));
                        }
                        case 2: {
                            if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                            return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundSourceAttachment", sourceAttachment.makeRelative().toString(), path.makeRelative().toString()));
                        }
                    }
                    return JavaModelStatus.VERIFIED_OK;
                }
                if (!(target instanceof File)) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundLibrary", path.makeRelative().toString()));
                if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) return JavaModelStatus.VERIFIED_OK;
                return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundSourceAttachment", sourceAttachment.toString(), path.makeRelative().toString()));
            }
            case 2: {
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.illegalProjectPath", path.segment(0).toString()));
                IProject project = workspaceRoot.getProject(path.segment(0));
                try {
                    if (!project.exists() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
                        return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundProject", path.makeRelative().segment(0).toString()));
                    }
                    if (project.isOpen()) return JavaModelStatus.VERIFIED_OK;
                    return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.closedProject", path.segment(0).toString()));
                }
                catch (CoreException coreException) {
                    return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundProject", path.segment(0).toString()));
                }
            }
            case 3: {
                if (entry.getExclusionPatterns() != null && entry.getExclusionPatterns().length > 0 && "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true))) {
                    return new JavaModelStatus(1002, path);
                }
                if (entry.getOutputLocation() != null && "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true))) {
                    return new JavaModelStatus(1003, path);
                }
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.illegalSourceFolderPath", path.makeRelative().toString()));
                IPath projectPath = javaProject.getProject().getFullPath();
                if (projectPath.isPrefixOf(path) && JavaModel.getTarget((IContainer)workspaceRoot, path, true) != null) return JavaModelStatus.VERIFIED_OK;
                return new JavaModelStatus(964, org.eclipse.jdt.internal.core.Util.bind("classpath.unboundSourceFolder", path.makeRelative().toString()));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

