/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class Templating
implements DocumentHandler {
    private Writer writer;
    private Map varNameToValue;
    private int ifCount = 0;

    public Templating(Writer writer, Map varNameToValue) {
        this.writer = writer;
        this.varNameToValue = varNameToValue;
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        if (this.ifCount == 0) {
            try {
                this.writer.write(chars, i, i1);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    public void processingInstruction(String s, String s1) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String s, AttributeList attributeList) throws SAXException {
        if (this.ifCount == 0) {
            if (s.equals("var")) {
                String result;
                String varName = attributeList.getValue("name");
                if (varName != null && (result = (String)this.varNameToValue.get(varName)) != null) {
                    try {
                        this.writer.write(result);
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                }
            } else if (s.equals("if")) {
                boolean isEqual;
                Object givenValue;
                String varName = attributeList.getValue("name");
                String value = attributeList.getValue("value");
                String not = attributeList.getValue("not");
                boolean bNot = false;
                if (not != null && not.equalsIgnoreCase("true")) {
                    bNot = true;
                }
                if (value == null) {
                    value = "";
                }
                if ((givenValue = this.varNameToValue.get(varName)) == null) {
                    givenValue = "";
                }
                if (!((isEqual = givenValue.equals(value)) && !bNot || !isEqual && bNot)) {
                    ++this.ifCount;
                }
            }
        } else if (s.equals("if")) {
            ++this.ifCount;
        }
    }

    public void endElement(String s) throws SAXException {
        if (s.equals("if") && this.ifCount > 0) {
            --this.ifCount;
        }
    }

    public static String writeTemplateToString(Map varNamesToValues, InputStream in) throws SAXException {
        StringWriter result = new StringWriter();
        Templating.writeTemplateToWriter(varNamesToValues, in, result);
        return result.toString();
    }

    public static void writeTemplateToWriter(Map varNamesToValues, InputStream in, Writer result) throws SAXException {
        Templating t = new Templating(result, varNamesToValues);
        try {
            Parser parser = SAXParserFactory.newInstance().newSAXParser().getParser();
            parser.setDocumentHandler(t);
            InputSource is = new InputSource(in);
            parser.parse(is);
            result.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }
}

