/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.util;

import com.sap.ip.me.mdk.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class Files {
    private static String[] filefound = new String[1000];
    private static int count;

    public static boolean isValidFileName(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            return false;
        }
        if (fileName.trim().length() != fileName.length()) {
            return false;
        }
        return !Strings.hasStringAnyOf(fileName, "\"*?<|>");
    }

    public static boolean isValidLocalFileName(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            return false;
        }
        return !Strings.hasStringAnyOf(fileName, "\"*?<|>:");
    }

    public static String[] checkValidWarJarFileName(String fullFileName, boolean jspApp) {
        String[] message = new String[]{" Invalid file name. No .-\"*?<|>&% characters", fullFileName, " It should not exceed 30 characters!", "", "", ""};
        if (fullFileName == null || fullFileName.trim().equals("")) {
            return message;
        }
        String fileName = fullFileName;
        int index = fileName.lastIndexOf("\\");
        if (index > 0) {
            fileName = fullFileName.substring(index + 1);
            message[3] = fullFileName.substring(0, index);
            message[4] = fileName;
            if (fileName.toLowerCase().endsWith(".war") || fileName.toLowerCase().endsWith(".jar")) {
                message[4] = fileName.substring(0, fileName.length() - 4);
            }
        }
        if (!Strings.hasStringAnyOf(fileName, ".")) {
            if (jspApp) {
                message[5] = ".war";
                message[1] = fullFileName + message[5];
            } else {
                message[5] = ".jar";
                message[1] = fullFileName + message[5];
            }
        }
        if ((index = fileName.lastIndexOf(".")) > 0) {
            fileName = fileName.substring(0, index);
        }
        if (fileName.length() < 31) {
            message[2] = null;
        }
        if (!Strings.hasStringAnyOf(fileName, ".-\"*?<|>&% ")) {
            message[0] = null;
        }
        return message;
    }

    public static String getFileName(String fullFileName) {
        String fileName = fullFileName;
        int index = fileName.lastIndexOf("\\");
        if (index > 0) {
            fileName = fullFileName.substring(index + 1);
        }
        return fileName;
    }

    public static String folderName(String folderName) {
        String temp = folderName;
        temp = temp.replace('/', ' ');
        temp = temp.replace(File.separatorChar, ' ');
        return temp.trim();
    }

    public static String generateSaveFileName(String name) {
        String temp = name;
        temp = temp.replace('&', '_');
        temp = temp.replace('%', '_');
        temp = temp.replace('^', '_');
        return temp;
    }

    public static void deleteFolders(String mainfolder, String subfolder) {
        boolean end = false;
        boolean root = true;
        File mainFolder = new File(mainfolder, subfolder);
        block0: while (!end) {
            File[] allSrcLibFolderChildren = mainFolder.listFiles();
            if (allSrcLibFolderChildren == null || allSrcLibFolderChildren.length == 0) {
                mainFolder.delete();
                mainFolder = new File(mainfolder, subfolder);
                if (root) {
                    end = true;
                    continue;
                }
                root = true;
                continue;
            }
            root = false;
            int j = 0;
            while (j < allSrcLibFolderChildren.length) {
                File tmp = new File(allSrcLibFolderChildren[j].toString());
                if (tmp.isDirectory()) {
                    mainFolder = new File(allSrcLibFolderChildren[j].toString());
                    continue block0;
                }
                allSrcLibFolderChildren[j].delete();
                ++j;
            }
        }
    }

    public static void copyFolders(String folderfrom, String folderto) {
        boolean end = false;
        boolean root = true;
        File fromFolder = new File(folderfrom);
        File toFolder = new File(folderto);
        File[] allSrcLibFolderChildren = fromFolder.listFiles();
        int j = 0;
        while (j < allSrcLibFolderChildren.length) {
            try {
                Files.copyFile(allSrcLibFolderChildren[j].toString(), folderto + "/" + Files.getFileName(allSrcLibFolderChildren[j].toString()));
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            ++j;
        }
    }

    public static String findTextinFile(File file, String[] extension, String searchString) throws Exception {
        String foundString = null;
        if (file.isDirectory()) {
            Object[] files = file.list();
            Arrays.sort(files);
            int i = 0;
            while (i < files.length) {
                foundString = Files.findTextinFile(new File(file, (String)files[i]), extension, searchString);
                if (foundString != null) {
                    return foundString;
                }
                ++i;
            }
        } else if (Files.validFileEnding(file.getPath(), extension) && (foundString = Files.checkForString(file, searchString)) != null) {
            return foundString;
        }
        return foundString;
    }

    public static String findVariableinBatFile(File file, String searchString, boolean caseSens, boolean all) throws Exception {
        String foundString = null;
        if (!file.isDirectory() && (foundString = Files.checkForStringinBatFile(file, searchString, caseSens, all)) != null) {
            return foundString;
        }
        return foundString;
    }

    private static boolean validFileEnding(String s, String[] extension) {
        int i = 0;
        while (i < extension.length) {
            if (s.endsWith(extension[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String checkForString(File file, String searchString) {
        String returnString = null;
        try {
            StringBuffer fileAsStringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            char[] charArray = new char[(int)file.length()];
            bufferedReader.read(charArray, 0, (int)file.length());
            fileAsStringBuffer.delete(0, fileAsStringBuffer.length());
            fileAsStringBuffer.append(charArray);
            int found = fileAsStringBuffer.toString().indexOf(searchString);
            if (found >= 0) {
                int foundend = fileAsStringBuffer.toString().indexOf(";", found);
                returnString = fileAsStringBuffer.toString().substring(found, foundend);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return returnString;
    }

    private static String checkForStringinBatFile(File file, String searchString, boolean caseSens, boolean all) {
        String returnString = null;
        try {
            StringBuffer fileAsStringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String batLine = null;
            String upperCasebatLine = null;
            while ((batLine = bufferedReader.readLine()) != null) {
                upperCasebatLine = batLine.trim().toUpperCase().trim();
                int foundend = 0;
                int found = -1;
                if (upperCasebatLine.startsWith("REM") || (found = caseSens ? batLine.indexOf(searchString) : batLine.toUpperCase().lastIndexOf(searchString.toUpperCase())) < 0) continue;
                foundend = batLine.toString().indexOf(";", found);
                if (!all) {
                    foundend = batLine.indexOf("\n", found);
                }
                returnString = foundend < 0 || all ? batLine.substring(found) : batLine.substring(found, foundend);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return returnString;
    }

    public static void deleteFile(String file) {
        File filet = new File(file);
        filet.delete();
    }

    public static String[] findFile(File dir, String extension) throws IOException {
        count = 0;
        int i = 0;
        while (i < filefound.length) {
            Files.filefound[i] = null;
            ++i;
        }
        Files.fileLoop(dir, extension);
        return filefound;
    }

    public static void fileLoop(File dir, String extension) throws IOException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            String filename = files[i].getPath().toString();
            if (Strings.endsWithIgnoreCase(filename, extension)) {
                Files.filefound[Files.count] = filename;
                ++count;
            }
            if (files[i].isDirectory()) {
                Files.fileLoop(files[i], extension);
            }
            ++i;
        }
    }

    public static String[] returnSubfolderOnly(String[] files, String rootdir) {
        String[] fileout = new String[1000];
        int lenroot = rootdir.length();
        int i = 0;
        while (i < files.length) {
            if (files[i] != null) {
                fileout[i] = files[i].substring(lenroot);
            }
            ++i;
        }
        return fileout;
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFile(String from_name, String to_name) throws IOException {
        IOException e42;
        FileOutputStream to;
        block17: {
            File from_file = new File(from_name);
            File to_file = new File(to_name);
            FileInputStream from = null;
            to = null;
            try {
                int bytes_read;
                try {
                    from = new FileInputStream(from_file);
                }
                catch (FileNotFoundException e2) {
                    JavaPlugin.log((Throwable)e2);
                }
                try {
                    if (!to_file.exists()) {
                        to_file.createNewFile();
                    }
                    to = new FileOutputStream(to_file);
                }
                catch (FileNotFoundException e3) {
                    JavaPlugin.log((Throwable)e3);
                }
                byte[] buffer = new byte[4096];
                while ((bytes_read = from.read(buffer)) != -1) {
                    void var7_9;
                    to.write(buffer, 0, (int)var7_9);
                }
                Object var9_10 = null;
                if (from == null) break block17;
            }
            catch (Throwable throwable) {
                IOException e42;
                Object var9_11 = null;
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException e42) {
                        JavaPlugin.log((Throwable)e42);
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException e42) {
                        JavaPlugin.log((Throwable)e42);
                    }
                }
                throw throwable;
            }
            try {
                from.close();
            }
            catch (IOException e42) {
                JavaPlugin.log((Throwable)e42);
            }
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException e42) {
                JavaPlugin.log((Throwable)e42);
            }
        }
    }

    public static String readFile(String from_name) throws IOException {
        File from_file = new File(from_name);
        Object from = null;
        StringBuffer sb = new StringBuffer();
        long len = from_file.length();
        char[] buffer = new char[(int)len];
        FileReader fr = new FileReader(from_file);
        fr.read(buffer);
        fr.close();
        return new String(buffer);
    }

    public static void writeFile(String to_name, String outs) throws IOException {
        File to_file = new File(to_name);
        FileOutputStream to = null;
        to = new FileOutputStream(to_file);
        byte[] buffer = new byte[outs.length()];
        buffer = outs.getBytes();
        to.write(buffer, 0, outs.length());
        to.close();
    }

    public static boolean doesFileExist(String file) {
        File from_file = new File(file);
        return from_file.isFile();
    }

    public static boolean isFolder(String folder) {
        boolean exist = false;
        File tmp = new File(folder);
        if (tmp.isDirectory()) {
            exist = true;
        }
        return exist;
    }
}

