/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.search;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

class SearchFiles {
    SearchFiles() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try {
            IndexSearcher searcher = new IndexSearcher("index");
            StandardAnalyzer analyzer = new StandardAnalyzer();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            block2: while (true) {
                System.out.print("Query: ");
                String line = in.readLine();
                if (line.length() == -1) {
                    searcher.close();
                    return;
                }
                Query query = QueryParser.parse((String)line, (String)"contents", (Analyzer)analyzer);
                System.out.println("Searching for: " + query.toString("contents"));
                Hits hits = searcher.search(query);
                System.out.println(hits.length() + " total matching documents");
                int HITS_PER_PAGE = 10;
                int start = 0;
                while (true) {
                    if (start >= hits.length()) continue block2;
                    int end = Math.min(hits.length(), start + 10);
                    int i = start;
                    while (true) {
                        if (i >= end) {
                            if (hits.length() <= end) break;
                            System.out.print("more (y/n) ? ");
                            line = in.readLine();
                            if (line.length() != 0 && line.charAt(0) != 'n') break;
                            continue block2;
                        }
                        Document doc = hits.doc(i);
                        String path = doc.get("path");
                        if (path != null) {
                            System.out.println(i + ". " + path);
                        } else {
                            String url = doc.get("url");
                            if (url != null) {
                                System.out.println(i + ". " + url);
                                System.out.println("   - " + doc.get("title"));
                            } else {
                                System.out.println(i + ". " + "No path nor URL for this document");
                            }
                        }
                        ++i;
                    }
                    start += 10;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }
}

